/*
 * Decompiled with CFR 0.152.
 */
package safety.com.br.android_shake_detector.core;

import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import safety.com.br.android_shake_detector.core.ShakeCallback;
import safety.com.br.android_shake_detector.core.ShakeOptions;

public class ShakeListener
implements SensorEventListener {
    private static final int SHAKE_SLOP_TIME_MS = 500;
    private OnShakeListener mListener;
    private long mShakeTimestamp;
    private int mShakeCount;
    private ShakeOptions shakeOptions;
    private Context context;

    public ShakeListener() {
    }

    public ShakeListener(ShakeOptions shakeOptions) {
        this.shakeOptions = shakeOptions;
    }

    public ShakeListener(ShakeOptions shakeOptions, Context context) {
        this.shakeOptions = shakeOptions;
        this.context = context;
    }

    public ShakeListener(ShakeOptions shakeOptions, Context context, ShakeCallback callback) {
        this.shakeOptions = shakeOptions;
        this.context = context;
    }

    public void setOnShakeListener(OnShakeListener listener) {
        this.mListener = listener;
    }

    public void resetShakeCount() {
        this.mShakeCount = 0;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        float x = event.values[0];
        float gX = x / 9.80665f;
        float y = event.values[1];
        float gY = y / 9.80665f;
        float z = event.values[2];
        float gZ = z / 9.80665f;
        float gForce = (float)Math.sqrt(gX * gX + gY * gY + gZ * gZ);
        if (gForce > this.shakeOptions.getSensibility()) {
            long now = System.currentTimeMillis();
            if (this.mShakeTimestamp + 500L > now) {
                return;
            }
            if (this.mShakeTimestamp + (long)this.shakeOptions.getInterval() < now) {
                this.mShakeCount = 0;
            }
            this.mShakeTimestamp = now;
            ++this.mShakeCount;
            if (this.shakeOptions.getShakeCounts() == this.mShakeCount) {
                this.sendToBroadCasts(this.context);
            }
        }
    }

    private void sendToBroadCasts(Context context) {
        Intent locationIntent = new Intent();
        locationIntent.setAction("shake.detector");
        context.sendBroadcast(locationIntent);
    }

    public static interface OnShakeListener {
        public void onShake(int var1);
    }
}

