/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeatureInput;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import com.saasquatch.jsonschemainferrer.RequiredPolicy;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RequiredPolicies {
    private RequiredPolicies() {
    }

    public static RequiredPolicy noOp() {
        return input -> null;
    }

    public static RequiredPolicy commonFields() {
        return input -> RequiredPolicies.handleCommonFields(input, false);
    }

    public static RequiredPolicy nonNullCommonFields() {
        return input -> RequiredPolicies.handleCommonFields(input, true);
    }

    @Nullable
    private static JsonNode handleCommonFields(@Nonnull GenericSchemaFeatureInput input, boolean nonNull) {
        Set<String> commonFieldNames = JunkDrawer.getCommonFieldNames(input.getSamples(), nonNull);
        if (commonFieldNames.isEmpty()) {
            return null;
        }
        return JunkDrawer.stringColToArrayDistinct(commonFieldNames);
    }
}

