/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class JunkDrawer {
    private JunkDrawer() {
    }

    static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    static <E> Stream<E> stream(@Nonnull Iterator<E> iter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 0), false);
    }

    static <E> Stream<E> stream(@Nonnull Iterable<E> iter) {
        if (iter instanceof Collection) {
            return ((Collection)iter).stream();
        }
        return StreamSupport.stream(iter.spliterator(), false);
    }

    static <K, V> Map.Entry<K, V> entryOf(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    @SafeVarargs
    static <E> Set<E> unmodifiableSetOf(E ... elements) {
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(elements)));
    }

    static <E extends Enum<E>> boolean isValidEnum(@Nonnull Class<E> enumClass, @Nullable String name) {
        if (name == null) {
            return false;
        }
        try {
            Enum.valueOf(enumClass, name);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static <E extends Enum<E>> boolean isValidEnumIgnoreCase(@Nonnull Class<E> enumClass, @Nullable String name) {
        if (name == null) {
            return false;
        }
        for (Enum enumConst : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConst.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    static ObjectNode newObject() {
        return JsonNodeFactory.instance.objectNode();
    }

    static ArrayNode newArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    static ArrayNode newArray(@Nonnull Collection<? extends JsonNode> elements) {
        return JunkDrawer.newArray().addAll(elements);
    }

    static ValueNode numberNode(@Nonnull BigInteger v) {
        try {
            return JsonNodeFactory.instance.numberNode(v.intValueExact());
        }
        catch (ArithmeticException arithmeticException) {
            try {
                return JsonNodeFactory.instance.numberNode(v.longValueExact());
            }
            catch (ArithmeticException arithmeticException2) {
                return JsonNodeFactory.instance.numberNode(v);
            }
        }
    }

    static ArrayNode stringColToArrayDistinct(@Nonnull Collection<String> strings) {
        ArrayNode result = JunkDrawer.newArray();
        if (strings instanceof Set) {
            strings.forEach(arg_0 -> ((ArrayNode)result).add(arg_0));
        } else {
            strings.stream().distinct().forEach(arg_0 -> ((ArrayNode)result).add(arg_0));
        }
        return result;
    }

    static Set<String> getAllFieldNames(@Nonnull Iterable<? extends JsonNode> objectNodes) {
        return JunkDrawer.stream(objectNodes).flatMap(j -> JunkDrawer.stream(j.fieldNames())).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static Stream<JsonNode> getAllValuesForFieldName(@Nonnull Iterable<? extends JsonNode> objectNodes, @Nonnull String fieldName) {
        return JunkDrawer.stream(objectNodes).map(j -> j.get(fieldName)).filter(Objects::nonNull);
    }

    @Nonnull
    static Set<String> getCommonFieldNames(@Nonnull Iterable<? extends JsonNode> samples, boolean requireNonNull) {
        LinkedHashSet commonFieldNames = null;
        for (JsonNode jsonNode : samples) {
            Set fieldNames = JunkDrawer.stream(jsonNode.fieldNames()).filter(Objects::nonNull).filter(requireNonNull ? fieldName -> JunkDrawer.nonNull(sample.get(fieldName)) : fieldName -> true).collect(Collectors.toCollection(LinkedHashSet::new));
            if (commonFieldNames == null) {
                commonFieldNames = new LinkedHashSet(fieldNames);
                continue;
            }
            commonFieldNames.retainAll(fieldNames);
        }
        return commonFieldNames == null || commonFieldNames.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(commonFieldNames);
    }

    static int getBase64Length(int bytesLength) {
        return (bytesLength + 2) / 3 * 4;
    }

    static int getSerializedTextLength(@Nonnull JsonNode jsonNode) {
        if (jsonNode instanceof BinaryNode) {
            byte[] binaryValue = ((BinaryNode)jsonNode).binaryValue();
            return JunkDrawer.getBase64Length(binaryValue.length);
        }
        if (JunkDrawer.isTextualFloat(jsonNode)) {
            return jsonNode.asText().length();
        }
        String textValue = jsonNode.textValue();
        if (textValue == null) {
            return -1;
        }
        return textValue.codePointCount(0, textValue.length());
    }

    static boolean isTextualFloat(@Nonnull JsonNode jsonNode) {
        if (jsonNode.isFloat() || jsonNode.isDouble()) {
            double doubleValue = jsonNode.doubleValue();
            return Double.isNaN(doubleValue) || Double.isInfinite(doubleValue);
        }
        return false;
    }

    static boolean isMathematicalInteger(double val) {
        return !Double.isNaN(val) && !Double.isInfinite(val) && val == Math.rint(val);
    }

    static boolean isMathematicalInteger(@Nonnull BigDecimal val) {
        return val.compareTo(BigDecimal.ZERO) == 0 || val.stripTrailingZeros().scale() <= 0;
    }

    static boolean isMathematicalIntegerNode(@Nonnull JsonNode numberNode) {
        if (!numberNode.isNumber()) {
            return false;
        }
        if (numberNode.isIntegralNumber()) {
            return true;
        }
        if (numberNode.isFloat() || numberNode.isDouble()) {
            return JunkDrawer.isMathematicalInteger(numberNode.doubleValue());
        }
        return JunkDrawer.isMathematicalInteger(numberNode.decimalValue());
    }

    static boolean isNull(@Nullable JsonNode j) {
        if (j == null || j.isNull() || j.isMissingNode()) {
            return true;
        }
        if (j instanceof TextNode) {
            return j.textValue() == null;
        }
        if (j instanceof BinaryNode) {
            return ((BinaryNode)j).binaryValue() == null;
        }
        if (j instanceof BigIntegerNode) {
            return j.bigIntegerValue() == null;
        }
        if (j instanceof DecimalNode) {
            return j.decimalValue() == null;
        }
        if (j instanceof POJONode) {
            return ((POJONode)j).getPojo() == null;
        }
        return false;
    }

    static boolean nonNull(@Nullable JsonNode j) {
        return !JunkDrawer.isNull(j);
    }

    static String escapeSingleQuoteString(@Nonnull String s) {
        return s.replace("\\", "\\\\").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("'", "\\'");
    }

    static String appendObjectJsonPath(@Nonnull String path, @Nonnull String fieldName) {
        return path + "['" + JunkDrawer.escapeSingleQuoteString(fieldName) + "']";
    }

    static String appendArrayStarJsonPath(@Nonnull String path) {
        return path + "[*]";
    }
}

