/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.saasquatch.jsonschemainferrer.ExamplesPolicy;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import com.saasquatch.jsonschemainferrer.SpecVersion;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ExamplesPolicies {
    private ExamplesPolicies() {
    }

    public static ExamplesPolicy noOp() {
        return input -> null;
    }

    public static ExamplesPolicy useFirstSamples(@Nonnegative int limit) {
        return ExamplesPolicies.useFirstSamples(limit, type -> true);
    }

    public static ExamplesPolicy useFirstSamples(@Nonnegative int limit, @Nonnull Predicate<String> typePredicate) {
        Objects.requireNonNull(typePredicate);
        if (limit < 0) {
            throw new IllegalArgumentException("Invalid limit");
        }
        if (limit == 0) {
            return ExamplesPolicies.noOp();
        }
        return input -> {
            if (input.getSpecVersion().compareTo(SpecVersion.DRAFT_06) < 0) {
                return null;
            }
            if (!typePredicate.test(input.getType())) {
                return null;
            }
            ArrayNode result = JunkDrawer.newArray();
            input.getSamples().stream().distinct().limit(limit).forEach(arg_0 -> ((ArrayNode)result).add(arg_0));
            return result.isEmpty() ? null : result;
        };
    }
}

