/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.saasquatch.jsonschemainferrer.DefaultPolicy;
import java.util.Collection;

public final class DefaultPolicies {
    private DefaultPolicies() {
    }

    public static DefaultPolicy noOp() {
        return input -> null;
    }

    public static DefaultPolicy useFirstSamples() {
        return input -> {
            Collection<? extends JsonNode> samples = input.getSamples();
            return samples.stream().findFirst().orElse(null);
        };
    }

    public static DefaultPolicy useLastSamples() {
        return input -> {
            Collection<? extends JsonNode> samples = input.getSamples();
            return samples.stream().skip(Math.max(0, samples.size() - 1)).findFirst().orElse(null);
        };
    }
}

