/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.saasquatch.jsonschemainferrer.FormatInferrer;
import com.saasquatch.jsonschemainferrer.FormatInferrerInput;
import com.saasquatch.jsonschemainferrer.SpecVersion;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

enum BuiltInFormatInferrer implements FormatInferrer
{
    NO_OP{

        @Override
        public String inferFormat(@Nonnull FormatInferrerInput input) {
            return null;
        }
    }
    ,
    DATE_TIME{
        private final Pattern timePattern = Pattern.compile("^(?:[01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](?:\\.\\d+)?(?:Z|[+-](?:0[0-9]|2[0-3]):[0-5][0-9])$");

        @Override
        public String inferFormat(@Nonnull FormatInferrerInput input) {
            String textValue = input.getSample().textValue();
            if (textValue == null) {
                return null;
            }
            try {
                ZonedDateTime.parse(textValue);
                return "date-time";
            }
            catch (Exception exception) {
                block6: {
                    if (input.getSpecVersion().compareTo(SpecVersion.DRAFT_07) >= 0) {
                        try {
                            LocalDate.parse(textValue);
                            return "date";
                        }
                        catch (Exception exception2) {
                            if (!this.timePattern.matcher(textValue).matches()) break block6;
                            return "time";
                        }
                    }
                }
                return null;
            }
        }
    }
    ,
    EMAIL{

        @Override
        public String inferFormat(@Nonnull FormatInferrerInput input) {
            String textValue = input.getSample().textValue();
            if (textValue == null) {
                return null;
            }
            if (EmailValidator.getInstance().isValid(textValue)) {
                return "email";
            }
            return null;
        }
    }
    ,
    IP{

        @Override
        public String inferFormat(@Nonnull FormatInferrerInput input) {
            String textValue = input.getSample().textValue();
            if (textValue == null) {
                return null;
            }
            if (InetAddressValidator.getInstance().isValidInet4Address(textValue)) {
                return "ipv4";
            }
            if (InetAddressValidator.getInstance().isValidInet6Address(textValue)) {
                return "ipv6";
            }
            return null;
        }
    };

}

