/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeature;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeatureInput;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import javax.annotation.Nonnull;

public enum ArrayLengthFeature implements GenericSchemaFeature
{
    MIN_ITEMS{

        @Override
        public ObjectNode getFeatureResult(@Nonnull GenericSchemaFeatureInput input) {
            if (!"array".equals(input.getType())) {
                return null;
            }
            ObjectNode result = JunkDrawer.newObject();
            input.getSamples().stream().filter(JsonNode::isArray).mapToInt(JsonNode::size).min().ifPresent(minItems -> result.put("minItems", minItems));
            return result;
        }
    }
    ,
    MAX_ITEMS{

        @Override
        public ObjectNode getFeatureResult(@Nonnull GenericSchemaFeatureInput input) {
            if (!"array".equals(input.getType())) {
                return null;
            }
            ObjectNode result = JunkDrawer.newObject();
            input.getSamples().stream().filter(JsonNode::isArray).mapToInt(JsonNode::size).max().ifPresent(maxItems -> result.put("maxItems", maxItems));
            return result;
        }
    };

}

