/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saasquatch.jsonschemainferrer.Consts;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeature;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeatureInput;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import java.util.Comparator;

public enum NumberRangeFeature implements GenericSchemaFeature
{
    MINIMUM{

        @Override
        public ObjectNode getFeatureResult(GenericSchemaFeatureInput input) {
            if (!Consts.Types.NUMBER_TYPES.contains(input.getType())) {
                return null;
            }
            return input.getSamples().stream().filter(JsonNode::isNumber).min(NUM_VALUE_COMPARATOR).map(minNode -> {
                ObjectNode result = JunkDrawer.newObject();
                result.set("minimum", minNode);
                return result;
            }).orElse(null);
        }
    }
    ,
    MAXIMUM{

        @Override
        public ObjectNode getFeatureResult(GenericSchemaFeatureInput input) {
            if (!Consts.Types.NUMBER_TYPES.contains(input.getType())) {
                return null;
            }
            return input.getSamples().stream().filter(JsonNode::isNumber).max(NUM_VALUE_COMPARATOR).map(maxNode -> {
                ObjectNode result = JunkDrawer.newObject();
                result.set("maximum", maxNode);
                return result;
            }).orElse(null);
        }
    };

    private static final Comparator<JsonNode> NUM_VALUE_COMPARATOR;

    static {
        NUM_VALUE_COMPARATOR = Comparator.comparing(JsonNode::decimalValue);
    }
}

