/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.jwt.support;

import com.github.ruifengho.simplesecurity.autoconfigure.SimpleSecurityProperties;
import com.github.ruifengho.simplesecurity.exception.SimpleSecurityException;
import com.github.ruifengho.simplesecurity.jwt.BaseJwtTokenParser;
import com.github.ruifengho.simplesecurity.jwt.support.DefaultJwtUser;
import io.jsonwebtoken.Claims;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class DefaultJwtTokenParser
extends BaseJwtTokenParser<DefaultJwtUser> {
    protected static final String USER_ID = "id";
    protected static final String USERNAME = "username";
    protected static final String PERMISSIONS = "permissions";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String BEARER = "Bearer ";

    public DefaultJwtTokenParser(SimpleSecurityProperties simpleSecurityProperties) {
        super(simpleSecurityProperties);
    }

    @Override
    protected Map<String, Object> getClaimsMap(DefaultJwtUser user) {
        HashMap<String, Object> claims = new HashMap<String, Object>(3);
        claims.put(USER_ID, user.getId());
        claims.put(USERNAME, user.getUserName());
        claims.put(PERMISSIONS, user.getPermissions());
        return claims;
    }

    @Override
    protected DefaultJwtUser getUserFromClaims(Claims claims) {
        List permissions = (List)claims.get((Object)PERMISSIONS);
        String userId = (String)claims.get((Object)USER_ID);
        String username = (String)claims.get((Object)USERNAME);
        return DefaultJwtUser.builder().id(userId).userName(username).permissions(permissions).build();
    }

    @Override
    protected String getTokenFromRequest(HttpServletRequest request) {
        String header = request.getHeader(AUTHORIZATION_HEADER);
        if (StringUtils.isEmpty((Object)header)) {
            throw new SimpleSecurityException("\u6ca1\u6709\u627e\u5230\u540d\u4e3aAuthorization\u7684header");
        }
        if (!header.startsWith(BEARER)) {
            throw new SimpleSecurityException("token\u5fc5\u987b\u4ee5'Bearer '\u5f00\u5934");
        }
        if (header.length() <= 7) {
            throw new SimpleSecurityException("token\u975e\u6cd5\uff0c\u957f\u5ea6 <= 7");
        }
        return header.substring(7);
    }
}

