/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.interceptor;

import com.github.ruifengho.simplesecurity.define.PermissionExpression;
import com.github.ruifengho.simplesecurity.define.PermissionExpressionParser;
import com.github.ruifengho.simplesecurity.exception.SimpleSecurityException;
import com.github.ruifengho.simplesecurity.util.AntPathMatcherUtil;
import com.github.ruifengho.simplesecurity.util.SpringElCheckUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PermissionsInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PermissionsInterceptor.class);
    private List<PermissionExpression> expressions;
    private PermissionExpressionParser permissionExpressionParser;

    public PermissionsInterceptor(List<PermissionExpression> expressions, PermissionExpressionParser permissionExpressionParser) {
        this.expressions = expressions;
        this.permissionExpressionParser = permissionExpressionParser;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean check = this.expressions.stream().filter(exp -> AntPathMatcherUtil.match(request, exp.getHttpMethod(), exp.getPath())).findFirst().map(exp -> SpringElCheckUtil.check((EvaluationContext)new StandardEvaluationContext((Object)this.permissionExpressionParser), exp.getExpression())).orElse(true);
        if (!check) {
            throw new SimpleSecurityException("Access Denied.");
        }
        return true;
    }
}

