/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.define;

import com.github.ruifengho.simplesecurity.jwt.BaseJwtTokenParser;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PermissionExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(PermissionExpressionParser.class);
    private BaseJwtTokenParser baseJwtTokenParser;

    public PermissionExpressionParser(BaseJwtTokenParser baseJwtTokenParser) {
        this.baseJwtTokenParser = baseJwtTokenParser;
    }

    public boolean anon() {
        return true;
    }

    public boolean hasLogin() {
        return this.baseJwtTokenParser.getUser() != null;
    }

    public boolean hasRole(String role) {
        return this.hasAnyRoles(role);
    }

    public boolean hasAllRoles(String ... roles) {
        Object user = this.baseJwtTokenParser.getUser();
        if (user == null) {
            return false;
        }
        List<String> userRoles = user.getPermissions();
        if (CollectionUtils.isEmpty(userRoles)) {
            return false;
        }
        List<String> roleList = Arrays.asList(roles);
        return userRoles.containsAll(roleList);
    }

    public boolean hasAnyRoles(String ... roles) {
        Object user = this.baseJwtTokenParser.getUser();
        if (user == null) {
            return false;
        }
        List<String> userRoles = user.getPermissions();
        List<String> roleList = Arrays.asList(roles);
        if (CollectionUtils.isEmpty(userRoles)) {
            return false;
        }
        boolean checkResult = userRoles.stream().anyMatch(roleList::contains);
        if (!checkResult) {
            logger.warn("\u6743\u9650\u4e0d\u5339\u914d\uff0cuserRolesFromToken = {}, roles = {}", userRoles, (Object)roles);
        }
        return checkResult;
    }
}

