/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.autoconfigure;

import com.github.ruifengho.simplesecurity.autoconfigure.SimpleSecurityConfiguration;
import com.github.ruifengho.simplesecurity.autoconfigure.SimpleSecurityProperties;
import com.github.ruifengho.simplesecurity.define.PermissionExpressionParser;
import com.github.ruifengho.simplesecurity.interceptor.PermissionsInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={SimpleSecurityConfiguration.class})
public class SimpleSecurityWebMvcConfigurer
implements WebMvcConfigurer {
    private SimpleSecurityProperties simpleSecurityProperties;
    private PermissionExpressionParser permissionExpressionParser;

    public SimpleSecurityWebMvcConfigurer(SimpleSecurityProperties simpleSecurityProperties, PermissionExpressionParser permissionExpressionParser) {
        this.simpleSecurityProperties = simpleSecurityProperties;
        this.permissionExpressionParser = permissionExpressionParser;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new PermissionsInterceptor(this.simpleSecurityProperties.getExpressionList(), this.permissionExpressionParser));
    }
}

