/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.jwt.support;

import com.github.ruifengho.simplesecurity.jwt.JwtUser;
import java.beans.ConstructorProperties;
import java.util.List;

public class DefaultJwtUser
implements JwtUser {
    private String id;
    private String userName;
    private List<String> permissions;

    @ConstructorProperties(value={"id", "userName", "permissions"})
    DefaultJwtUser(String id, String userName, List<String> permissions) {
        this.id = id;
        this.userName = userName;
        this.permissions = permissions;
    }

    public static DefaultUserBuilder builder() {
        return new DefaultUserBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public List<String> getPermissions() {
        return this.permissions;
    }

    public static class DefaultUserBuilder {
        private String id;
        private String userName;
        private List<String> permissions;

        DefaultUserBuilder() {
        }

        public DefaultUserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DefaultUserBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public DefaultUserBuilder permissions(List<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public DefaultJwtUser build() {
            return new DefaultJwtUser(this.id, this.userName, this.permissions);
        }

        public String toString() {
            return "DefaultJwtUser.DefaultUserBuilder(id=" + this.id + ", userName=" + this.userName + ", permissions=" + this.permissions + ")";
        }
    }
}

