/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.github.rubensousa.gravitysnaphelper.GravityDelegate;
import com.github.rubensousa.gravitysnaphelper.GravitySnapHelper;

public class GravityPagerSnapHelper
extends PagerSnapHelper {
    @NonNull
    private final GravityDelegate delegate;

    public GravityPagerSnapHelper(int gravity) {
        this(gravity, false, null);
    }

    public GravityPagerSnapHelper(int gravity, boolean enableSnapLastItem) {
        this(gravity, enableSnapLastItem, null);
    }

    public GravityPagerSnapHelper(int gravity, boolean enableSnapLastItem, @Nullable GravitySnapHelper.SnapListener snapListener) {
        this.delegate = new GravityDelegate(gravity, enableSnapLastItem, snapListener);
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null && (!(recyclerView.getLayoutManager() instanceof LinearLayoutManager) || recyclerView.getLayoutManager() instanceof GridLayoutManager)) {
            throw new IllegalStateException("GravityPagerSnapHelper needs a RecyclerView with a LinearLayoutManager");
        }
        this.delegate.attachToRecyclerView(recyclerView);
        super.attachToRecyclerView(recyclerView);
    }

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        return this.delegate.calculateDistanceToFinalSnap(layoutManager, targetView);
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        return this.delegate.findSnapView(layoutManager);
    }

    public void enableLastItemSnap(boolean snap) {
        this.delegate.enableLastItemSnap(snap);
    }

    public void smoothScrollToPosition(int position) {
        this.delegate.smoothScrollToPosition(position);
    }

    public void scrollToPosition(int position) {
        this.delegate.scrollToPosition(position);
    }

    public int getCurrentSnappedPosition() {
        return this.delegate.getCurrentSnappedPosition();
    }
}

