/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class OrientationAwareRecyclerView
extends RecyclerView {
    private float lastX = 0.0f;
    private float lastY = 0.0f;
    private int orientation = 1;
    private boolean scrolling = false;

    public OrientationAwareRecyclerView(@NonNull Context context) {
        this(context, null);
    }

    public OrientationAwareRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OrientationAwareRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                OrientationAwareRecyclerView.this.scrolling = newState != 0;
            }
        });
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layout) {
        super.setLayoutManager(layout);
        if (layout instanceof LinearLayoutManager) {
            this.orientation = ((LinearLayoutManager)layout).getOrientation();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        boolean allowScroll = true;
        switch (e.getActionMasked()) {
            case 0: {
                this.lastX = e.getX();
                this.lastY = e.getY();
                if (!this.scrolling) break;
                MotionEvent newEvent = MotionEvent.obtain((MotionEvent)e);
                newEvent.setAction(1);
                return super.onInterceptTouchEvent(newEvent);
            }
            case 2: {
                float currentX = e.getX();
                float currentY = e.getY();
                float dx = Math.abs(currentX - this.lastX);
                float dy = Math.abs(currentY - this.lastY);
                allowScroll = dy > dx ? this.orientation == 1 : this.orientation == 0;
                break;
            }
        }
        if (!allowScroll) {
            return false;
        }
        return super.onInterceptTouchEvent(e);
    }
}

