package gopher.impl

import cps._
import gopher._
import scala.util._

class DelayedReadChannel[F[_]:CpsSchedulingMonad,T](fch: F[ReadChannel[F,T]])(using Gopher[F]) extends ReadChannel[F,T] {

  override def asyncMonad = summon[CpsSchedulingMonad[F]]
  def gopherApi = summon[Gopher[F]]

  def addReader(reader: Reader[T]): Unit = {
    gopherApi.spawnAndLogFail{
      asyncMonad.mapTry(fch){ r =>
        r match
          case Success(ch) => ch.addReader(reader)
          case Failure(ex) =>
            reader.capture().foreach{ f =>
              f(Failure(ex))
            }
      }
    }
  }

  def addDoneReader(reader: Reader[Unit]): Unit = {
    gopherApi.spawnAndLogFail{
      asyncMonad.mapTry(fch){ r =>
        r match
          case Success(ch) => ch.addDoneReader(reader)
          case Failure(ex) =>
            reader.capture().foreach{ f =>
              f(Failure(ex))
            }
      }
    }
  }  

}
