/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.samples;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class Trace
implements MethodInterceptor {
    int ident = 1;
    static Trace callback = new Trace();

    private Trace() {
    }

    public static Object newInstance(Class clazz) {
        try {
            Enhancer e = new Enhancer();
            e.setSuperclass(clazz);
            e.setCallback((Callback)callback);
            return e.create();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
    }

    public static void main(String[] args) {
        List list = (List)Trace.newInstance(Vector.class);
        String value = "TEST";
        list.add(value);
        list.contains(value);
        try {
            list.set(2, "ArrayIndexOutOfBounds");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        list.add(value + "1");
        list.add(value + "2");
        list.toString();
        list.equals(list);
        list.set(0, null);
        list.toString();
        list.add(list);
        list.get(1);
        list.toArray();
        list.remove(list);
        list.remove("");
        list.containsAll(list);
        list.lastIndexOf(value);
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        this.printIdent(this.ident);
        System.out.println(method);
        for (int i = 0; i < args.length; ++i) {
            this.printIdent(this.ident);
            System.out.print("arg" + (i + 1) + ": ");
            if (obj == args[i]) {
                System.out.println("this");
                continue;
            }
            System.out.println(args[i]);
        }
        ++this.ident;
        Object retValFromSuper = null;
        try {
            retValFromSuper = proxy.invokeSuper(obj, args);
            --this.ident;
        }
        catch (Throwable t) {
            --this.ident;
            this.printIdent(this.ident);
            System.out.println("throw " + t);
            System.out.println();
            throw t.fillInStackTrace();
        }
        this.printIdent(this.ident);
        System.out.print("return ");
        if (obj == retValFromSuper) {
            System.out.println("this");
        } else {
            System.out.println(retValFromSuper);
        }
        if (this.ident == 1) {
            System.out.println();
        }
        return retValFromSuper;
    }

    void printIdent(int ident) {
        while (--ident > 0) {
            System.out.print(".......");
        }
        System.out.print("  ");
    }
}

