/*
 * Decompiled with CFR 0.152.
 */
package com.itsronald.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Px;
import android.support.v4.view.ViewCompat;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.itsronald.widget.IndicatorDotView;

class IndicatorDotPathView
extends ViewGroup {
    private static final long PATH_STRETCH_ANIM_DURATION = 150L;
    private static final long PATH_RETREAT_ANIM_DURATION = 100L;
    static final int PATH_DIRECTION_LEFT = 0;
    static final int PATH_DIRECTION_RIGHT = 1;
    @Px
    private int dotPadding;
    @Px
    private int dotRadius;
    @NonNull
    private final IndicatorDotView startDot;
    @NonNull
    private final IndicatorDotView endDot;
    @NonNull
    private final DotPathSegment startPathSegment;
    @NonNull
    private final DotPathSegment endPathSegment;
    @NonNull
    private final ImageView centerSegment;
    @NonNull
    private final ShapeDrawable centerPathShape = new ShapeDrawable((Shape)new RectShape());

    IndicatorDotPathView(@NonNull Context context) {
        super(context);
        float scale = context.getResources().getDisplayMetrics().density;
        this.dotPadding = (int)((double)(9.0f * scale) + 0.5);
        this.dotRadius = (int)((double)(3.0f * scale) + 0.5);
        this.startDot = new IndicatorDotView(context);
        this.endDot = new IndicatorDotView(context);
        this.startPathSegment = new DotPathSegment(context);
        this.endPathSegment = new DotPathSegment(context);
        this.centerSegment = new ImageView(context);
        this.centerSegment.setImageDrawable((Drawable)this.centerPathShape);
        this.init(-3355444);
    }

    IndicatorDotPathView(@NonNull Context context, @ColorInt int dotColor, @Px int dotPadding, @Px int dotRadius) {
        this(context);
        this.dotPadding = dotPadding;
        this.dotRadius = dotRadius;
        this.setDotColor(dotColor);
        this.setDotPadding(dotPadding);
        this.setDotRadius(dotRadius);
    }

    private void init(@ColorInt int dotColor) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        this.addView((View)this.startDot, -1, layoutParams);
        this.addView((View)this.endDot, -1, layoutParams);
        this.addView((View)this.startPathSegment, -1, layoutParams);
        this.addView((View)this.endPathSegment, -1, layoutParams);
        this.addView((View)this.centerSegment, -1, layoutParams);
        this.centerSegment.setVisibility(8);
        this.setDotColor(dotColor);
        this.setDotPadding(this.dotPadding);
        this.setDotRadius(this.dotRadius);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int dotDiameter = 2 * this.dotRadius;
        int top = this.getPaddingTop();
        int bottom = top + dotDiameter;
        int left = this.getPaddingLeft();
        this.startDot.layout(left, top, left + dotDiameter, bottom);
        this.startPathSegment.layout(left, top, left + dotDiameter, bottom);
        this.centerSegment.layout(left += this.dotRadius, top, left + this.dotPadding + dotDiameter, bottom);
        this.endDot.layout(left += this.dotRadius + this.dotPadding, top, left + dotDiameter, bottom);
        this.endPathSegment.layout(left, top, left + dotDiameter, bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int childWidthSpec = IndicatorDotPathView.getChildMeasureSpec((int)widthMeasureSpec, (int)widthPadding, (int)-2);
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int childHeightSpec = IndicatorDotPathView.getChildMeasureSpec((int)heightMeasureSpec, (int)heightPadding, (int)-2);
        this.startDot.measure(childWidthSpec, childHeightSpec);
        this.startPathSegment.measure(childWidthSpec, childHeightSpec);
        this.endDot.measure(childWidthSpec, childHeightSpec);
        this.endPathSegment.measure(childWidthSpec, childHeightSpec);
        this.centerSegment.measure(childWidthSpec, childHeightSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0x40000000) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        } else {
            int totalDotWidth = this.startDot.getMeasuredWidth() + this.endDot.getMeasuredWidth();
            int minWidth = ViewCompat.getMinimumWidth((View)this);
            width = Math.max(minWidth, totalDotWidth + this.dotPadding + widthPadding);
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else {
            int indicatorHeight = this.startDot.getMeasuredHeight();
            int minHeight = ViewCompat.getMinimumHeight((View)this);
            height = Math.max(minHeight, indicatorHeight + heightPadding);
        }
        int childState = ViewCompat.getMeasuredHeightAndState((View)this.startDot);
        int measuredHeight = ViewCompat.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)childState);
        this.setMeasuredDimension(width, measuredHeight);
    }

    @ColorInt
    int getDotColor() {
        return this.startDot.getColor();
    }

    void setDotColor(@ColorInt int dotColor) {
        this.startDot.setColor(dotColor);
        this.endDot.setColor(dotColor);
        this.startPathSegment.setColor(dotColor);
        this.endPathSegment.setColor(dotColor);
        this.centerPathShape.getPaint().setColor(dotColor);
        this.invalidate();
    }

    @Px
    int getDotPadding() {
        return this.dotPadding;
    }

    void setDotPadding(@Px int dotPadding) {
        this.dotPadding = dotPadding;
        this.centerPathShape.setIntrinsicWidth(dotPadding + 2 * this.dotRadius);
        this.invalidate();
        this.requestLayout();
    }

    @Px
    int getDotRadius() {
        return this.dotRadius;
    }

    void setDotRadius(@Px int dotRadius) {
        this.startDot.setRadius(dotRadius);
        this.endDot.setRadius(dotRadius);
        this.startPathSegment.setRadius(dotRadius);
        this.endPathSegment.setRadius(dotRadius);
        int dotDiameter = 2 * dotRadius;
        this.centerPathShape.setIntrinsicWidth(this.dotPadding + dotDiameter);
        this.centerPathShape.setIntrinsicHeight(dotDiameter);
        this.invalidate();
        this.requestLayout();
    }

    @NonNull
    Animator connectPathAnimator() {
        Rect startSegmentBounds = this.viewRectInNeighborCoords((View)this.startPathSegment, (View)this.endPathSegment);
        Rect endSegmentBounds = this.viewRectInNeighborCoords((View)this.endPathSegment, (View)this.startPathSegment);
        int startSegmentToX = endSegmentBounds.centerX() < 0 ? endSegmentBounds.left : endSegmentBounds.right;
        int startSegmentToY = endSegmentBounds.centerY() < 0 ? endSegmentBounds.top : endSegmentBounds.bottom;
        int endSegmentToX = startSegmentBounds.centerX() < 0 ? startSegmentBounds.left : startSegmentBounds.right;
        int endSegmentToY = startSegmentBounds.centerY() < 0 ? startSegmentBounds.top : startSegmentBounds.bottom;
        Animator startSegmentAnimator = this.startPathSegment.stretchAnimator(150L, startSegmentToX, startSegmentToY);
        Animator endSegmentAnimator = this.endPathSegment.stretchAnimator(150L, endSegmentToX, endSegmentToY);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{startSegmentAnimator, endSegmentAnimator, this.centerSegmentGrowAnimator()});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                IndicatorDotPathView.this.startDot.setVisibility(0);
                IndicatorDotPathView.this.endDot.setVisibility(0);
            }
        });
        return animatorSet;
    }

    @NonNull
    private Animator centerSegmentGrowAnimator() {
        ObjectAnimator growAnimator;
        float fromScale = 0.0f;
        float toScale = 1.0f;
        if (Build.VERSION.SDK_INT >= 14) {
            PropertyValuesHolder scaleYProperty = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.0f, 1.0f});
            growAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.centerSegment, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleYProperty});
        } else {
            growAnimator = ObjectAnimator.ofFloat((Object)this.centerSegment, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        }
        long animationDuration = 37L;
        growAnimator.setStartDelay(37L);
        growAnimator.setDuration(37L);
        growAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                IndicatorDotPathView.this.centerSegment.setVisibility(0);
            }
        });
        return growAnimator;
    }

    @NonNull
    private Rect viewRectInNeighborCoords(@NonNull View view, @NonNull View neighbor) {
        Rect bounds = new Rect();
        view.getDrawingRect(bounds);
        this.offsetDescendantRectToMyCoords(view, bounds);
        this.offsetRectIntoDescendantCoords(neighbor, bounds);
        return bounds;
    }

    @NonNull
    Animator retreatConnectedPathAnimator(int pathDirection) {
        IndicatorDotView fromDot = pathDirection == 1 ? this.startDot : this.endDot;
        IndicatorDotView toDot = pathDirection == 0 ? this.startDot : this.endDot;
        return this.retreatConnectedPathAnimator(fromDot, toDot);
    }

    @NonNull
    private Animator retreatConnectedPathAnimator(@NonNull IndicatorDotView fromDot, @NonNull IndicatorDotView toDot) {
        Rect endDotBounds = this.viewRectInNeighborCoords((View)toDot, (View)fromDot);
        float toX = endDotBounds.left;
        float toY = endDotBounds.top;
        Animator dotRetreatAnimator = this.retreatDotAnimator(fromDot, toX, toY, 100L);
        endDotBounds = this.viewRectInNeighborCoords((View)toDot, (View)this.centerSegment);
        toX = endDotBounds.centerX() <= 0 ? 0.0f : (float)this.centerSegment.getWidth();
        toY = endDotBounds.centerY() <= 0 ? 0.0f : (float)this.centerSegment.getHeight();
        Animator pathRetreatAnimator = this.retreatCenterSegmentAnimator(toX, toY, 100L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{dotRetreatAnimator, pathRetreatAnimator});
        return animatorSet;
    }

    @NonNull
    private Animator retreatDotAnimator(final @NonNull IndicatorDotView retreatingDot, float toX, float toY, long animationDuration) {
        Animator dotSlideAnimator = retreatingDot.slideAnimator(toX, toY, animationDuration);
        final float originalTranslationX = retreatingDot.getTranslationX();
        final float originalTranslationY = retreatingDot.getTranslationY();
        dotSlideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                retreatingDot.setVisibility(4);
                retreatingDot.setTranslationX(originalTranslationX);
                retreatingDot.setTranslationY(originalTranslationY);
            }
        });
        return dotSlideAnimator;
    }

    @NonNull
    private Animator retreatCenterSegmentAnimator(float toX, float toY, long animationDuration) {
        float originalScale = 1.0f;
        float scaleX = 0.0f;
        float scaleY = 1.0f;
        Animator animator = IndicatorDotPathView.scaleAnimator((View)this.centerSegment, 1.0f, 0.0f, 1.0f);
        final float originalPivotX = this.getPivotX();
        final float originalPivotY = this.getPivotY();
        final float pivotX = Math.max(0.0f, Math.min(toX, (float)this.centerSegment.getWidth()));
        final float pivotY = Math.max(0.0f, Math.min(toY, (float)this.centerSegment.getHeight()));
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                IndicatorDotPathView.this.centerSegment.setPivotX(pivotX);
                IndicatorDotPathView.this.centerSegment.setPivotY(pivotY);
            }

            public void onAnimationEnd(Animator animation) {
                IndicatorDotPathView.this.centerSegment.setVisibility(4);
                IndicatorDotPathView.this.centerSegment.setScaleX(1.0f);
                IndicatorDotPathView.this.centerSegment.setScaleY(1.0f);
                IndicatorDotPathView.this.centerSegment.setPivotX(originalPivotX);
                IndicatorDotPathView.this.centerSegment.setPivotY(originalPivotY);
            }
        });
        animator.setDuration(animationDuration);
        return animator;
    }

    @NonNull
    private static Animator scaleAnimator(View view, float originalScale, float scaleX, float scaleY) {
        ObjectAnimator animator;
        if (Build.VERSION.SDK_INT >= 14) {
            PropertyValuesHolder scaleXProperty = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{originalScale, scaleX});
            PropertyValuesHolder scaleYProperty = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{originalScale, scaleY});
            animator = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleXProperty, scaleYProperty});
        } else {
            ObjectAnimator scaleXAnimator = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{originalScale, scaleX});
            ObjectAnimator scaleYAnimator = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{originalScale, scaleY});
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{scaleXAnimator, scaleYAnimator});
            animator = animatorSet;
        }
        return animator;
    }

    private static class DotPathSegment
    extends IndicatorDotView {
        DotPathSegment(@NonNull Context context) {
            super(context);
        }

        @NonNull
        Animator stretchAnimator(long animationDuration, final float toX, final float toY) {
            float distanceX = Math.abs(toX) + (float)(toX < 0.0f ? this.getWidth() : 0);
            float distanceY = Math.abs(toY) + (float)(toY < 0.0f ? this.getHeight() : 0);
            float scaleX = distanceX / (float)this.getWidth();
            float scaleY = distanceY / (float)this.getHeight();
            float originalScale = 1.0f;
            Animator animator = IndicatorDotPathView.scaleAnimator((View)this, 1.0f, scaleX, scaleY);
            animator.setDuration(animationDuration);
            final float originalPivotX = this.getPivotX();
            final float originalPivotY = this.getPivotY();
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    DotPathSegment.this.setVisibility(0);
                    DotPathSegment.this.setStretchAnimatorPivot(toX, toY);
                }

                public void onAnimationEnd(Animator animation) {
                    DotPathSegment.this.setVisibility(4);
                    DotPathSegment.this.setScaleX(1.0f);
                    DotPathSegment.this.setScaleY(1.0f);
                    DotPathSegment.this.setStretchAnimatorPivot(originalPivotX, originalPivotY);
                }
            });
            return animator;
        }

        private void setStretchAnimatorPivot(float toX, float toY) {
            float pivotX = (float)this.getWidth() - Math.max(0.0f, Math.min(toX, (float)this.getWidth()));
            float pivotY = (float)this.getHeight() - Math.max(0.0f, Math.min(toY, (float)this.getHeight()));
            this.setPivotX(pivotX);
            this.setPivotY(pivotY);
        }
    }
}

