/*
 * Decompiled with CFR 0.152.
 */
package com.itsronald.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.widget.ImageView;
import com.itsronald.widget.R;

class IndicatorDotView
extends ImageView {
    @NonNull
    private static final String TAG = "IndicatorDotView";
    @Dimension
    static final int DEFAULT_DOT_RADIUS_DIP = 3;
    @ColorInt
    static final int DEFAULT_DOT_COLOR = -3355444;
    @ColorInt
    static final int DEFAULT_UNSELECTED_DOT_COLOR = -3355444;
    @ColorInt
    static final int DEFAULT_SELECTED_DOT_COLOR = -1;
    private static final long REVEAL_ANIM_DURATION = 100L;
    @NonNull
    private final ShapeDrawable dot = new ShapeDrawable((Shape)new OvalShape());
    @Px
    private int dotRadius;

    public IndicatorDotView(@NonNull Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public IndicatorDotView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public IndicatorDotView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public IndicatorDotView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.IndicatorDotView, defStyleAttr, defStyleRes);
        float scale = this.getResources().getDisplayMetrics().density;
        int defaultDotRadius = (int)((double)(3.0f * scale) + 0.5);
        this.dotRadius = attributes.getDimensionPixelSize(R.styleable.IndicatorDotView_dotRadius, defaultDotRadius);
        this.setRadius(this.dotRadius);
        int dotColor = attributes.getColor(R.styleable.IndicatorDotView_dotColor, -3355444);
        this.setColor(dotColor);
        attributes.recycle();
        this.setImageDrawable((Drawable)this.dot);
    }

    @Px
    int getRadius() {
        return this.dotRadius;
    }

    void setRadius(@Px int newRadius) {
        this.dotRadius = newRadius;
        int diameter = newRadius * 2;
        this.dot.setIntrinsicWidth(diameter);
        this.dot.setIntrinsicHeight(diameter);
        this.invalidate();
    }

    @ColorInt
    int getColor() {
        return this.dot.getPaint().getColor();
    }

    void setColor(@ColorInt int color) {
        this.dot.getPaint().setColor(color);
    }

    @NonNull
    Animator revealAnimator() {
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        Animator animator = this.revealAnimator(centerX, centerY);
        animator.setDuration(100L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                IndicatorDotView.this.setVisibility(0);
            }
        });
        return animator;
    }

    @NonNull
    private Animator revealAnimator(int centerX, int centerY) {
        Animator animator;
        boolean oldScale = false;
        boolean newScale = true;
        if (Build.VERSION.SDK_INT >= 21) {
            animator = ViewAnimationUtils.createCircularReveal((View)this, (int)centerX, (int)centerY, (float)0.0f, (float)this.dotRadius);
        } else if (Build.VERSION.SDK_INT >= 14) {
            PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.0f, 1.0f});
            PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.0f, 1.0f});
            animator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
        } else {
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{scaleX, scaleY});
            animator = animatorSet;
        }
        return animator;
    }

    @NonNull
    Animator slideAnimator(float toX, float toY, long animationDuration) {
        ObjectAnimator animator;
        float fromX = this.getTranslationX();
        float fromY = this.getTranslationY();
        if (Build.VERSION.SDK_INT >= 14) {
            PropertyValuesHolder translationX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{fromX, toX});
            PropertyValuesHolder translationY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{fromY, toY});
            animator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{translationX, translationY});
        } else {
            ObjectAnimator translationXAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{fromX, toX});
            ObjectAnimator translationYAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{fromY, toY});
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{translationXAnimator, translationYAnimator});
            animator = animatorSet;
        }
        animator.setDuration(animationDuration);
        return animator;
    }
}

