/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.rd.animation.data.Value;
import com.rd.animation.data.type.FillAnimationValue;
import com.rd.draw.data.Indicator;
import com.rd.draw.drawer.type.BaseDrawer;

public class FillDrawer
extends BaseDrawer {
    private Paint strokePaint = new Paint();

    public FillDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setAntiAlias(true);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int position, int coordinateX, int coordinateY) {
        if (!(value instanceof FillAnimationValue)) {
            return;
        }
        FillAnimationValue v = (FillAnimationValue)value;
        int color = this.indicator.getUnselectedColor();
        float radius = this.indicator.getRadius();
        int stroke = this.indicator.getStroke();
        int selectedPosition = this.indicator.getSelectedPosition();
        int selectingPosition = this.indicator.getSelectingPosition();
        int lastSelectedPosition = this.indicator.getLastSelectedPosition();
        if (this.indicator.isInteractiveAnimation()) {
            if (position == selectingPosition) {
                color = v.getColor();
                radius = v.getRadius();
                stroke = v.getStroke();
            } else if (position == selectedPosition) {
                color = v.getColorReverse();
                radius = v.getRadiusReverse();
                stroke = v.getStrokeReverse();
            }
        } else if (position == selectedPosition) {
            color = v.getColor();
            radius = v.getRadius();
            stroke = v.getStroke();
        } else if (position == lastSelectedPosition) {
            color = v.getColorReverse();
            radius = v.getRadiusReverse();
            stroke = v.getStrokeReverse();
        }
        this.strokePaint.setColor(color);
        this.strokePaint.setStrokeWidth((float)this.indicator.getStroke());
        canvas.drawCircle((float)coordinateX, (float)coordinateY, (float)this.indicator.getRadius(), this.strokePaint);
        this.strokePaint.setStrokeWidth((float)stroke);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, radius, this.strokePaint);
    }
}

