/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation.type;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.rd.animation.controller.ValueController;
import com.rd.animation.data.type.WormAnimationValue;
import com.rd.animation.type.BaseAnimation;
import java.util.Iterator;

public class WormAnimation
extends BaseAnimation<AnimatorSet> {
    int coordinateStart;
    int coordinateEnd;
    int radius;
    boolean isRightSide;
    int rectLeftEdge;
    int rectRightEdge;
    private WormAnimationValue value = new WormAnimationValue();

    public WormAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public AnimatorSet createAnimator() {
        AnimatorSet animator = new AnimatorSet();
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        return animator;
    }

    @Override
    public WormAnimation duration(long duration) {
        super.duration(duration);
        return this;
    }

    public WormAnimation with(int coordinateStart, int coordinateEnd, int radius, boolean isRightSide) {
        if (this.hasChanges(coordinateStart, coordinateEnd, radius, isRightSide)) {
            this.animator = this.createAnimator();
            this.coordinateStart = coordinateStart;
            this.coordinateEnd = coordinateEnd;
            this.radius = radius;
            this.isRightSide = isRightSide;
            this.rectLeftEdge = coordinateStart - radius;
            this.rectRightEdge = coordinateStart + radius;
            this.value.setRectStart(this.rectLeftEdge);
            this.value.setRectEnd(this.rectRightEdge);
            RectValues rect = this.createRectValues(isRightSide);
            long duration = this.animationDuration / 2L;
            ValueAnimator straightAnimator = this.createWormAnimator(rect.fromX, rect.toX, duration, false, this.value);
            ValueAnimator reverseAnimator = this.createWormAnimator(rect.reverseFromX, rect.reverseToX, duration, true, this.value);
            ((AnimatorSet)this.animator).playSequentially(new Animator[]{straightAnimator, reverseAnimator});
        }
        return this;
    }

    @Override
    public WormAnimation progress(float progress) {
        if (this.animator == null) {
            return this;
        }
        long progressDuration = (long)(progress * (float)this.animationDuration);
        Iterator iterator = ((AnimatorSet)this.animator).getChildAnimations().iterator();
        while (iterator.hasNext()) {
            long setDuration = progressDuration;
            Animator anim = (Animator)iterator.next();
            ValueAnimator animator = (ValueAnimator)anim;
            long duration = animator.getDuration();
            if (setDuration > duration) {
                setDuration = duration;
            }
            animator.setCurrentPlayTime(setDuration);
            progressDuration -= setDuration;
        }
        return this;
    }

    ValueAnimator createWormAnimator(int fromValue, int toValue, long duration, final boolean isReverse, final WormAnimationValue value) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{fromValue, toValue});
        anim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim.setDuration(duration);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                WormAnimation.this.onAnimateUpdated(value, animation, isReverse);
            }
        });
        return anim;
    }

    private void onAnimateUpdated(@NonNull WormAnimationValue value, @NonNull ValueAnimator animation, boolean isReverse) {
        int rectEdge = (Integer)animation.getAnimatedValue();
        if (this.isRightSide) {
            if (!isReverse) {
                value.setRectEnd(rectEdge);
            } else {
                value.setRectStart(rectEdge);
            }
        } else if (!isReverse) {
            value.setRectStart(rectEdge);
        } else {
            value.setRectEnd(rectEdge);
        }
        if (this.listener != null) {
            this.listener.onValueUpdated(value);
        }
    }

    boolean hasChanges(int coordinateStart, int coordinateEnd, int radius, boolean isRightSide) {
        if (this.coordinateStart != coordinateStart) {
            return true;
        }
        if (this.coordinateEnd != coordinateEnd) {
            return true;
        }
        if (this.radius != radius) {
            return true;
        }
        return this.isRightSide != isRightSide;
    }

    @NonNull
    RectValues createRectValues(boolean isRightSide) {
        int reverseToX;
        int reverseFromX;
        int toX;
        int fromX;
        if (isRightSide) {
            fromX = this.coordinateStart + this.radius;
            toX = this.coordinateEnd + this.radius;
            reverseFromX = this.coordinateStart - this.radius;
            reverseToX = this.coordinateEnd - this.radius;
        } else {
            fromX = this.coordinateStart - this.radius;
            toX = this.coordinateEnd - this.radius;
            reverseFromX = this.coordinateStart + this.radius;
            reverseToX = this.coordinateEnd + this.radius;
        }
        return new RectValues(fromX, toX, reverseFromX, reverseToX);
    }

    class RectValues {
        final int fromX;
        final int toX;
        final int reverseFromX;
        final int reverseToX;

        RectValues(int fromX, int toX, int reverseFromX, int reverseToX) {
            this.fromX = fromX;
            this.toX = toX;
            this.reverseFromX = reverseFromX;
            this.reverseToX = reverseToX;
        }
    }
}

