package fr.romaindu35.enscryptsystem;

import fr.romaindu35.enscryptsystem.encrypt.*;
import fr.romaindu35.enscryptsystem.exception.LengthKeyIncompatibleException;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class Main {

    public static void main(String[] args) throws LengthKeyIncompatibleException, IOException {
        EncryptBuilder encryptBuilder =
                new EncryptBuilder(new File("C:\\Users\\romai\\Desktop\\test\\log.txt"),
                        new File("C:\\Users\\romai\\Desktop\\test\\log2.txt"))
                .setCipherMod(CipherMod.ENCRYPT_MODE)
                .setKeys(new Keys("aaaaaaaaaaaaaaaa"));

        Encrypt encrypt = encryptBuilder.build();
        encrypt.launch();

        EncryptMemoryBuilder encryptMemoryBuilder = new EncryptMemoryBuilder(
                new File("C:\\Users\\romai\\Desktop\\test\\log2.txt"))
                .setCipherMod(CipherMod.DECRYPT_MODE)
                .setKeys(new Keys("aaaaaaaaaaaaaaaa"));

        EncryptMemory encryptMemory = encryptMemoryBuilder.build();
        File tempFile = encryptMemory.loadInMemory();
        System.out.println(tempFile.getCanonicalPath());

        FileInputStream fileInputStream = new FileInputStream(tempFile);
        int n = 0;
        byte[] buf = new byte[8];

        while ((n = fileInputStream.read(buf)) >= 0) {

            // On affiche ce qu'a lu notre boucle au format byte et au
            // format char
            for (byte bit : buf) {
                System.out.print("\t" + "(" + (char) bit + ")");
            }
            System.out.println("");
            //Nous réinitialisons le buffer à vide
            //au cas où les derniers byte lus ne soient pas un multiple de 8
            //Ceci permet d'avoir un buffer vierge à chaque lecture et ne pas avoir de doublon en fin de fichier
            buf = new byte[8];

        }
    }

}
