/*
 * Decompiled with CFR 0.152.
 */
package com.github.rocketchat.livechat;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.github.rocketchat.R;
import com.github.rocketchat.livechat.Application.LiveChatApplication;
import com.github.rocketchat.utils.AppUtils;
import io.rocketchat.livechat.LiveChatAPI;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.model.GuestObject;

public class SignupActivity
extends AppCompatActivity
implements ConnectListener,
AuthListener.RegisterListener,
AuthListener.LoginListener {
    EditText username;
    EditText email;
    LiveChatAPI api;
    Boolean isconnected = false;
    ProgressDialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_signup);
        this.api = ((LiveChatApplication)this.getApplicationContext()).getLiveChatAPI();
        this.api.setReconnectionStrategy(null);
        this.api.connect((ConnectListener)this);
        this.username = (EditText)this.findViewById(R.id.userid);
        this.email = (EditText)this.findViewById(R.id.email);
        Button register = (Button)this.findViewById(R.id.register);
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setIndeterminate(true);
        this.dialog.setMessage((CharSequence)"Registering ...");
        register.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String username = SignupActivity.this.username.getText().toString();
                String email = SignupActivity.this.email.getText().toString();
                if (username.isEmpty() || email.isEmpty()) {
                    AppUtils.showToast((Context)SignupActivity.this, "username and email shouldn't be null", true);
                } else if (SignupActivity.this.isconnected.booleanValue()) {
                    SignupActivity.this.dialog.show();
                    SignupActivity.this.api.registerGuest(username, email, null, (AuthListener.RegisterListener)SignupActivity.this);
                } else {
                    AppUtils.showToast((Context)SignupActivity.this, "Not connected to server", true);
                }
            }
        });
    }

    public void onConnect(String sessionID) {
        this.isconnected = true;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppUtils.showToast((Context)SignupActivity.this, "Connected to server", true);
            }
        });
    }

    public void onDisconnect(boolean closedByServer) {
        this.isconnected = false;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppUtils.showToast((Context)SignupActivity.this, "Disconnected from server", true);
            }
        });
    }

    public void onConnectError(Exception websocketException) {
        this.isconnected = false;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppUtils.showToast((Context)SignupActivity.this, "Connection error", true);
            }
        });
    }

    public void onRegister(GuestObject object) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppUtils.showToast((Context)SignupActivity.this, "Registration successful", false);
                SignupActivity.this.dialog.dismiss();
            }
        });
        System.out.println("Registration success");
        this.api.login(object.getToken(), (AuthListener.LoginListener)this);
    }

    public void onLogin(GuestObject object) {
        System.out.println("login success");
        LiveChatAPI.ChatRoom room = this.api.createRoom(object.getUserID(), object.getToken());
        Intent intent = new Intent();
        intent.putExtra("roomInfo", room.toString());
        this.setResult(-1, intent);
        this.finish();
    }
}

