/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import com.github.robtimus.filesystems.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Objects;

public final class FileSystemProviderSupport {
    private FileSystemProviderSupport() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    public static SeekableByteChannel createSeekableByteChannel(InputStream in, long size) {
        return FileSystemProviderSupport.createSeekableByteChannel(in, size, 0L);
    }

    public static SeekableByteChannel createSeekableByteChannel(final InputStream in, final long size, final long initialPosition) {
        Objects.requireNonNull(in);
        if (size < 0L) {
            throw new IllegalArgumentException(size + " < 0");
        }
        if (initialPosition < 0L) {
            throw new IllegalArgumentException(initialPosition + " < 0");
        }
        return new SeekableByteChannel(){
            private final ReadableByteChannel channel;
            private long position;
            {
                this.channel = Channels.newChannel(in);
                this.position = initialPosition;
            }

            @Override
            public boolean isOpen() {
                return this.channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.channel.close();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw new NonWritableChannelException();
            }

            @Override
            public SeekableByteChannel truncate(long size2) throws IOException {
                throw Messages.unsupportedOperation(SeekableByteChannel.class, "truncate");
            }

            @Override
            public long size() throws IOException {
                return size;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int read = this.channel.read(dst);
                if (read > 0) {
                    this.position += (long)read;
                }
                return read;
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                throw Messages.unsupportedOperation(SeekableByteChannel.class, "position");
            }

            @Override
            public long position() throws IOException {
                return this.position;
            }
        };
    }

    public static SeekableByteChannel createSeekableByteChannel(OutputStream out) {
        return FileSystemProviderSupport.createSeekableByteChannel(out, 0L);
    }

    public static SeekableByteChannel createSeekableByteChannel(final OutputStream out, final long initialPosition) {
        Objects.requireNonNull(out);
        if (initialPosition < 0L) {
            throw new IllegalArgumentException(initialPosition + " < 0");
        }
        return new SeekableByteChannel(){
            private final WritableByteChannel channel;
            private long position;
            {
                this.channel = Channels.newChannel(out);
                this.position = initialPosition;
            }

            @Override
            public boolean isOpen() {
                return this.channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.channel.close();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                int written = this.channel.write(src);
                this.position += (long)written;
                return written;
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                throw Messages.unsupportedOperation(SeekableByteChannel.class, "truncate");
            }

            @Override
            public long size() throws IOException {
                return this.position;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                throw new NonReadableChannelException();
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                throw Messages.unsupportedOperation(SeekableByteChannel.class, "position");
            }

            @Override
            public long position() throws IOException {
                return this.position;
            }
        };
    }

    public static boolean getBooleanValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static boolean getBooleanValue(Map<String, ?> env, String property, boolean defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static byte getByteValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static byte getByteValue(Map<String, ?> env, String property, byte defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static short getShortValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            try {
                return Short.parseShort(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static short getShortValue(Map<String, ?> env, String property, short defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            try {
                return Short.parseShort(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static int getIntValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static int getIntValue(Map<String, ?> env, String property, int defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static long getLongValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static long getLongValue(Map<String, ?> env, String property, long defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static float getFloatValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static float getFloatValue(Map<String, ?> env, String property, float defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static double getDoubleValue(Map<String, ?> env, String property) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static double getDoubleValue(Map<String, ?> env, String property, double defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException e) {
                throw Messages.fileSystemProvider().env().invalidProperty(property, value);
            }
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static <T> T getValue(Map<String, ?> env, String property, Class<T> cls) {
        Object value = env.get(property);
        if (value == null) {
            throw Messages.fileSystemProvider().env().missingProperty(property);
        }
        if (cls.isInstance(value)) {
            return cls.cast(value);
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }

    public static <T> T getValue(Map<String, ?> env, String property, Class<T> cls, T defaultValue) {
        Object value = env.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (cls.isInstance(value)) {
            return cls.cast(value);
        }
        throw Messages.fileSystemProvider().env().invalidProperty(property, value);
    }
}

