/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class UTF8Control
extends ResourceBundle.Control {
    public static final UTF8Control INSTANCE = new UTF8Control();

    private UTF8Control() {
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (!"java.properties".equals(format)) {
            return super.newBundle(baseName, locale, format, loader, reload);
        }
        String bundleName = this.toBundleName(baseName, locale);
        PropertyResourceBundle bundle = null;
        String resourceName = this.toResourceName(bundleName, "properties");
        InputStream in = null;
        try {
            in = AccessController.doPrivileged(() -> this.readResource(resourceName, loader, reload));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (in != null) {
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                bundle = new PropertyResourceBundle(reader);
            }
        }
        return bundle;
    }

    private InputStream readResource(String resourceName, ClassLoader loader, boolean reload) throws IOException {
        InputStream in = null;
        if (reload) {
            URLConnection connection;
            URL url = loader.getResource(resourceName);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                in = connection.getInputStream();
            }
        } else {
            in = loader.getResourceAsStream(resourceName);
        }
        return in;
    }
}

