/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import com.github.robtimus.filesystems.UTF8Control;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;

public final class Messages {
    private static final ResourceBundle BUNDLE = Messages.getBundle();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    private static ResourceBundle getBundle() {
        String baseName = "com.github.robtimus.filesystems.fs";
        try {
            return ResourceBundle.getBundle("com.github.robtimus.filesystems.fs", UTF8Control.INSTANCE);
        }
        catch (UnsupportedOperationException e) {
            return ResourceBundle.getBundle("com.github.robtimus.filesystems.fs");
        }
    }

    private static synchronized String getMessage(String key) {
        return BUNDLE.getString(key);
    }

    private static String getMessage(String key, Object ... args) {
        String format = Messages.getMessage(key);
        return String.format(format, args);
    }

    public static IllegalArgumentException invalidIndex(int index) {
        return new IllegalArgumentException(Messages.getMessage("invalidIndex", index));
    }

    public static IllegalArgumentException invalidRange(int beginIndex, int endIndex) {
        return new IllegalArgumentException(Messages.getMessage("invalidRange", beginIndex, endIndex));
    }

    public static UnsupportedOperationException unsupportedOperation(Class<?> cls, String operation) {
        return new UnsupportedOperationException(Messages.getMessage("unsupportedOperation", cls.getSimpleName(), operation));
    }

    public static PathMessages path() {
        return PathMessages.INSTANCE;
    }

    public static PathMatcherMessages pathMatcher() {
        return PathMatcherMessages.INSTANCE;
    }

    public static FileStoreMessages fileStore() {
        return FileStoreMessages.INSTANCE;
    }

    public static FileSystemProviderMessages fileSystemProvider() {
        return FileSystemProviderMessages.INSTANCE;
    }

    public static DirectoryStreamMessages directoryStream() {
        return DirectoryStreamMessages.INSTANCE;
    }

    public static FileChannelMessages fileChannel() {
        return FileChannelMessages.INSTANCE;
    }

    public static ByteChannelMessages byteChannel() {
        return ByteChannelMessages.INSTANCE;
    }

    public static URIMessages uri() {
        return URIMessages.INSTANCE;
    }

    public static final class URIMessages {
        private static final URIMessages INSTANCE = new URIMessages();

        private URIMessages() {
        }

        public IllegalArgumentException invalidScheme(URI uri, String expectedScheme) {
            return new IllegalArgumentException(Messages.getMessage("uri.invalidScheme", new Object[]{expectedScheme, uri}));
        }

        public IllegalArgumentException notAbsolute(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.notAbsolute", new Object[]{uri}));
        }

        public IllegalArgumentException notHierarchical(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.notHierarchical", new Object[]{uri}));
        }

        public IllegalArgumentException hasAuthority(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasAuthority", new Object[]{uri}));
        }

        public IllegalArgumentException hasFragment(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasFragment", new Object[]{uri}));
        }

        public IllegalArgumentException hasHost(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasHost", new Object[]{uri}));
        }

        public IllegalArgumentException hasPath(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasPath", new Object[]{uri}));
        }

        public IllegalArgumentException hasPort(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasPort", new Object[]{uri}));
        }

        public IllegalArgumentException hasQuery(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasQuery", new Object[]{uri}));
        }

        public IllegalArgumentException hasUserInfo(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasUserInfo", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoAuthority(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoAuthority", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoFragment(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoFragment", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoHost(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoHost", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoPath(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoPath", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoPort(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoPort", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoQuery(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoQuery", new Object[]{uri}));
        }

        public IllegalArgumentException hasNoUserInfo(URI uri) {
            return new IllegalArgumentException(Messages.getMessage("uri.hasNoUserInfo", new Object[]{uri}));
        }
    }

    public static final class ByteChannelMessages {
        private static final ByteChannelMessages INSTANCE = new ByteChannelMessages();

        private ByteChannelMessages() {
        }

        public IllegalArgumentException negativePosition(long position) {
            return new IllegalArgumentException(Messages.getMessage("byteChannel.negativePosition", new Object[]{position}));
        }

        public IllegalArgumentException negativeSize(long size) {
            return new IllegalArgumentException(Messages.getMessage("byteChannel.negativeSize", new Object[]{size}));
        }
    }

    public static final class FileChannelMessages {
        private static final FileChannelMessages INSTANCE = new FileChannelMessages();

        private FileChannelMessages() {
        }

        public IllegalArgumentException negativeCount(long count) {
            return new IllegalArgumentException(Messages.getMessage("fileChannel.negativeCount", new Object[]{count}));
        }

        public IllegalArgumentException negativePosition(long position) {
            return new IllegalArgumentException(Messages.getMessage("fileChannel.negativePosition", new Object[]{position}));
        }
    }

    public static final class DirectoryStreamMessages {
        private static final DirectoryStreamMessages INSTANCE = new DirectoryStreamMessages();

        private DirectoryStreamMessages() {
        }

        public IllegalStateException closed() {
            return new IllegalStateException(Messages.getMessage("directoryStream.closed"));
        }

        public IllegalStateException iteratorAlreadyReturned() {
            return new IllegalStateException(Messages.getMessage("directoryStream.iteratorAlreadyReturned"));
        }
    }

    public static final class FileSystemProviderEnvMessages {
        private static final FileSystemProviderEnvMessages INSTANCE = new FileSystemProviderEnvMessages();

        private FileSystemProviderEnvMessages() {
        }

        public IllegalArgumentException missingProperty(String property) {
            return new IllegalArgumentException(Messages.getMessage("fileSystemProvider.env.missingProperty", new Object[]{property}));
        }

        public IllegalArgumentException invalidProperty(String property, Object value) {
            return new IllegalArgumentException(Messages.getMessage("fileSystemProvider.env.invalidProperty", new Object[]{property, value}));
        }

        public IllegalArgumentException invalidPropertyCombination(Collection<String> properties) {
            return new IllegalArgumentException(Messages.getMessage("fileSystemProvider.env.invalidPropertyCombination", new Object[]{properties}));
        }
    }

    public static final class FileSystemProviderMessages {
        private static final FileSystemProviderMessages INSTANCE = new FileSystemProviderMessages();

        private FileSystemProviderMessages() {
        }

        public FileSystemProviderEnvMessages env() {
            return FileSystemProviderEnvMessages.INSTANCE;
        }

        public FileSystemException isDirectory(String dir) {
            return new FileSystemException(dir, null, Messages.getMessage("fileSystemProvider.isDirectory"));
        }

        public IllegalArgumentException illegalOpenOptionCombination(OpenOption ... options) {
            return this.illegalOpenOptionCombination(Arrays.asList(options));
        }

        public IllegalArgumentException illegalOpenOptionCombination(Collection<? extends OpenOption> options) {
            return new IllegalArgumentException(Messages.getMessage("fileSystemProvider.illegalOpenOptionCombination", new Object[]{options}));
        }

        public IllegalArgumentException illegalCopyOptionCombination(CopyOption ... options) {
            return this.illegalCopyOptionCombination(Arrays.asList(options));
        }

        public IllegalArgumentException illegalCopyOptionCombination(Collection<? extends CopyOption> options) {
            return new IllegalArgumentException(Messages.getMessage("fileSystemProvider.illegalCopyOptionCombination", new Object[]{options}));
        }

        public UnsupportedOperationException unsupportedFileAttributesType(Class<? extends BasicFileAttributes> type) {
            return new UnsupportedOperationException(Messages.getMessage("fileSystemProvider.unsupportedFileAttributesType", new Object[]{type.getName()}));
        }

        public UnsupportedOperationException unsupportedFileAttributeView(String view) {
            return new UnsupportedOperationException(Messages.getMessage("fileSystemProvider.unsupportedFileAttributeView", new Object[]{view}));
        }

        public UnsupportedOperationException unsupportedCreateFileAttribute(String attribute) {
            return new UnsupportedOperationException(Messages.getMessage("fileSystemProvider.unsupportedFileAttribute", new Object[]{attribute}));
        }

        public IllegalArgumentException unsupportedFileAttribute(String attribute) {
            return new IllegalArgumentException(Messages.getMessage("fileSystemProvider.unsupportedFileAttribute", new Object[]{attribute}));
        }

        public UnsupportedOperationException unsupportedOpenOption(OpenOption option) {
            return new UnsupportedOperationException(Messages.getMessage("fileSystemProvider.unsupportedOpenOption", new Object[]{option}));
        }

        public UnsupportedOperationException unsupportedCopyOption(CopyOption option) {
            return new UnsupportedOperationException(Messages.getMessage("fileSystemProvider.unsupportedCopyOption", new Object[]{option}));
        }
    }

    public static final class FileStoreMessages {
        private static final FileStoreMessages INSTANCE = new FileStoreMessages();

        private FileStoreMessages() {
        }

        public UnsupportedOperationException unsupportedAttribute(String attribute) {
            return new UnsupportedOperationException(Messages.getMessage("fileStore.unsupportedAttribute", new Object[]{attribute}));
        }
    }

    public static final class PathMatcherGlobMessages {
        private static final PathMatcherGlobMessages INSTANCE = new PathMatcherGlobMessages();

        private PathMatcherGlobMessages() {
        }

        public PatternSyntaxException nestedGroupsNotSupported(String glob, int index) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.nestedGroupsNotSupported"), glob, index);
        }

        public PatternSyntaxException unexpectedGroupEnd(String glob, int index) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.unexpectedGroupEnd"), glob, index);
        }

        public PatternSyntaxException missingGroupEnd(String glob) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.missingGroupEnd"), glob, glob.length());
        }

        public PatternSyntaxException nestedClassesNotSupported(String glob, int index) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.nestedClassesNotSupported"), glob, index);
        }

        public PatternSyntaxException unexpectedClassEnd(String glob, int index) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.unexpectedClassEnd"), glob, index);
        }

        public PatternSyntaxException missingClassEnd(String glob) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.missingClassEnd"), glob, glob.length());
        }

        public PatternSyntaxException separatorNotAllowedInClass(String glob, int index) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.separatorNotAllowedInClass"), glob, index);
        }

        public PatternSyntaxException unescapableChar(String glob, int index) {
            return new PatternSyntaxException(Messages.getMessage("pathMatcher.glob.unescapableChar"), glob, index);
        }
    }

    public static final class PathMatcherMessages {
        private static final PathMatcherMessages INSTANCE = new PathMatcherMessages();

        private PathMatcherMessages() {
        }

        public PathMatcherGlobMessages glob() {
            return PathMatcherGlobMessages.INSTANCE;
        }

        public IllegalArgumentException syntaxNotFound(String syntaxAndInput) {
            return new IllegalArgumentException(Messages.getMessage("pathMatcher.syntaxNotFound", new Object[]{syntaxAndInput}));
        }

        public UnsupportedOperationException unsupportedPathMatcherSyntax(String syntax) {
            return new UnsupportedOperationException(Messages.getMessage("pathMatcher.unsupportedPathMatcherSyntax", new Object[]{syntax}));
        }
    }

    public static final class PathMessages {
        private static final PathMessages INSTANCE = new PathMessages();

        private PathMessages() {
        }

        public InvalidPathException nulCharacterNotAllowed(String path) {
            return new InvalidPathException(path, Messages.getMessage("path.nulCharacterNotAllowed"));
        }

        public IllegalArgumentException relativizeAbsoluteRelativeMismatch() {
            return new IllegalArgumentException(Messages.getMessage("path.relativizeAbsoluteRelativeMismatch"));
        }
    }
}

