/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import com.github.robtimus.filesystems.Messages;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractDirectoryStream<T>
implements DirectoryStream<T> {
    private final DirectoryStream.Filter<? super T> filter;
    private boolean open = true;
    private Iterator<T> iterator = null;

    public AbstractDirectoryStream(DirectoryStream.Filter<? super T> filter) {
        this.filter = filter;
    }

    @Override
    public synchronized void close() throws IOException {
        this.open = false;
    }

    private synchronized boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        if (!this.open) {
            throw Messages.directoryStream().closed();
        }
        if (this.iterator != null) {
            throw Messages.directoryStream().iteratorAlreadyReturned();
        }
        this.iterator = new Iterator<T>(){
            private T next = null;
            private State state = State.UNSPECIFIED;

            @Override
            public boolean hasNext() {
                if (this.state == State.UNSPECIFIED) {
                    this.next = AbstractDirectoryStream.this.getNextElement();
                    this.state = this.next != null ? State.ACTIVE : State.ENDED;
                }
                return this.state == State.ACTIVE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                this.state = State.UNSPECIFIED;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        this.setupIteration();
        return this.iterator;
    }

    private T getNextElement() {
        while (this.isOpen()) {
            try {
                T next = this.getNext();
                if (next == null) {
                    return null;
                }
                if (this.filter != null && !this.filter.accept(next)) continue;
                return next;
            }
            catch (IOException e) {
                throw new DirectoryIteratorException(e);
            }
        }
        return null;
    }

    protected void setupIteration() {
    }

    protected abstract T getNext() throws IOException;

    private static enum State {
        ACTIVE,
        ENDED,
        UNSPECIFIED;

    }
}

