/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.attribute;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public final class PosixFilePermissionSupport {
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    private PosixFilePermissionSupport() {
        throw new Error("cannot create instances of " + this.getClass().getName());
    }

    public static Set<PosixFilePermission> fromMask(int mask) {
        EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 256, PosixFilePermission.OWNER_READ);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 128, PosixFilePermission.OWNER_WRITE);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 64, PosixFilePermission.OWNER_EXECUTE);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 32, PosixFilePermission.GROUP_READ);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 16, PosixFilePermission.GROUP_WRITE);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 8, PosixFilePermission.GROUP_EXECUTE);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 4, PosixFilePermission.OTHERS_READ);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 2, PosixFilePermission.OTHERS_WRITE);
        PosixFilePermissionSupport.addIfSet(permissions, mask, 1, PosixFilePermission.OTHERS_EXECUTE);
        return permissions;
    }

    private static void addIfSet(Set<PosixFilePermission> permissions, int mask, int bits, PosixFilePermission permission) {
        if (PosixFilePermissionSupport.isSet(mask, bits)) {
            permissions.add(permission);
        }
    }

    public static int toMask(Set<PosixFilePermission> permissions) {
        int mask = 0;
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 256, PosixFilePermission.OWNER_READ);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 128, PosixFilePermission.OWNER_WRITE);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 64, PosixFilePermission.OWNER_EXECUTE);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 32, PosixFilePermission.GROUP_READ);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 16, PosixFilePermission.GROUP_WRITE);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 8, PosixFilePermission.GROUP_EXECUTE);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 4, PosixFilePermission.OTHERS_READ);
        mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 2, PosixFilePermission.OTHERS_WRITE);
        return mask |= PosixFilePermissionSupport.getBitsIfSet(permissions, 1, PosixFilePermission.OTHERS_EXECUTE);
    }

    private static int getBitsIfSet(Set<PosixFilePermission> permissions, int bits, PosixFilePermission permission) {
        return permissions.contains((Object)permission) ? bits : 0;
    }

    public static boolean hasPermission(int mask, PosixFilePermission permission) {
        switch (permission) {
            case OWNER_READ: {
                return PosixFilePermissionSupport.isSet(mask, 256);
            }
            case OWNER_WRITE: {
                return PosixFilePermissionSupport.isSet(mask, 128);
            }
            case OWNER_EXECUTE: {
                return PosixFilePermissionSupport.isSet(mask, 64);
            }
            case GROUP_READ: {
                return PosixFilePermissionSupport.isSet(mask, 32);
            }
            case GROUP_WRITE: {
                return PosixFilePermissionSupport.isSet(mask, 16);
            }
            case GROUP_EXECUTE: {
                return PosixFilePermissionSupport.isSet(mask, 8);
            }
            case OTHERS_READ: {
                return PosixFilePermissionSupport.isSet(mask, 4);
            }
            case OTHERS_WRITE: {
                return PosixFilePermissionSupport.isSet(mask, 2);
            }
            case OTHERS_EXECUTE: {
                return PosixFilePermissionSupport.isSet(mask, 1);
            }
        }
        return false;
    }

    private static boolean isSet(int mask, int bits) {
        return (mask & bits) != 0;
    }
}

