/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.attribute;

import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class SimpleFileAttribute<T>
implements FileAttribute<T> {
    private final String name;
    private final T value;

    public SimpleFileAttribute(String name, T value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public T value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SimpleFileAttribute other = (SimpleFileAttribute)o;
        return this.name.equals(other.name) && this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        hash = 31 * hash + this.value.hashCode();
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ",value=" + this.value + "]";
    }
}

