/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import com.github.robtimus.filesystems.AbstractPath;
import com.github.robtimus.filesystems.Messages;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;

public abstract class SimpleAbstractPath
extends AbstractPath {
    private static final String ROOT_PATH = "/";
    private static final String EMPTY_PATH = "";
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    private final String path;
    private int[] offsets;

    protected SimpleAbstractPath(String path) {
        this(path, false);
    }

    protected SimpleAbstractPath(String path, boolean normalized) {
        Objects.requireNonNull(path);
        this.path = normalized ? path : this.normalize(path);
    }

    private String normalize(String path) {
        if (path.isEmpty()) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path.length());
        int prev = 0;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' && prev == 47) continue;
            if (c == '\u0000') {
                throw Messages.path().nulCharacterNotAllowed(path);
            }
            sb.append(c);
            prev = c;
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected abstract SimpleAbstractPath createPath(String var1);

    public final String path() {
        return this.path;
    }

    public final String nameAt(int index) {
        this.initOffsets();
        if (index < 0 || index >= this.offsets.length) {
            throw Messages.invalidIndex(index);
        }
        int begin = this.begin(index);
        int end = this.end(index);
        return this.path.substring(begin, end);
    }

    public final String fileName() {
        this.initOffsets();
        return this.offsets.length == 0 ? null : this.nameAt(this.offsets.length - 1);
    }

    @Override
    public boolean isAbsolute() {
        return this.path.startsWith(ROOT_PATH);
    }

    public final String rootPath() {
        return this.isAbsolute() ? ROOT_PATH : null;
    }

    @Override
    public Path getRoot() {
        return this.isAbsolute() ? this.createPath(ROOT_PATH) : null;
    }

    public final String parentPath() {
        this.initOffsets();
        int count = this.offsets.length;
        if (count == 0) {
            return null;
        }
        int end = this.offsets[count - 1] - 1;
        if (end <= 0) {
            return this.rootPath();
        }
        return this.path.substring(0, end);
    }

    @Override
    public Path getParent() {
        this.initOffsets();
        String parentPath = this.parentPath();
        return parentPath != null ? this.createPath(parentPath) : null;
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0 || beginIndex >= this.offsets.length || endIndex <= beginIndex || endIndex > this.offsets.length) {
            throw Messages.invalidRange(beginIndex, endIndex);
        }
        int begin = this.begin(beginIndex);
        int end = this.end(endIndex - 1);
        String subpath = this.path.substring(begin, end);
        return this.createPath(subpath);
    }

    @Override
    public boolean startsWith(Path other) {
        if (this.getFileSystem() != other.getFileSystem() || this.getClass() != other.getClass()) {
            return false;
        }
        SimpleAbstractPath that = (SimpleAbstractPath)other;
        if (that.path.isEmpty()) {
            return this.path.isEmpty();
        }
        if (ROOT_PATH.equals(that.path)) {
            return this.isAbsolute();
        }
        if (!this.path.startsWith(that.path)) {
            return false;
        }
        return this.path.length() == that.path.length() || this.path.charAt(that.path.length()) == '/';
    }

    @Override
    public boolean endsWith(Path other) {
        if (this.getFileSystem() != other.getFileSystem() || this.getClass() != other.getClass()) {
            return false;
        }
        SimpleAbstractPath that = (SimpleAbstractPath)other;
        if (that.path.isEmpty()) {
            return this.path.isEmpty();
        }
        if (that.isAbsolute()) {
            return this.path.equals(that.path);
        }
        if (!this.path.endsWith(that.path)) {
            return false;
        }
        return this.path.length() == that.path.length() || this.path.charAt(this.path.length() - that.path.length() - 1) == '/';
    }

    @Override
    public Path normalize() {
        int count = this.getNameCount();
        if (count == 0) {
            return this;
        }
        ArrayDeque<String> nameElements = new ArrayDeque<String>(count);
        int nonParentCount = 0;
        for (int i = 0; i < count; ++i) {
            if (this.equalsNameAt(CURRENT_DIR, i)) continue;
            boolean isParent = this.equalsNameAt(PARENT_DIR, i);
            if (isParent && nonParentCount > 0) {
                nameElements.pollLast();
                --nonParentCount;
                continue;
            }
            if (!this.isAbsolute() || !isParent) {
                String nameElement = this.nameAt(i);
                nameElements.addLast(nameElement);
            }
            if (isParent) continue;
            ++nonParentCount;
        }
        StringBuilder sb = new StringBuilder(this.path.length());
        if (this.isAbsolute()) {
            sb.append('/');
        }
        Iterator i = nameElements.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append('/');
        }
        return this.createPath(sb.toString());
    }

    private boolean equalsNameAt(String name, int index) {
        int thisBegin = this.begin(index);
        int thisEnd = this.end(index);
        int thisLength = thisEnd - thisBegin;
        if (thisLength != name.length()) {
            return false;
        }
        return this.path.regionMatches(thisBegin, name, 0, thisLength);
    }

    @Override
    public Path resolve(Path other) {
        SimpleAbstractPath that = this.checkPath(other);
        if (this.path.isEmpty() || that.isAbsolute()) {
            return that;
        }
        if (that.path.isEmpty()) {
            return this;
        }
        String resolvedPath = this.path.endsWith(ROOT_PATH) ? this.path + that.path : this.path + ROOT_PATH + that.path;
        return this.createPath(resolvedPath);
    }

    @Override
    public Path relativize(Path other) {
        int index;
        SimpleAbstractPath that = this.checkPath(other);
        if (this.equals(that)) {
            return this.createPath(EMPTY_PATH);
        }
        if (this.isAbsolute() != that.isAbsolute()) {
            throw Messages.path().relativizeAbsoluteRelativeMismatch();
        }
        if (this.path.isEmpty()) {
            return other;
        }
        int thisNameCount = this.getNameCount();
        int thatNameCount = that.getNameCount();
        int nameCount = Math.min(thisNameCount, thatNameCount);
        for (index = 0; index < nameCount && this.equalsNameAt(that, index); ++index) {
        }
        int parentDirs = thisNameCount - index;
        int length = parentDirs * 3 - 1;
        if (index < thatNameCount) {
            length += that.path.length() - that.offsets[index] + 1;
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < parentDirs; ++i) {
            sb.append(PARENT_DIR);
            if (i >= length) continue;
            sb.append('/');
        }
        if (index < thatNameCount) {
            sb.append(that.path, that.offsets[index], that.path.length());
        }
        return this.createPath(sb.toString());
    }

    private boolean equalsNameAt(SimpleAbstractPath that, int index) {
        int thisBegin = this.begin(index);
        int thisEnd = this.end(index);
        int thisLength = thisEnd - thisBegin;
        int thatBegin = that.begin(index);
        int thatEnd = that.end(index);
        int thatLength = thatEnd - thatBegin;
        if (thisLength != thatLength) {
            return false;
        }
        return this.path.regionMatches(thisBegin, that.path, thatBegin, thisLength);
    }

    @Override
    public int compareTo(Path other) {
        Objects.requireNonNull(other);
        SimpleAbstractPath that = (SimpleAbstractPath)this.getClass().cast(other);
        return this.path.compareTo(that.path);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SimpleAbstractPath other = (SimpleAbstractPath)obj;
        return this.getFileSystem() == other.getFileSystem() && this.path.equals(other.path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return this.path;
    }

    private synchronized void initOffsets() {
        if (this.offsets == null) {
            int start;
            if (ROOT_PATH.equals(this.path)) {
                this.offsets = new int[0];
                return;
            }
            boolean isAbsolute = this.isAbsolute();
            int count = 1;
            int n = start = isAbsolute ? 1 : 0;
            while ((start = this.path.indexOf(47, start)) != -1) {
                ++count;
                ++start;
            }
            int[] result = new int[count];
            start = isAbsolute ? 1 : 0;
            int index = 0;
            result[index++] = start;
            while ((start = this.path.indexOf(47, start)) != -1) {
                result[index++] = ++start;
            }
            this.offsets = result;
        }
    }

    private int begin(int index) {
        return this.offsets[index];
    }

    private int end(int index) {
        return index == this.offsets.length - 1 ? this.path.length() : this.offsets[index + 1] - 1;
    }

    private SimpleAbstractPath checkPath(Path path) {
        Objects.requireNonNull(path);
        if (this.getClass().isInstance(path)) {
            return (SimpleAbstractPath)this.getClass().cast(path);
        }
        throw new ProviderMismatchException();
    }
}

