/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import com.github.robtimus.filesystems.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class AbstractPath
implements Path {
    private static final WatchEvent.Modifier[] NO_MODIFIERS = new WatchEvent.Modifier[0];

    @Override
    public Path getFileName() {
        int nameCount = this.getNameCount();
        return nameCount == 0 ? null : this.getName(nameCount - 1);
    }

    @Override
    public Path getName(int index) {
        return this.subpath(index, index + 1);
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        Objects.requireNonNull(other);
        Path parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public File toFile() {
        throw Messages.unsupportedOperation(Path.class, "toFile");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, NO_MODIFIERS);
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.hasNext()) {
                    Path result = AbstractPath.this.getName(this.index);
                    ++this.index;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

