/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import com.github.robtimus.filesystems.Messages;
import java.util.regex.Pattern;

public final class PathMatcherSupport {
    private PathMatcherSupport() {
        throw new Error("cannot create instances of " + this.getClass().getName());
    }

    public static Pattern toPattern(String syntaxAndPattern) {
        int index = syntaxAndPattern.indexOf(58);
        if (index == -1) {
            throw Messages.pathMatcher().syntaxNotFound(syntaxAndPattern);
        }
        String syntax = syntaxAndPattern.substring(0, index);
        String expression = syntaxAndPattern.substring(index + 1);
        if ("glob".equals(syntax)) {
            return PathMatcherSupport.toGlobPattern(expression);
        }
        if ("regex".equals(syntax)) {
            return Pattern.compile(expression);
        }
        throw Messages.pathMatcher().unsupportedPathMatcherSyntax(syntax);
    }

    public static Pattern toGlobPattern(String glob) {
        return PathMatcherSupport.toGlobPattern(glob, 0);
    }

    public static Pattern toGlobPattern(String glob, int flags) {
        StringBuilder regex = new StringBuilder();
        regex.append('^');
        PathMatcherSupport.buildPattern(glob, 0, regex, false);
        regex.append('$');
        return Pattern.compile(regex.toString(), flags);
    }

    private static int buildPattern(String glob, int i, StringBuilder regex, boolean inGroup) {
        while (i < glob.length()) {
            char c = glob.charAt(i++);
            switch (c) {
                case '\\': {
                    PathMatcherSupport.ensureGlobMetaChar(glob, i);
                    PathMatcherSupport.appendLiteral(glob.charAt(i++), regex);
                    break;
                }
                case '*': {
                    if (PathMatcherSupport.isCharAt(glob, i, '*')) {
                        regex.append(".*");
                        ++i;
                        break;
                    }
                    regex.append("[^/]*");
                    break;
                }
                case '?': {
                    regex.append("[^/]");
                    break;
                }
                case '[': {
                    i = PathMatcherSupport.appendClass(glob, i, regex);
                    break;
                }
                case ']': {
                    throw Messages.pathMatcher().glob().unexpectedClassEnd(glob, i - 1);
                }
                case '{': {
                    if (inGroup) {
                        throw Messages.pathMatcher().glob().nestedGroupsNotSupported(glob, i - 1);
                    }
                    i = PathMatcherSupport.appendGroup(glob, i, regex);
                    break;
                }
                case '}': {
                    if (!inGroup) {
                        throw Messages.pathMatcher().glob().unexpectedGroupEnd(glob, i - 1);
                    }
                    return i;
                }
                case ',': {
                    if (inGroup) {
                        regex.append(")|(?:");
                        break;
                    }
                    PathMatcherSupport.appendLiteral(c, regex);
                    break;
                }
                default: {
                    PathMatcherSupport.appendLiteral(c, regex);
                }
            }
        }
        if (inGroup) {
            throw Messages.pathMatcher().glob().missingGroupEnd(glob);
        }
        return i;
    }

    private static void appendLiteral(char c, StringBuilder regex) {
        if (PathMatcherSupport.isRegexMetaChar(c)) {
            regex.append('\\');
        }
        regex.append(c);
    }

    private static int appendClass(String glob, int i, StringBuilder regex) {
        regex.append("[[");
        if (PathMatcherSupport.isCharAt(glob, i, '^')) {
            regex.append("\\^");
            ++i;
        } else if (PathMatcherSupport.isCharAt(glob, i, '!')) {
            regex.append('^');
            ++i;
        }
        boolean inClass = true;
        while (i < glob.length() && inClass) {
            char c = glob.charAt(i++);
            switch (c) {
                case '\\': {
                    PathMatcherSupport.ensureGlobMetaChar(glob, i);
                    PathMatcherSupport.appendLiteral(glob.charAt(i++), regex);
                    break;
                }
                case '/': {
                    throw Messages.pathMatcher().glob().separatorNotAllowedInClass(glob, i - 1);
                }
                case '[': {
                    throw Messages.pathMatcher().glob().nestedClassesNotSupported(glob, i - 1);
                }
                case ']': {
                    inClass = false;
                    break;
                }
                default: {
                    PathMatcherSupport.appendLiteral(c, regex);
                }
            }
        }
        if (inClass) {
            throw Messages.pathMatcher().glob().missingClassEnd(glob);
        }
        regex.append("]&&[^/]]");
        return i;
    }

    private static int appendGroup(String glob, int i, StringBuilder regex) {
        regex.append("(?:(?:");
        i = PathMatcherSupport.buildPattern(glob, i, regex, true);
        regex.append("))");
        return i;
    }

    private static void ensureGlobMetaChar(String glob, int i) {
        if (!PathMatcherSupport.isGlobMetaChar(glob, i)) {
            throw Messages.pathMatcher().glob().unescapableChar(glob, i - 1);
        }
    }

    private static boolean isCharAt(String s, int index, char c) {
        return index < s.length() && s.charAt(index) == c;
    }

    private static boolean isRegexMetaChar(char c) {
        String chars = ".^\\$+{[]|()";
        return ".^\\$+{[]|()".indexOf(c) != -1;
    }

    private static boolean isGlobMetaChar(String s, int index) {
        return index < s.length() && PathMatcherSupport.isGlobMetaChar(s.charAt(index));
    }

    private static boolean isGlobMetaChar(char c) {
        String chars = "*?\\[]{}";
        return "*?\\[]{}".indexOf(c) != -1;
    }
}

