/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare;

import com.google.common.collect.Maps;
import eu.roboflax.cloudflare.constants.Direction;
import java.util.HashMap;
import java.util.Map;

public class Pagination {
    private Integer page;
    private Integer perPage;
    private String order;
    private Direction direction;

    public Map<String, Object> getAsQueryStringsMap() {
        HashMap queryStrings = Maps.newHashMap();
        if (this.getPage() != null) {
            queryStrings.put("page", this.getPage());
        }
        if (this.getPerPage() != null) {
            queryStrings.put("per_page", this.getPerPage());
        }
        if (this.getOrder() != null) {
            queryStrings.put("order", this.getOrder());
        }
        if (this.getDirection() != null) {
            queryStrings.put("direction", this.getDirection().name());
        }
        return queryStrings;
    }

    public static PaginationBuilder builder() {
        return new PaginationBuilder();
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPerPage() {
        return this.perPage;
    }

    public String getOrder() {
        return this.order;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Pagination(Integer page, Integer perPage, String order, Direction direction) {
        this.page = page;
        this.perPage = perPage;
        this.order = order;
        this.direction = direction;
    }

    public static class PaginationBuilder {
        private Integer page;
        private Integer perPage;
        private String order;
        private Direction direction;

        PaginationBuilder() {
        }

        public PaginationBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public PaginationBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public PaginationBuilder order(String order) {
            this.order = order;
            return this;
        }

        public PaginationBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Pagination build() {
            return new Pagination(this.page, this.perPage, this.order, this.direction);
        }

        public String toString() {
            return "Pagination.PaginationBuilder(page=" + this.page + ", perPage=" + this.perPage + ", order=" + this.order + ", direction=" + (Object)((Object)this.direction) + ")";
        }
    }
}

