/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.target;

import be.ugent.rml.target.HttpMethod;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.ECParameterSpec;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwk.EcJwkGenerator;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.EllipticCurves;
import org.jose4j.lang.JoseException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestTargetHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestTargetHelper.class);
    private final EllipticCurveJsonWebKey jwk = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P256);
    private final HttpClient httpClient;
    private Map<String, String> clientCredentialsStore = new HashMap<String, String>();
    private Map<String, JSONObject> oidcAccessTokenStore;

    public HttpRequestTargetHelper() throws JoseException {
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
        this.oidcAccessTokenStore = new HashMap<String, JSONObject>();
    }

    private String getDpopAccessToken(Map<String, String> httpRequestInfo) throws Exception {
        try {
            String clientCredentialsStr;
            String oidcIssuer = httpRequestInfo.get("oidcIssuer");
            String webId = httpRequestInfo.get("webId");
            String email = httpRequestInfo.get("email");
            String password = httpRequestInfo.get("password");
            if (this.clientCredentialsStore.containsKey(webId)) {
                clientCredentialsStr = this.clientCredentialsStore.get(webId);
            } else {
                HttpRequest accountInfoRequest = HttpRequest.newBuilder(URI.create(oidcIssuer + ".account/")).GET().build();
                HttpResponse<String> accountInfoResponse = this.httpClient.send(accountInfoRequest, HttpResponse.BodyHandlers.ofString());
                String accountInfoStr = accountInfoResponse.body();
                if (accountInfoResponse.statusCode() != 200) {
                    log.error("Could not get account info: {}", (Object)accountInfoStr);
                    throw new Exception("Could not get account info: " + accountInfoStr);
                }
                JSONObject accountInfo = new JSONObject(accountInfoStr);
                String passwordLoginURL = accountInfo.getJSONObject("controls").getJSONObject("password").getString("login");
                log.debug("Found login URL: {}", (Object)passwordLoginURL);
                String loginMessage = "{\"email\": \"" + email + "\",\"password\":\"" + password + "\"}";
                HttpRequest loginRequest = HttpRequest.newBuilder(URI.create(passwordLoginURL)).POST(HttpRequest.BodyPublishers.ofString(loginMessage, StandardCharsets.UTF_8)).setHeader("Content-Type", "application/json").build();
                HttpResponse<String> loginResponse = this.httpClient.send(loginRequest, HttpResponse.BodyHandlers.ofString());
                String loginInfoStr = loginResponse.body();
                if (loginResponse.statusCode() != 200) {
                    log.error("Could not log in: {}", (Object)loginInfoStr);
                    throw new Exception("Could not get log in: " + loginInfoStr);
                }
                JSONObject loginInfo = new JSONObject(loginInfoStr);
                String authorizationToken = loginInfo.getString("authorization");
                log.debug("Found authorization token.");
                HttpRequest authorizedAccountInfoRequest = HttpRequest.newBuilder(URI.create(oidcIssuer + ".account/")).GET().setHeader("Authorization", "CSS-Account-Token " + authorizationToken).build();
                HttpResponse<String> authorizedAccountInfoResponse = this.httpClient.send(authorizedAccountInfoRequest, HttpResponse.BodyHandlers.ofString());
                String authorizedAccountInfoStr = authorizedAccountInfoResponse.body();
                if (authorizedAccountInfoResponse.statusCode() != 200) {
                    log.error("Could not get account info: {}", (Object)authorizedAccountInfoStr);
                    throw new Exception("Could not get account info: " + authorizedAccountInfoStr);
                }
                JSONObject authorizedAccountInfo = new JSONObject(authorizedAccountInfoStr);
                String clientCredentialsURL = authorizedAccountInfo.getJSONObject("controls").getJSONObject("account").getString("clientCredentials");
                log.debug("Found client credentials URL: {}", (Object)clientCredentialsURL);
                String webIdAndTokenMessage = "{\"name\": \"my-token\",\"webId\":\"" + webId + "\"}";
                HttpRequest getOIDCTokenRequest = HttpRequest.newBuilder(URI.create(clientCredentialsURL)).POST(HttpRequest.BodyPublishers.ofString(webIdAndTokenMessage, StandardCharsets.UTF_8)).setHeader("Authorization", "CSS-Account-Token " + authorizationToken).setHeader("Content-Type", "application/json").build();
                HttpResponse<String> getOIDCTokenResponse = this.httpClient.send(getOIDCTokenRequest, HttpResponse.BodyHandlers.ofString());
                clientCredentialsStr = getOIDCTokenResponse.body();
                this.clientCredentialsStore.put(webId, clientCredentialsStr);
                if (getOIDCTokenResponse.statusCode() != 200) {
                    log.error("Could not get OpenID Connect token info: {}", (Object)clientCredentialsStr);
                    throw new Exception("Could not get OpenID Connect token info: " + clientCredentialsStr);
                }
            }
            String accessTokenStr = null;
            Boolean validAccessToken = false;
            if (this.oidcAccessTokenStore.containsKey(webId)) {
                JSONObject oidcAccessToken = this.oidcAccessTokenStore.get(webId);
                Long expiresOn = oidcAccessToken.getLong("expires_on");
                Long now = new Date().getTime() / 1000L + 10L;
                if (now < expiresOn) {
                    accessTokenStr = oidcAccessToken.getString("access_token");
                    validAccessToken = true;
                }
            }
            if (!validAccessToken.booleanValue()) {
                JSONObject clientCredentials = new JSONObject(clientCredentialsStr);
                String clientCredentialsId = clientCredentials.getString("id");
                log.debug("Found Client credentials. id: {}", (Object)clientCredentialsId);
                String clientCredentialsSecret = clientCredentials.getString("secret");
                HttpRequest oidcInfoRequest = HttpRequest.newBuilder(URI.create(oidcIssuer + ".well-known/openid-configuration")).GET().build();
                HttpResponse<String> oidcInfoResponse = this.httpClient.send(oidcInfoRequest, HttpResponse.BodyHandlers.ofString());
                String oidcInfoStr = oidcInfoResponse.body();
                if (oidcInfoResponse.statusCode() != 200) {
                    log.error("Could not get OpenID Connect info: {}", (Object)oidcInfoStr);
                    throw new Exception("Could not get OpenID Connect info: " + oidcInfoStr);
                }
                JSONObject oidcInfo = new JSONObject(oidcInfoStr);
                String oidcTokenEndpoint = oidcInfo.getString("token_endpoint");
                log.debug("Found oidc token endpoint: {}", (Object)oidcTokenEndpoint);
                String dpopJWT = this.generateJWT(oidcTokenEndpoint, "POST");
                String clientCredentialsConcatenated = clientCredentialsId + ":" + clientCredentialsSecret;
                String base64clientCredentials = Base64.getEncoder().encodeToString(clientCredentialsConcatenated.getBytes(StandardCharsets.UTF_8));
                HttpRequest getOidcAccessTokenRequest = HttpRequest.newBuilder(URI.create(oidcTokenEndpoint)).POST(HttpRequest.BodyPublishers.ofString("grant_type=client_credentials&scope=webid", StandardCharsets.UTF_8)).setHeader("Authorization", "Basic " + base64clientCredentials).setHeader("Content-Type", "application/x-www-form-urlencoded").setHeader("DPoP", dpopJWT).build();
                HttpResponse<String> oidcAccessTokenResponse = this.httpClient.send(getOidcAccessTokenRequest, HttpResponse.BodyHandlers.ofString());
                String oidcAccessTokenStr = oidcAccessTokenResponse.body();
                if (oidcAccessTokenResponse.statusCode() != 200) {
                    log.error("Could not get OpenID Connect access token: {}", (Object)oidcAccessTokenStr);
                    throw new Exception("Could not get OpenID Connect info: " + oidcAccessTokenStr);
                }
                long startDate = new Date().getTime() / 1000L;
                JSONObject oidcAccessToken = new JSONObject(oidcAccessTokenStr);
                oidcAccessToken.put("expires_on", startDate + (long)oidcAccessToken.getInt("expires_in"));
                this.oidcAccessTokenStore.put(webId, oidcAccessToken);
                accessTokenStr = oidcAccessToken.getString("access_token");
            }
            return accessTokenStr;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private String generateJWT(String url, String method) throws JoseException {
        JwtClaims claims = new JwtClaims();
        claims.setGeneratedJwtId();
        claims.setClaim("htm", (Object)method);
        claims.setClaim("htu", (Object)url);
        claims.setIssuedAtToNow();
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)this.jwk.getPrivateKey());
        jws.setAlgorithmHeaderValue("ES256");
        jws.setHeader("typ", "dpop+jwt");
        jws.setJwkHeader((PublicJsonWebKey)this.jwk);
        jws.sign();
        return jws.getCompactSerialization();
    }

    public String executeHttpRequest(Map<String, String> httpRequestInfo, Map<String, String> httpRequestHeaders) throws Exception {
        try {
            String absoluteURI = httpRequestInfo.get("absoluteURI");
            String methodName = httpRequestInfo.get("methodName");
            HttpRequest.Builder RequestBuilder = HttpRequest.newBuilder(URI.create(absoluteURI));
            if (httpRequestInfo.containsKey("data")) {
                RequestBuilder.method(methodName, HttpRequest.BodyPublishers.ofString(httpRequestInfo.get("data"), StandardCharsets.UTF_8));
            } else {
                RequestBuilder.method(methodName, HttpRequest.BodyPublishers.noBody());
            }
            for (Map.Entry<String, String> entry : httpRequestHeaders.entrySet()) {
                RequestBuilder.setHeader(entry.getKey(), entry.getValue());
            }
            this.addAuthentication(RequestBuilder, httpRequestInfo);
            HttpRequest httpRequest = RequestBuilder.build();
            HttpResponse<String> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (this.isNotSuccessful(httpResponse.statusCode())) {
                log.error("Could not successfully execute HTTP request for URI {} and method {}: {}", new Object[]{absoluteURI, methodName, httpResponse.statusCode()});
                throw new Exception("Could not successfully execute HTTP request for URI " + absoluteURI + " and method " + methodName + ": " + httpResponse.statusCode());
            }
            return httpResponse.body();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public String executeLinkedHttpRequest(Map<String, String> httpRequestInfo, Map<String, String> httpRequestHeaders) throws Exception {
        try {
            String linkingAbsoluteURI = httpRequestInfo.get("linkingAbsoluteURI");
            String linkRelation = httpRequestInfo.get("linkRelation");
            HttpRequest.Builder RequestBuilder = HttpRequest.newBuilder(URI.create(linkingAbsoluteURI)).method(HttpMethod.HEAD.name(), HttpRequest.BodyPublishers.noBody());
            this.addAuthentication(RequestBuilder, httpRequestInfo);
            HttpRequest httpRequest = RequestBuilder.build();
            HttpResponse<String> headResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            List<String> links = headResponse.headers().map().get("link");
            boolean foundLink = false;
            String absoluteURI = null;
            String responseBody = null;
            for (int index = 0; !foundLink && index < links.size(); ++index) {
                String link = links.get(index);
                if (!link.contains("rel=\"" + linkRelation + "\"")) continue;
                absoluteURI = link.substring(link.indexOf("<") + 1, link.indexOf(">"));
                httpRequestInfo.put("absoluteURI", absoluteURI);
                responseBody = this.executeHttpRequest(httpRequestInfo, httpRequestHeaders);
                foundLink = true;
            }
            if (!foundLink) {
                String message = "Could not get linked absolute URI for link relation " + linkRelation + " and linking absolute URI " + linkingAbsoluteURI;
                log.error(message);
                throw new Exception(message);
            }
            return responseBody;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void addAuthentication(HttpRequest.Builder RequestBuilder, Map<String, String> httpRequestInfo) throws Exception {
        if (httpRequestInfo.containsKey("authenticationType") && httpRequestInfo.get("authenticationType").equals("https://w3id.org/imec/rml/ns/extensions#CssClientCredentialsAuthentication")) {
            String dpopAccessToken = this.getDpopAccessToken(httpRequestInfo);
            RequestBuilder.setHeader("Authorization", "DPoP " + dpopAccessToken);
            String dataJWT = this.generateJWT(httpRequestInfo.get("absoluteURI"), httpRequestInfo.get("methodName"));
            RequestBuilder.setHeader("DPoP", dataJWT);
        }
    }

    private boolean isNotSuccessful(int statusCode) {
        return statusCode < 200 || statusCode > 299;
    }
}

