/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.conformer;

import be.ugent.idlab.knows.dataio.access.DatabaseType;
import be.ugent.rml.Utils;
import be.ugent.rml.conformer.Converter;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.Map;

public class R2RMLConverter
implements Converter {
    private QuadStore store;

    R2RMLConverter(QuadStore store) {
        this.store = store;
    }

    @Override
    public void convert(Map<String, String> mappingOptions) throws Exception {
        for (Term triplesMap : Utils.getSubjectsFromQuads(this.store.getQuads(null, new NamedNode("http://w3id.org/rml/subjectMap"), null))) {
            Term logicalTable;
            try {
                logicalTable = this.store.getQuad(triplesMap, new NamedNode("http://www.w3.org/ns/r2rml#logicalTable"), null).getObject();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Mapping is either RML without logicalSource or R2RML without logicalTable");
            }
            NamedNode database = new NamedNode(triplesMap.getValue() + "_database");
            if (mappingOptions != null) {
                this.store.addQuad(database, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#Database"));
                for (Map.Entry<String, String> entry : mappingOptions.entrySet()) {
                    String removePrefix = entry.getKey();
                    this.store.addQuad(database, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#" + removePrefix), new Literal(entry.getValue()));
                    if (!removePrefix.equals("jdbcDSN")) continue;
                    DatabaseType type = DatabaseType.getDBtype((String)entry.getValue());
                    String driver = type.getDriver();
                    this.store.addQuad(database, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#jdbcDriver"), new Literal(driver));
                }
            }
            String logicalSourceIRI = triplesMap.getValue() + "_logicalSource";
            NamedNode logicalSource = new NamedNode(logicalSourceIRI);
            this.store.addQuad(triplesMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), logicalSource, null);
            this.store.addQuad(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#referenceFormulation"), new NamedNode("http://semweb.mmlab.be/ns/ql#CSV"));
            this.store.addQuad(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#source"), database);
            this.store.tryPropertyTranslation(logicalTable, new NamedNode("http://www.w3.org/ns/r2rml#sqlQuery"), logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#query"));
            this.store.tryPropertyTranslation(logicalTable, new NamedNode("http://www.w3.org/ns/r2rml#tableName"), logicalSource, new NamedNode("http://www.w3.org/ns/r2rml#tableName"));
            this.store.tryPropertyTranslation(logicalTable, new NamedNode("http://www.w3.org/ns/r2rml#sqlVersion"), logicalSource, new NamedNode("http://www.w3.org/ns/r2rml#sqlVersion"));
            this.store.renameAllPredicates(new NamedNode("http://www.w3.org/ns/r2rml#column"), new NamedNode("http://semweb.mmlab.be/ns/rml#reference"));
            this.store.removeQuads(triplesMap, new NamedNode("http://www.w3.org/ns/r2rml#logicalTable"), null);
        }
    }
}

