/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmac100.jshellscriptengine;

import com.github.dmac100.jshellscriptengine.JShellScriptEngineFactory;
import com.github.dmac100.jshellscriptengine.io.ReaderInputStream;
import com.github.dmac100.jshellscriptengine.io.WriterOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import jdk.jshell.Diag;
import jdk.jshell.EvalException;
import jdk.jshell.ExpressionSnippet;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.VarSnippet;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;
import jdk.jshell.spi.SPIResolutionException;

public class JShellScriptEngine
implements ScriptEngine {
    private static final ThreadLocal<Map<String, Object>> variables = new ThreadLocal();
    private final DirectExecutionControlExtended executionControl = new DirectExecutionControlExtended();
    private final JShell jshell = JShell.builder().executionEngine(new SimpleExecutionControlProvider(this.executionControl), new HashMap<String, String>()).build();
    private ScriptContext context = new SimpleScriptContext();

    public JShellScriptEngine() {
        this(null);
    }

    public JShellScriptEngine(Bindings bindings) {
        this.setBindings(bindings, 200);
        for (String string : System.getProperty("java.class.path").split(File.pathSeparator)) {
            this.jshell.addToClasspath(string);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return this.eval(string, this.context.getBindings(100));
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(JShellScriptEngine.readScript(reader));
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval(string, scriptContext, scriptContext.getBindings(100));
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(JShellScriptEngine.readScript(reader), scriptContext);
    }

    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        return this.eval(string, this.context, bindings);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(JShellScriptEngine.readScript(reader), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object eval(String string, ScriptContext scriptContext, Bindings bindings) throws ScriptException {
        InputStream inputStream = System.in;
        PrintStream printStream = System.err;
        PrintStream printStream2 = System.out;
        try {
            System.setOut(new PrintStream(new WriterOutputStream(scriptContext.getWriter())));
            System.setErr(new PrintStream(new WriterOutputStream(scriptContext.getErrorWriter())));
            System.setIn(new ReaderInputStream(scriptContext.getReader(), "UTF-8"));
            Bindings bindings2 = scriptContext.getBindings(200);
            this.writeVariableValues(JShellScriptEngine.getCombinedVariables(bindings2, bindings));
            List<SnippetEvent> list = this.evalAll(string);
            try {
                Object object;
                SnippetEvent snippetEvent;
                Iterator<SnippetEvent> iterator = list.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    snippetEvent = iterator.next();
                    if (snippetEvent.exception() != null) {
                        try {
                            throw snippetEvent.exception();
                        }
                        catch (EvalException evalException) {
                            throw new ScriptException(JShellScriptEngine.convertJShellException(evalException));
                        }
                        catch (JShellException jShellException) {
                            throw new ScriptException(jShellException);
                        }
                    }
                    if (snippetEvent.status() != Snippet.Status.VALID) continue;
                    object = snippetEvent.snippet();
                    if (object instanceof VarSnippet) {
                        VarSnippet varSnippet = (VarSnippet)object;
                        Object object2 = this.executionControl.getActualVarValue(varSnippet);
                        return object2;
                    }
                    if (!(object instanceof ExpressionSnippet)) continue;
                    Object object3 = this.executionControl.getLastValue();
                    return object3;
                } while (snippetEvent.status() != Snippet.Status.REJECTED);
                object = this.jshell.diagnostics(snippetEvent.snippet()).findAny().get();
                throw new ScriptException(((Diag)object).getPosition() + ": " + ((Diag)object).getMessage(null));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ScriptException(reflectiveOperationException);
            }
            finally {
                this.readVariableValues(bindings2, bindings);
            }
        }
        finally {
            System.out.flush();
            System.err.flush();
            System.setIn(inputStream);
            System.setOut(printStream2);
            System.setErr(printStream);
        }
    }

    private List<SnippetEvent> evalAll(String string) throws ScriptException {
        List<SnippetEvent> list;
        SourceCodeAnalysis.CompletionInfo completionInfo;
        do {
            if (!(completionInfo = this.jshell.sourceCodeAnalysis().analyzeCompletion(string)).completeness().isComplete()) {
                throw new ScriptException("Incomplete script");
            }
            list = this.jshell.eval(completionInfo.source());
        } while (!(string = completionInfo.remaining()).isEmpty());
        return list;
    }

    private static Exception convertJShellException(EvalException evalException) {
        try {
            Class<?> clazz = Class.forName(evalException.getExceptionClassName());
            if (Exception.class.isAssignableFrom(clazz)) {
                try {
                    Constructor<?> constructor = clazz.getConstructor(String.class, Throwable.class);
                    Exception exception = (Exception)constructor.newInstance(evalException.getMessage(), evalException.getCause());
                    exception.setStackTrace(evalException.getStackTrace());
                    return exception;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    try {
                        Constructor<?> constructor = clazz.getConstructor(String.class);
                        Exception exception = (Exception)constructor.newInstance(evalException.getMessage());
                        exception.setStackTrace(evalException.getStackTrace());
                        return exception;
                    }
                    catch (ReflectiveOperationException reflectiveOperationException2) {
                        try {
                            Constructor<?> constructor = clazz.getConstructor(Throwable.class);
                            Exception exception = (Exception)constructor.newInstance(evalException.getCause());
                            exception.setStackTrace(evalException.getStackTrace());
                            return exception;
                        }
                        catch (ReflectiveOperationException reflectiveOperationException3) {
                            try {
                                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                                Exception exception = (Exception)constructor.newInstance(new Object[0]);
                                exception.setStackTrace(evalException.getStackTrace());
                                return exception;
                            }
                            catch (ReflectiveOperationException reflectiveOperationException4) {}
                        }
                    }
                }
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return evalException;
    }

    private void writeVariableValues(Map<String, Object> map) {
        variables.set(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (!string.matches("[_a-zA-Z0-9]+")) continue;
            if (string.equals("_")) {
                string = "__";
            }
            String string2 = JShellScriptEngine.getDeclaredType(object);
            String string3 = String.format("%s %s = (%s) %s.getBindingValue(\"%s\");", string2, string, string2, JShellScriptEngine.class.getName(), string);
            List<SnippetEvent> list = this.jshell.eval(string3);
            for (SnippetEvent snippetEvent : list) {
                if (snippetEvent.status() != Snippet.Status.REJECTED) continue;
                Diag diag = this.jshell.diagnostics(snippetEvent.snippet()).findAny().get();
                throw new RuntimeException(diag.getPosition() + ": " + diag.getMessage(null));
            }
        }
    }

    public static String getDeclaredType(Object object) {
        Class<?> clazz;
        if (object == null) {
            return "java.lang.Object";
        }
        for (clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!JShellScriptEngine.isValidDeclarationType(clazz)) continue;
            return clazz.getCanonicalName();
        }
        for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!JShellScriptEngine.isValidDeclarationType(clazz2)) continue;
                return clazz2.getCanonicalName();
            }
        }
        return "java.lang.Object";
    }

    private static boolean isValidDeclarationType(Class<?> clazz) {
        if ((clazz.getModifiers() & 2) > 0) {
            return false;
        }
        if (clazz.getCanonicalName() == null) {
            return false;
        }
        return !clazz.getCanonicalName().contains("/");
    }

    public static Object getBindingValue(String string) {
        if (string.equals("__")) {
            string = "_";
        }
        return variables.get().get(string);
    }

    private void readVariableValues(Bindings bindings, Bindings bindings2) {
        for (Object object : this.jshell.variables().toArray()) {
            VarSnippet varSnippet = (VarSnippet)object;
            try {
                String string = varSnippet.name();
                Object object2 = this.executionControl.getActualVarValue(varSnippet);
                if (bindings != null && !bindings2.containsKey(string) && bindings.containsKey(string)) {
                    bindings.put(string, object2);
                    continue;
                }
                bindings2.put(string, object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Map<String, Object> getCombinedVariables(Bindings bindings, Bindings bindings2) {
        if (bindings == null) {
            return bindings2;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(bindings);
        hashMap.putAll(bindings2);
        return hashMap;
    }

    @Override
    public Object get(String string) {
        return this.getBindings(100).get(string);
    }

    @Override
    public Bindings getBindings(int n) {
        return this.context.getBindings(n);
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new JShellScriptEngineFactory();
    }

    @Override
    public void put(String string, Object object) {
        this.getBindings(100).put(string, object);
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
        this.context.setBindings(bindings, n);
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
        this.context = scriptContext;
    }

    private static String readScript(Reader reader) throws ScriptException {
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    public static class SimpleExecutionControlProvider
    implements ExecutionControlProvider {
        private final ExecutionControl executionControl;

        public SimpleExecutionControlProvider(ExecutionControl executionControl) {
            this.executionControl = executionControl;
        }

        @Override
        public ExecutionControl generate(ExecutionEnv executionEnv, Map<String, String> map) throws Throwable {
            return this.executionControl;
        }

        @Override
        public String name() {
            return "Simple Execution Control Provider";
        }
    }

    private class DirectExecutionControlExtended
    extends DirectExecutionControl {
        private String lastClassName;
        private String lastVarName;
        private Object lastValue;

        private DirectExecutionControlExtended() {
        }

        @Override
        public String varValue(String string, String string2) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
            this.lastClassName = string;
            this.lastVarName = string2;
            return super.varValue(string, string2);
        }

        @Override
        protected String invoke(Method method) throws Exception {
            this.lastValue = method.invoke(null, new Object[0]);
            return DirectExecutionControlExtended.valueString(this.lastValue);
        }

        public Object getActualVarValue(VarSnippet varSnippet) throws ReflectiveOperationException {
            JShellScriptEngine.this.jshell.varValue(varSnippet);
            Field field = this.findClass(this.lastClassName).getField(this.lastVarName);
            field.setAccessible(true);
            Object object = field.get(null);
            return object;
        }

        @Override
        protected String throwConvertedInvocationException(Throwable throwable) throws ExecutionControl.RunException, ExecutionControl.InternalException {
            if (throwable instanceof SPIResolutionException) {
                SPIResolutionException sPIResolutionException = (SPIResolutionException)throwable;
                throw new ExecutionControl.ResolutionException(sPIResolutionException.id(), sPIResolutionException.getStackTrace());
            }
            throw new ExecutionControl.UserException(throwable.getMessage() == null ? "<None>" : throwable.getMessage(), throwable.getClass().getName(), throwable.getStackTrace());
        }

        public Object getLastValue() {
            return this.lastValue;
        }
    }
}

