/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import java.io.IOException;
import java.util.HashMap;

class PSTTable {
    protected String tableType;
    protected byte tableTypeByte;
    protected int hidUserRoot;
    protected Long[] arrayBlocks = null;
    protected int sizeOfItemKey;
    protected int sizeOfItemValue;
    protected int hidRoot;
    protected int numberOfKeys = 0;
    protected int numberOfIndexLevels = 0;
    private final PSTNodeInputStream in;
    private HashMap<Integer, PSTDescriptorItem> subNodeDescriptorItems = null;
    protected String description = "";

    protected PSTTable(PSTNodeInputStream in, HashMap<Integer, PSTDescriptorItem> subNodeDescriptorItems) throws PSTException, IOException {
        this.subNodeDescriptorItems = subNodeDescriptorItems;
        this.in = in;
        this.arrayBlocks = in.getBlockOffsets();
        in.seek(0L);
        byte[] headdata = new byte[4];
        in.readCompletely(headdata);
        if (headdata[2] != -20) {
            PSTObject.decode(headdata);
            PSTObject.printHexFormatted(headdata, true);
            throw new PSTException("Unable to parse table, bad table type...");
        }
        this.tableTypeByte = headdata[3];
        switch (this.tableTypeByte) {
            case 124: {
                this.tableType = "7c";
                break;
            }
            case -68: {
                this.tableType = "bc";
                break;
            }
            default: {
                throw new PSTException("Unable to parse table, bad table type.  Unknown identifier: 0x" + Long.toHexString(headdata[3]));
            }
        }
        this.hidUserRoot = (int)in.seekAndReadLong(4L, 4);
        NodeInfo headerNodeInfo = this.getNodeInfo(32);
        headerNodeInfo.in.seek(headerNodeInfo.startOffset);
        int headerByte = headerNodeInfo.in.read() & 0xFF;
        if (headerByte != 181) {
            headerNodeInfo.in.seek(headerNodeInfo.startOffset);
            headerByte = headerNodeInfo.in.read() & 0xFF;
            headerNodeInfo.in.seek(headerNodeInfo.startOffset);
            byte[] tmp = new byte[1024];
            headerNodeInfo.in.readCompletely(tmp);
            PSTObject.printHexFormatted(tmp, true);
            throw new PSTException("Unable to parse table, can't find BTHHEADER header information: " + headerByte);
        }
        this.sizeOfItemKey = headerNodeInfo.in.read() & 0xFF;
        this.sizeOfItemValue = headerNodeInfo.in.read() & 0xFF;
        this.numberOfIndexLevels = headerNodeInfo.in.read() & 0xFF;
        if (this.numberOfIndexLevels != 0) {
            // empty if block
        }
        this.hidRoot = (int)headerNodeInfo.seekAndReadLong(4L, 4);
        this.description = this.description + "Table (" + this.tableType + ")\nhidUserRoot: " + this.hidUserRoot + " - 0x" + Long.toHexString(this.hidUserRoot) + "\nSize Of Keys: " + this.sizeOfItemKey + " - 0x" + Long.toHexString(this.sizeOfItemKey) + "\nSize Of Values: " + this.sizeOfItemValue + " - 0x" + Long.toHexString(this.sizeOfItemValue) + "\nhidRoot: " + this.hidRoot + " - 0x" + Long.toHexString(this.hidRoot) + "\n";
    }

    protected void releaseRawData() {
        this.subNodeDescriptorItems = null;
    }

    public int getRowCount() {
        return this.numberOfKeys;
    }

    protected NodeInfo getNodeInfo(int hnid) throws PSTException, IOException {
        int iHeapNodePageMap;
        int cAlloc;
        if (hnid == 0) {
            return new NodeInfo(0, 0, this.in);
        }
        if (this.subNodeDescriptorItems != null && this.subNodeDescriptorItems.containsKey(hnid)) {
            PSTDescriptorItem item = this.subNodeDescriptorItems.get(hnid);
            NodeInfo subNodeInfo = null;
            try {
                PSTNodeInputStream subNodeIn = new PSTNodeInputStream(this.in.getPSTFile(), item);
                subNodeInfo = new NodeInfo(0, (int)subNodeIn.length(), subNodeIn);
            }
            catch (IOException e) {
                throw new PSTException(String.format("IOException reading subNode: 0x%08X", hnid));
            }
            return subNodeInfo;
        }
        if ((hnid & 0x1F) != 0) {
            return null;
        }
        int whichBlock = hnid >>> 16;
        if (whichBlock > this.arrayBlocks.length) {
            String err = String.format("getNodeInfo: block doesn't exist! hnid = 0x%08X\n", hnid);
            err = err + String.format("getNodeInfo: block doesn't exist! whichBlock = 0x%08X\n", whichBlock);
            err = err + "\n" + this.arrayBlocks.length;
            throw new PSTException(err);
        }
        int index = (hnid & 0xFFFF) >> 5;
        int blockOffset = 0;
        if (whichBlock > 0) {
            blockOffset = this.arrayBlocks[whichBlock - 1].intValue();
        }
        if (index >= (cAlloc = (int)this.in.seekAndReadLong(iHeapNodePageMap = (int)this.in.seekAndReadLong(blockOffset, 2) + blockOffset, 2)) + 1) {
            throw new PSTException(String.format("getNodeInfo: node index doesn't exist! nid = 0x%08X\n", hnid));
        }
        int start = (int)this.in.seekAndReadLong(iHeapNodePageMap += 2 * index + 2, 2) + blockOffset;
        int end = (int)this.in.seekAndReadLong(iHeapNodePageMap + 2, 2) + blockOffset;
        NodeInfo out = new NodeInfo(start, end, this.in);
        return out;
    }

    class NodeInfo {
        int startOffset;
        int endOffset;
        PSTNodeInputStream in;

        NodeInfo(int start, int end, PSTNodeInputStream in) throws PSTException {
            if (start > end) {
                throw new PSTException(String.format("Invalid NodeInfo parameters: start %1$d is greater than end %2$d", start, end));
            }
            this.startOffset = start;
            this.endOffset = end;
            this.in = in;
        }

        int length() {
            return this.endOffset - this.startOffset;
        }

        long seekAndReadLong(long offset, int length) throws IOException, PSTException {
            return this.in.seekAndReadLong((long)this.startOffset + offset, length);
        }
    }
}

