/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.SpinnerAdapter;
import androidx.annotation.NonNull;
import com.rey.material.R;
import com.rey.material.app.ThemeManager;
import com.rey.material.drawable.ArrowDrawable;
import com.rey.material.drawable.DividerDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.FrameLayout;
import com.rey.material.widget.ListPopupWindow;
import com.rey.material.widget.ListView;
import com.rey.material.widget.TextView;

public class Spinner
extends FrameLayout
implements ThemeManager.OnThemeChangedListener {
    private static final int MAX_ITEMS_MEASURED = 15;
    private static final int INVALID_POSITION = -1;
    private boolean mLabelEnable;
    private TextView mLabelView;
    private SpinnerAdapter mAdapter;
    private OnItemClickListener mOnItemClickListener;
    private OnItemSelectedListener mOnItemSelectedListener;
    private int mMinWidth;
    private int mMinHeight;
    private DropdownPopup mPopup;
    private int mDropDownWidth;
    private ArrowDrawable mArrowDrawable;
    private int mArrowSize;
    private int mArrowPadding;
    private boolean mArrowAnimSwitchMode;
    private DividerDrawable mDividerDrawable;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mGravity;
    private boolean mDisableChildrenWhenDisabled;
    private int mSelectedPosition;
    private RecycleBin mRecycler = new RecycleBin();
    private Rect mTempRect = new Rect();
    private DropDownAdapter mTempAdapter;
    private SpinnerDataSetObserver mDataSetObserver = new SpinnerDataSetObserver();
    private boolean mIsRtl;

    public Spinner(Context context) {
        super(context, null, R.attr.listPopupWindowStyle);
    }

    public Spinner(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.listPopupWindowStyle);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mLabelEnable = false;
        this.mDropDownWidth = -2;
        this.mArrowAnimSwitchMode = false;
        this.mGravity = 17;
        this.mDisableChildrenWhenDisabled = false;
        this.mSelectedPosition = -1;
        this.mIsRtl = false;
        this.setWillNotDraw(false);
        this.mPopup = new DropdownPopup(context, attrs, defStyleAttr, defStyleRes);
        this.mPopup.setModal(true);
        if (this.isInEditMode()) {
            this.applyStyle(R.style.Material_Widget_Spinner);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Spinner.this.showPopup();
            }
        });
        super.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private android.widget.TextView getLabelView() {
        if (this.mLabelView == null) {
            this.mLabelView = new TextView(this.getContext());
            if (Build.VERSION.SDK_INT >= 17) {
                this.mLabelView.setTextDirection(this.mIsRtl ? 4 : 3);
            }
            this.mLabelView.setSingleLine(true);
            this.mLabelView.setDuplicateParentStateEnabled(true);
        }
        return this.mLabelView;
    }

    @Override
    protected void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        this.removeAllViews();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Spinner, defStyleAttr, defStyleRes);
        int arrowAnimDuration = -1;
        ColorStateList arrowColor = null;
        Interpolator arrowInterpolator = null;
        boolean arrowClockwise = true;
        int dividerAnimDuration = -1;
        ColorStateList dividerColor = null;
        ColorStateList labelTextColor = null;
        int labelTextSize = -1;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.Spinner_spn_labelEnable) {
                this.mLabelEnable = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_labelPadding) {
                this.getLabelView().setPadding(0, 0, 0, a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_labelTextSize) {
                labelTextSize = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_labelTextColor) {
                labelTextColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_labelTextAppearance) {
                this.getLabelView().setTextAppearance(context, a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_labelEllipsize) {
                int labelEllipsize = a.getInteger(attr2, 0);
                switch (labelEllipsize) {
                    case 1: {
                        this.getLabelView().setEllipsize(TextUtils.TruncateAt.START);
                        break;
                    }
                    case 2: {
                        this.getLabelView().setEllipsize(TextUtils.TruncateAt.MIDDLE);
                        break;
                    }
                    case 3: {
                        this.getLabelView().setEllipsize(TextUtils.TruncateAt.END);
                        break;
                    }
                    case 4: {
                        this.getLabelView().setEllipsize(TextUtils.TruncateAt.MARQUEE);
                        break;
                    }
                    default: {
                        this.getLabelView().setEllipsize(TextUtils.TruncateAt.END);
                        break;
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_label) {
                this.getLabelView().setText((CharSequence)a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.Spinner_android_gravity) {
                this.mGravity = a.getInt(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_android_minWidth) {
                this.setMinimumWidth(a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Spinner_android_minHeight) {
                this.setMinimumHeight(a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Spinner_android_dropDownWidth) {
                this.mDropDownWidth = a.getLayoutDimension(attr2, -2);
                continue;
            }
            if (attr2 == R.styleable.Spinner_android_popupBackground) {
                this.mPopup.setBackgroundDrawable(a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.Spinner_android_prompt) {
                this.mPopup.setPromptText(a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_popupItemAnimation) {
                this.mPopup.setItemAnimation(a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_popupItemAnimOffset) {
                this.mPopup.setItemAnimationOffset(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_disableChildrenWhenDisabled) {
                this.mDisableChildrenWhenDisabled = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowSwitchMode) {
                this.mArrowAnimSwitchMode = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowAnimDuration) {
                arrowAnimDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowSize) {
                this.mArrowSize = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowPadding) {
                this.mArrowPadding = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowColor) {
                arrowColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowInterpolator) {
                int resId = a.getResourceId(attr2, 0);
                arrowInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)resId);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_arrowAnimClockwise) {
                arrowClockwise = a.getBoolean(attr2, true);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_dividerHeight) {
                this.mDividerHeight = a.getDimensionPixelOffset(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_dividerPadding) {
                this.mDividerPadding = a.getDimensionPixelOffset(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Spinner_spn_dividerAnimDuration) {
                dividerAnimDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 != R.styleable.Spinner_spn_dividerColor) continue;
            dividerColor = a.getColorStateList(attr2);
        }
        a.recycle();
        if (labelTextColor != null) {
            this.getLabelView().setTextColor(labelTextColor);
        }
        if (labelTextSize >= 0) {
            this.getLabelView().setTextSize(0, (float)labelTextSize);
        }
        if (this.mLabelEnable) {
            this.addView((View)this.getLabelView(), 0, new ViewGroup.LayoutParams(-2, -2));
        }
        if (this.mArrowSize > 0) {
            if (this.mArrowDrawable == null) {
                if (arrowColor == null) {
                    arrowColor = ColorStateList.valueOf((int)ThemeUtil.colorControlNormal(context, -16777216));
                }
                if (arrowAnimDuration < 0) {
                    arrowAnimDuration = 0;
                }
                this.mArrowDrawable = new ArrowDrawable(ArrowDrawable.MODE_DOWN, this.mArrowSize, arrowColor, arrowAnimDuration, arrowInterpolator, arrowClockwise);
                this.mArrowDrawable.setCallback((Drawable.Callback)this);
            } else {
                this.mArrowDrawable.setArrowSize(this.mArrowSize);
                this.mArrowDrawable.setClockwise(arrowClockwise);
                if (arrowColor != null) {
                    this.mArrowDrawable.setColor(arrowColor);
                }
                if (arrowAnimDuration >= 0) {
                    this.mArrowDrawable.setAnimationDuration(arrowAnimDuration);
                }
                if (arrowInterpolator != null) {
                    this.mArrowDrawable.setInterpolator(arrowInterpolator);
                }
            }
        } else if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setCallback(null);
            this.mArrowDrawable = null;
        }
        if (this.mDividerHeight > 0) {
            if (this.mDividerDrawable == null) {
                if (dividerAnimDuration < 0) {
                    dividerAnimDuration = 0;
                }
                if (dividerColor == null) {
                    int[][] states = new int[][]{{-16842919}, {16842919, 16842910}};
                    int[] colors = new int[]{ThemeUtil.colorControlNormal(context, -16777216), ThemeUtil.colorControlActivated(context, -16777216)};
                    dividerColor = new ColorStateList((int[][])states, colors);
                }
                this.mDividerDrawable = new DividerDrawable(this.mDividerHeight, dividerColor, dividerAnimDuration);
                this.mDividerDrawable.setCallback((Drawable.Callback)this);
            } else {
                this.mDividerDrawable.setDividerHeight(this.mDividerHeight);
                if (dividerColor != null) {
                    this.mDividerDrawable.setColor(dividerColor);
                }
                if (dividerAnimDuration >= 0) {
                    this.mDividerDrawable.setAnimationDuration(dividerAnimDuration);
                }
            }
        } else if (this.mDividerDrawable != null) {
            this.mDividerDrawable.setCallback(null);
            this.mDividerDrawable = null;
        }
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
        if (this.mAdapter != null) {
            this.setAdapter(this.mAdapter);
        }
        if (this.isInEditMode()) {
            TextView tv = new TextView(context, attrs, defStyleAttr);
            tv.setText("Item 1");
            super.addView((View)tv);
        }
        this.requestLayout();
    }

    @TargetApi(value=17)
    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean rtl;
        boolean bl = rtl = layoutDirection == 1;
        if (this.mIsRtl != rtl) {
            this.mIsRtl = rtl;
            if (this.mLabelView != null && Build.VERSION.SDK_INT >= 17) {
                this.mLabelView.setTextDirection(this.mIsRtl ? 4 : 3);
            }
            this.requestLayout();
        }
    }

    public View getSelectedView() {
        View v = this.getChildAt(this.getChildCount() - 1);
        return v == this.mLabelView ? null : v;
    }

    public void setSelection(int position) {
        if (this.mAdapter != null) {
            position = Math.max(0, Math.min(position, this.mAdapter.getCount() - 1));
        }
        if (this.mSelectedPosition != position) {
            this.mSelectedPosition = position;
            if (this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected(this, this.getSelectedView(), position, this.mAdapter == null ? -1L : this.mAdapter.getItemId(position));
            }
            this.onDataInvalidated();
        }
    }

    public int getSelectedItemPosition() {
        return this.mSelectedPosition;
    }

    public Object getSelectedItem() {
        return this.mAdapter == null ? null : this.mAdapter.getItem(this.mSelectedPosition);
    }

    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(SpinnerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.mRecycler.clear();
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
        this.onDataChanged();
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(adapter));
        } else {
            this.mTempAdapter = new DropDownAdapter(adapter);
        }
    }

    public void setPopupBackgroundDrawable(Drawable background) {
        this.mPopup.setBackgroundDrawable(background);
    }

    public void setPopupBackgroundResource(int resId) {
        this.setPopupBackgroundDrawable(this.getContext().getDrawable(resId));
    }

    public Drawable getPopupBackground() {
        return this.mPopup.getBackground();
    }

    public void setDropDownVerticalOffset(int pixels) {
        this.mPopup.setVerticalOffset(pixels);
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public void setDropDownHorizontalOffset(int pixels) {
        this.mPopup.setHorizontalOffset(pixels);
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public void setDropDownWidth(int pixels) {
        this.mDropDownWidth = pixels;
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mDisableChildrenWhenDisabled) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setEnabled(enabled);
            }
        }
    }

    public void setMinimumHeight(int minHeight) {
        this.mMinHeight = minHeight;
        super.setMinimumHeight(minHeight);
    }

    public void setMinimumWidth(int minWidth) {
        this.mMinWidth = minWidth;
        super.setMinimumWidth(minWidth);
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 0x800003;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getBaseline() {
        View child = this.getSelectedView();
        if (child != null) {
            int childBaseline = child.getBaseline();
            if (childBaseline < 0) {
                return -1;
            }
            int paddingTop = this.getPaddingTop();
            if (this.mLabelView != null) {
                paddingTop += this.mLabelView.getMeasuredHeight();
            }
            int remainHeight = this.getMeasuredHeight() - paddingTop - this.getPaddingBottom() - this.getDividerDrawableHeight();
            int verticalGravity = this.mGravity & 0x70;
            switch (verticalGravity) {
                case 48: {
                    return paddingTop + childBaseline;
                }
                case 80: {
                    return paddingTop + remainHeight - child.getMeasuredHeight() + childBaseline;
                }
            }
            return (remainHeight - child.getMeasuredHeight()) / 2 + paddingTop + childBaseline;
        }
        return -1;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mOnItemClickListener = l;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener l) {
        this.mOnItemSelectedListener = l;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return true;
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || this.mArrowDrawable == who || this.mDividerDrawable == who;
    }

    private int getArrowDrawableWidth() {
        return this.mArrowDrawable != null ? this.mArrowSize + this.mArrowPadding * 2 : 0;
    }

    private int getDividerDrawableHeight() {
        return this.mDividerHeight > 0 ? this.mDividerHeight + this.mDividerPadding : 0;
    }

    private int getSpec(int availableSize, int size) {
        int spec;
        switch (size) {
            case -2: {
                if (availableSize > 0) {
                    spec = View.MeasureSpec.makeMeasureSpec((int)availableSize, (int)Integer.MIN_VALUE);
                    break;
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                break;
            }
            case -1: {
                if (availableSize > 0) {
                    spec = View.MeasureSpec.makeMeasureSpec((int)availableSize, (int)0x40000000);
                    break;
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                break;
            }
            default: {
                spec = View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
            }
        }
        return spec;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.LayoutParams params;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int paddingHorizontal = this.getPaddingLeft() + this.getPaddingRight() + this.getArrowDrawableWidth();
        int paddingVertical = this.getPaddingTop() + this.getPaddingBottom() + this.getDividerDrawableHeight();
        int labelWidth = 0;
        int labelHeight = 0;
        if (this.mLabelView != null && this.mLabelView.getLayoutParams() != null) {
            int size = widthMode == 0 ? 0 : widthSize - paddingHorizontal;
            int ws = View.MeasureSpec.makeMeasureSpec((int)size, (int)widthMode);
            int hs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.mLabelView.measure(ws, hs);
            labelWidth = this.mLabelView.getMeasuredWidth();
            labelHeight = this.mLabelView.getMeasuredHeight();
        }
        int width = 0;
        int height = 0;
        View v = this.getSelectedView();
        if (v != null) {
            params = v.getLayoutParams();
            int ws = this.getSpec(widthSize - paddingHorizontal, params.width);
            int hs = this.getSpec(heightSize - paddingVertical - this.mLabelView.getMeasuredHeight(), params.height);
            v.measure(ws, hs);
            width = v.getMeasuredWidth();
            height = v.getMeasuredHeight();
        }
        width = Math.max(this.mMinWidth, Math.max(labelWidth, width) + paddingHorizontal);
        height = Math.max(this.mMinHeight, height + labelHeight + paddingVertical);
        switch (widthMode) {
            case -2147483648: {
                width = Math.min(widthSize, width);
                break;
            }
            case 0x40000000: {
                width = widthSize;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                height = Math.min(heightSize, height);
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        this.setMeasuredDimension(width, height);
        if (v != null) {
            int viewHeight;
            int viewWidth;
            params = v.getLayoutParams();
            switch (params.width) {
                case -2: {
                    viewWidth = v.getMeasuredWidth();
                    break;
                }
                case -1: {
                    viewWidth = width - paddingHorizontal;
                    break;
                }
                default: {
                    viewWidth = params.width;
                }
            }
            switch (params.height) {
                case -2: {
                    viewHeight = v.getMeasuredHeight();
                    break;
                }
                case -1: {
                    viewHeight = height - labelHeight - paddingVertical;
                    break;
                }
                default: {
                    viewHeight = params.height;
                }
            }
            if (v.getMeasuredWidth() != viewWidth || v.getMeasuredHeight() != viewHeight) {
                v.measure(View.MeasureSpec.makeMeasureSpec((int)viewWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)viewHeight, (int)0x40000000));
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View v;
        int w = r - l;
        int h = b - t;
        int arrowWidth = this.getArrowDrawableWidth();
        if (this.mArrowDrawable != null) {
            int top = this.getPaddingTop() + (this.mLabelView == null ? 0 : this.mLabelView.getMeasuredHeight());
            int bottom = h - this.getDividerDrawableHeight() - this.getPaddingBottom();
            if (this.mIsRtl) {
                this.mArrowDrawable.setBounds(this.getPaddingLeft(), top, this.getPaddingLeft() + arrowWidth, bottom);
            } else {
                this.mArrowDrawable.setBounds(this.getWidth() - this.getPaddingRight() - arrowWidth, top, this.getWidth() - this.getPaddingRight(), bottom);
            }
        }
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.setBounds(this.getPaddingLeft(), h - this.mDividerHeight - this.getPaddingBottom(), w - this.getPaddingRight(), h - this.getPaddingBottom());
        }
        int childLeft = this.mIsRtl ? this.getPaddingLeft() + arrowWidth : this.getPaddingLeft();
        int childRight = this.mIsRtl ? w - this.getPaddingRight() : w - this.getPaddingRight() - arrowWidth;
        int childTop = this.getPaddingTop();
        int childBottom = h - this.getPaddingBottom();
        if (this.mLabelView != null) {
            if (this.mIsRtl) {
                this.mLabelView.layout(childRight - this.mLabelView.getMeasuredWidth(), childTop, childRight, childTop + this.mLabelView.getMeasuredHeight());
            } else {
                this.mLabelView.layout(childLeft, childTop, childLeft + this.mLabelView.getMeasuredWidth(), childTop + this.mLabelView.getMeasuredHeight());
            }
            childTop += this.mLabelView.getMeasuredHeight();
        }
        if ((v = this.getSelectedView()) != null) {
            int y;
            int x;
            int horizontalGravity = this.mGravity & 7;
            if (horizontalGravity == 0x800003) {
                horizontalGravity = this.mIsRtl ? 5 : 3;
            } else if (horizontalGravity == 0x800005) {
                horizontalGravity = this.mIsRtl ? 3 : 5;
            }
            switch (horizontalGravity) {
                case 3: {
                    x = childLeft;
                    break;
                }
                case 1: {
                    x = (childRight - childLeft - v.getMeasuredWidth()) / 2 + childLeft;
                    break;
                }
                case 5: {
                    x = childRight - v.getMeasuredWidth();
                    break;
                }
                default: {
                    x = (childRight - childLeft - v.getMeasuredWidth()) / 2 + childLeft;
                }
            }
            int verticalGravity = this.mGravity & 0x70;
            switch (verticalGravity) {
                case 48: {
                    y = childTop;
                    break;
                }
                case 16: {
                    y = (childBottom - childTop - v.getMeasuredHeight()) / 2 + childTop;
                    break;
                }
                case 80: {
                    y = childBottom - v.getMeasuredHeight();
                    break;
                }
                default: {
                    y = (childBottom - childTop - v.getMeasuredHeight()) / 2 + childTop;
                }
            }
            v.layout(x, y, x + v.getMeasuredWidth(), y + v.getMeasuredHeight());
        }
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.draw(canvas);
        }
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.draw(canvas);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setState(this.getDrawableState());
        }
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.setState(this.getDrawableState());
        }
    }

    public boolean performItemClick(View view, int position, long id) {
        if (this.mOnItemClickListener != null) {
            if (this.mOnItemClickListener.onItemClick(this, view, position, id)) {
                this.setSelection(position);
            }
            return true;
        }
        this.setSelection(position);
        return false;
    }

    private void onDataChanged() {
        if (this.mSelectedPosition == -1) {
            this.setSelection(0);
        } else if (this.mSelectedPosition < this.mAdapter.getCount()) {
            this.onDataInvalidated();
        } else {
            this.setSelection(this.mAdapter.getCount() - 1);
        }
    }

    private void onDataInvalidated() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mLabelView == null) {
            this.removeAllViews();
        } else {
            for (int i = this.getChildCount() - 1; i > 0; --i) {
                this.removeViewAt(i);
            }
        }
        int type = this.mAdapter.getItemViewType(this.mSelectedPosition);
        View v = this.mAdapter.getView(this.mSelectedPosition, this.mRecycler.get(type), (ViewGroup)this);
        v.setFocusable(false);
        v.setClickable(false);
        if (v.getParent() != null) {
            ((ViewGroup)v.getParent()).removeView(v);
        }
        super.addView(v);
        this.mRecycler.put(type, v);
    }

    private void showPopup() {
        if (!this.mPopup.isShowing()) {
            this.mPopup.show();
            final ListView lv = this.mPopup.getListView();
            if (lv != null) {
                if (Build.VERSION.SDK_INT >= 11) {
                    lv.setChoiceMode(1);
                }
                lv.setSelection(this.getSelectedItemPosition());
                if (this.mArrowDrawable != null && this.mArrowAnimSwitchMode) {
                    lv.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                        public boolean onPreDraw() {
                            lv.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                            Spinner.this.mArrowDrawable.setMode(ArrowDrawable.MODE_UP, true);
                            return true;
                        }
                    });
                }
            }
        }
    }

    private void onPopupDismissed() {
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setMode(ArrowDrawable.MODE_DOWN, true);
        }
    }

    private int measureContentWidth(SpinnerAdapter adapter, Drawable background) {
        if (adapter == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int start = Math.max(0, this.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        int count = end - start;
        for (int i = start = Math.max(0, start - (15 - count)); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, (ViewGroup)this)).getLayoutParams() == null) {
                itemView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        if (background != null) {
            background.getPadding(this.mTempRect);
            width += this.mTempRect.left + this.mTempRect.right;
        }
        return width;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.getSelectedItemPosition();
        ss.showDropdown = this.mPopup != null && this.mPopup.isShowing();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        ViewTreeObserver vto;
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setSelection(ss.position);
        if (ss.showDropdown && (vto = this.getViewTreeObserver()) != null) {
            ViewTreeObserver.OnGlobalLayoutListener listener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    Spinner.this.showPopup();
                    ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
                    if (vto != null) {
                        vto.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            };
            vto.addOnGlobalLayoutListener(listener);
        }
    }

    private class DropdownPopup
    extends ListPopupWindow {
        private CharSequence mHintText;
        private DropDownAdapter mAdapter;
        private ViewTreeObserver.OnGlobalLayoutListener layoutListener;

        public DropdownPopup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    DropdownPopup.this.computeContentWidth();
                    DropdownPopup.super.show();
                }
            };
            this.setAnchorView((View)Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnDismissListener(new PopupWindow.OnDismissListener(){

                @TargetApi(value=16)
                public void onDismiss() {
                    ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
                    if (vto != null) {
                        if (Build.VERSION.SDK_INT >= 16) {
                            vto.removeOnGlobalLayoutListener(DropdownPopup.this.layoutListener);
                        } else {
                            vto.removeGlobalOnLayoutListener(DropdownPopup.this.layoutListener);
                        }
                    }
                    Spinner.this.onPopupDismissed();
                }
            });
        }

        @Override
        public void setAdapter(ListAdapter adapter) {
            super.setAdapter(adapter);
            this.mAdapter = (DropDownAdapter)adapter;
            this.mAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
                    Spinner.this.performItemClick(v, position, DropdownPopup.this.mAdapter.getItemId(position));
                    DropdownPopup.this.dismiss();
                }
            });
        }

        public CharSequence getHintText() {
            return this.mHintText;
        }

        public void setPromptText(CharSequence hintText) {
            this.mHintText = hintText;
        }

        void computeContentWidth() {
            Drawable background = this.getBackground();
            int hOffset = 0;
            if (background != null) {
                background.getPadding(Spinner.this.mTempRect);
                hOffset = Spinner.this.mIsRtl ? ((Spinner)Spinner.this).mTempRect.right : -((Spinner)Spinner.this).mTempRect.left;
            } else {
                ((Spinner)Spinner.this).mTempRect.right = 0;
                ((Spinner)Spinner.this).mTempRect.left = 0;
            }
            int spinnerPaddingLeft = Spinner.this.getPaddingLeft();
            int spinnerPaddingRight = Spinner.this.getPaddingRight();
            int spinnerWidth = Spinner.this.getWidth();
            if (Spinner.this.mDropDownWidth == -2) {
                int contentWidthLimit;
                int contentWidth = Spinner.this.measureContentWidth(this.mAdapter, this.getBackground());
                if (contentWidth > (contentWidthLimit = Spinner.this.getContext().getResources().getDisplayMetrics().widthPixels - ((Spinner)Spinner.this).mTempRect.left - ((Spinner)Spinner.this).mTempRect.right)) {
                    contentWidth = contentWidthLimit;
                }
                this.setContentWidth(Math.max(contentWidth, spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight));
            } else if (Spinner.this.mDropDownWidth == -1) {
                this.setContentWidth(spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight);
            } else {
                this.setContentWidth(Spinner.this.mDropDownWidth);
            }
            hOffset = Spinner.this.mIsRtl ? (hOffset += spinnerWidth - spinnerPaddingRight - this.getWidth()) : (hOffset += spinnerPaddingLeft);
            this.setHorizontalOffset(hOffset);
        }

        @Override
        public void show() {
            boolean wasShowing = this.isShowing();
            this.computeContentWidth();
            this.setInputMethodMode(2);
            super.show();
            if (wasShowing) {
                return;
            }
            ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
            if (vto != null) {
                vto.addOnGlobalLayoutListener(this.layoutListener);
            }
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter,
    View.OnClickListener {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;
        private AdapterView.OnItemClickListener mOnItemClickListener;

        public DropDownAdapter(SpinnerAdapter adapter) {
            this.mAdapter = adapter;
            if (adapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)adapter;
            }
        }

        public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
            this.mOnItemClickListener = listener;
        }

        public void onClick(View v) {
            int position = (Integer)v.getTag();
            if (this.mOnItemClickListener != null) {
                this.mOnItemClickListener.onItemClick(null, v, position, 0L);
            }
        }

        public int getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        public Object getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        public long getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = this.getDropDownView(position, convertView, parent);
            v.setOnClickListener((View.OnClickListener)this);
            v.setTag((Object)position);
            return v;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public boolean areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            return adapter == null || adapter.areAllItemsEnabled();
        }

        public boolean isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            return adapter == null || adapter.isEnabled(position);
        }

        public int getItemViewType(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.getItemViewType(position);
            }
            return 0;
        }

        public int getViewTypeCount() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.getViewTypeCount();
            }
            return 1;
        }

        public boolean isEmpty() {
            return this.getCount() == 0;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }
    }

    private class RecycleBin {
        private final SparseArray<View> mScrapHeap = new SparseArray();

        private RecycleBin() {
        }

        public void put(int type, View v) {
            this.mScrapHeap.put(type, (Object)v);
        }

        View get(int type) {
            View result = (View)this.mScrapHeap.get(type);
            if (result != null) {
                this.mScrapHeap.delete(type);
            }
            return result;
        }

        void clear() {
            SparseArray<View> scrapHeap = this.mScrapHeap;
            scrapHeap.clear();
        }
    }

    private class SpinnerDataSetObserver
    extends DataSetObserver {
        private SpinnerDataSetObserver() {
        }

        public void onChanged() {
            Spinner.this.onDataChanged();
        }

        public void onInvalidated() {
            Spinner.this.onDataInvalidated();
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int position;
        boolean showDropdown;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in) {
            super(in);
            this.position = in.readInt();
            this.showDropdown = in.readByte() != 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
            out.writeByte((byte)(this.showDropdown ? 1 : 0));
        }

        public String toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + " showDropdown=" + this.showDropdown + "}";
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(Spinner var1, View var2, int var3, long var4);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(Spinner var1, View var2, int var3, long var4);
    }
}

