/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import com.rey.material.R;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;

public class RadioButtonDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private Paint mPaint;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration;
    private int mStrokeSize;
    private int mWidth;
    private int mHeight;
    private int mRadius;
    private int mInnerRadius;
    private int mPrevColor;
    private int mCurColor;
    private ColorStateList mStrokeColor;
    private boolean mChecked = false;
    private boolean mInEditMode = false;
    private boolean mAnimEnable = true;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            RadioButtonDrawable.this.update();
        }
    };

    private RadioButtonDrawable(int width, int height, int strokeSize, ColorStateList strokeColor, int radius, int innerRadius, int animDuration) {
        this.mAnimDuration = animDuration;
        this.mStrokeSize = strokeSize;
        this.mWidth = width;
        this.mHeight = height;
        this.mRadius = radius;
        this.mInnerRadius = innerRadius;
        this.mStrokeColor = strokeColor;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
    }

    public void setInEditMode(boolean b) {
        this.mInEditMode = b;
    }

    public void setAnimEnable(boolean b) {
        this.mAnimEnable = b;
    }

    public boolean isAnimEnable() {
        return this.mAnimEnable;
    }

    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mHeight;
    }

    public int getMinimumWidth() {
        return this.mWidth;
    }

    public int getMinimumHeight() {
        return this.mHeight;
    }

    public boolean isStateful() {
        return true;
    }

    public void draw(Canvas canvas) {
        if (this.mChecked) {
            this.drawChecked(canvas);
        } else {
            this.drawUnchecked(canvas);
        }
    }

    private void drawChecked(Canvas canvas) {
        float cx = this.getBounds().exactCenterX();
        float cy = this.getBounds().exactCenterY();
        if (this.isRunning()) {
            float halfStrokeSize = (float)this.mStrokeSize / 2.0f;
            float inTime = ((float)this.mRadius - halfStrokeSize) / ((float)this.mRadius - halfStrokeSize + (float)this.mRadius - (float)this.mStrokeSize - (float)this.mInnerRadius);
            if (this.mAnimProgress < inTime) {
                float inProgress = this.mAnimProgress / inTime;
                float outerRadius = (float)this.mRadius + halfStrokeSize * (1.0f - inProgress);
                float innerRadius = ((float)this.mRadius - halfStrokeSize) * (1.0f - inProgress);
                this.mPaint.setColor(ColorUtil.getMiddleColor(this.mPrevColor, this.mCurColor, inProgress));
                this.mPaint.setStrokeWidth(outerRadius - innerRadius);
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawCircle(cx, cy, (outerRadius + innerRadius) / 2.0f, this.mPaint);
            } else {
                float outProgress = (this.mAnimProgress - inTime) / (1.0f - inTime);
                float innerRadius = (float)(this.mRadius - this.mStrokeSize) * (1.0f - outProgress) + (float)this.mInnerRadius * outProgress;
                this.mPaint.setColor(this.mCurColor);
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawCircle(cx, cy, innerRadius, this.mPaint);
                float outerRadius = (float)this.mRadius + halfStrokeSize * outProgress;
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawCircle(cx, cy, outerRadius - halfStrokeSize, this.mPaint);
            }
        } else {
            this.mPaint.setColor(this.mCurColor);
            this.mPaint.setStrokeWidth((float)this.mStrokeSize);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(cx, cy, (float)this.mRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(cx, cy, (float)this.mInnerRadius, this.mPaint);
        }
    }

    private void drawUnchecked(Canvas canvas) {
        float cx = this.getBounds().exactCenterX();
        float cy = this.getBounds().exactCenterY();
        if (this.isRunning()) {
            float halfStrokeSize = (float)this.mStrokeSize / 2.0f;
            float inTime = (float)(this.mRadius - this.mStrokeSize - this.mInnerRadius) / ((float)this.mRadius - halfStrokeSize + (float)this.mRadius - (float)this.mStrokeSize - (float)this.mInnerRadius);
            if (this.mAnimProgress < inTime) {
                float inProgress = this.mAnimProgress / inTime;
                float innerRadius = (float)(this.mRadius - this.mStrokeSize) * inProgress + (float)this.mInnerRadius * (1.0f - inProgress);
                this.mPaint.setColor(ColorUtil.getMiddleColor(this.mPrevColor, this.mCurColor, inProgress));
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawCircle(cx, cy, innerRadius, this.mPaint);
                float outerRadius = (float)this.mRadius + halfStrokeSize * (1.0f - inProgress);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawCircle(cx, cy, outerRadius - halfStrokeSize, this.mPaint);
            } else {
                float outProgress = (this.mAnimProgress - inTime) / (1.0f - inTime);
                float outerRadius = (float)this.mRadius + halfStrokeSize * outProgress;
                float innerRadius = ((float)this.mRadius - halfStrokeSize) * outProgress;
                this.mPaint.setColor(this.mCurColor);
                this.mPaint.setStrokeWidth(outerRadius - innerRadius);
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawCircle(cx, cy, (outerRadius + innerRadius) / 2.0f, this.mPaint);
            }
        } else {
            this.mPaint.setColor(this.mCurColor);
            this.mPaint.setStrokeWidth((float)this.mStrokeSize);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(cx, cy, (float)this.mRadius, this.mPaint);
        }
    }

    protected boolean onStateChange(int[] state) {
        boolean checked = ViewUtil.hasState(state, 0x10100A0);
        int color = this.mStrokeColor.getColorForState(state, this.mCurColor);
        boolean needRedraw = false;
        if (this.mChecked != checked) {
            this.mChecked = checked;
            needRedraw = true;
            if (!this.mInEditMode && this.mAnimEnable) {
                this.start();
            }
        }
        if (this.mCurColor != color) {
            this.mPrevColor = this.isRunning() ? this.mCurColor : color;
            this.mCurColor = color;
            needRedraw = true;
        } else if (!this.isRunning()) {
            this.mPrevColor = color;
        }
        return needRedraw;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.mRunning = false;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    public static class Builder {
        private int mAnimDuration = 400;
        private int mStrokeSize = 4;
        private int mWidth = 64;
        private int mHeight = 64;
        private int mRadius = 18;
        private int mInnerRadius = 10;
        private ColorStateList mStrokeColor;

        public Builder() {
        }

        public Builder(Context context, int defStyleRes) {
            this(context, null, 0, defStyleRes);
        }

        public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RadioButtonDrawable, defStyleAttr, defStyleRes);
            this.width(a.getDimensionPixelSize(R.styleable.RadioButtonDrawable_rbd_width, ThemeUtil.dpToPx(context, 32)));
            this.height(a.getDimensionPixelSize(R.styleable.RadioButtonDrawable_rbd_height, ThemeUtil.dpToPx(context, 32)));
            this.strokeSize(a.getDimensionPixelSize(R.styleable.RadioButtonDrawable_rbd_strokeSize, ThemeUtil.dpToPx(context, 2)));
            this.radius(a.getDimensionPixelSize(R.styleable.RadioButtonDrawable_rbd_radius, ThemeUtil.dpToPx(context, 10)));
            this.innerRadius(a.getDimensionPixelSize(R.styleable.RadioButtonDrawable_rbd_innerRadius, ThemeUtil.dpToPx(context, 5)));
            this.strokeColor(a.getColorStateList(R.styleable.RadioButtonDrawable_rbd_strokeColor));
            this.animDuration(a.getInt(R.styleable.RadioButtonDrawable_rbd_animDuration, context.getResources().getInteger(0x10E0001)));
            a.recycle();
            if (this.mStrokeColor == null) {
                int[][] states = new int[][]{{-16842912}, {0x10100A0}};
                int[] colors = new int[]{ThemeUtil.colorControlNormal(context, -16777216), ThemeUtil.colorControlActivated(context, -16777216)};
                this.strokeColor(new ColorStateList((int[][])states, colors));
            }
        }

        public RadioButtonDrawable build() {
            if (this.mStrokeColor == null) {
                this.mStrokeColor = ColorStateList.valueOf((int)-16777216);
            }
            return new RadioButtonDrawable(this.mWidth, this.mHeight, this.mStrokeSize, this.mStrokeColor, this.mRadius, this.mInnerRadius, this.mAnimDuration);
        }

        public Builder width(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder height(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder strokeSize(int size) {
            this.mStrokeSize = size;
            return this;
        }

        public Builder strokeColor(int color) {
            this.mStrokeColor = ColorStateList.valueOf((int)color);
            return this;
        }

        public Builder strokeColor(ColorStateList color) {
            this.mStrokeColor = color;
            return this;
        }

        public Builder radius(int radius) {
            this.mRadius = radius;
            return this;
        }

        public Builder innerRadius(int radius) {
            this.mInnerRadius = radius;
            return this;
        }

        public Builder animDuration(int duration) {
            this.mAnimDuration = duration;
            return this;
        }
    }
}

