/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import androidx.core.text.TextUtilsCompat;
import com.rey.material.R;
import com.rey.material.util.ThemeUtil;
import java.util.ArrayList;
import java.util.Locale;

public class LineMorphingDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int mPaddingLeft = 12;
    private int mPaddingTop = 12;
    private int mPaddingRight = 12;
    private int mPaddingBottom = 12;
    private RectF mDrawBound;
    private int mPrevState;
    private int mCurState;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration;
    private Interpolator mInterpolator;
    private int mStrokeSize;
    private int mStrokeColor;
    private boolean mClockwise;
    private Paint.Cap mStrokeCap;
    private Paint.Join mStrokeJoin;
    private boolean mIsRtl;
    private Path mPath;
    private State[] mStates;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            LineMorphingDrawable.this.update();
        }
    };

    private LineMorphingDrawable(State[] states, int curState, int width, int height, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int animDuration, Interpolator interpolator, int strokeSize, int strokeColor, Paint.Cap strokeCap, Paint.Join strokeJoin, boolean clockwise, boolean isRtl) {
        this.mStates = states;
        this.mWidth = width;
        this.mHeight = height;
        this.mPaddingLeft = paddingLeft;
        this.mPaddingTop = paddingTop;
        this.mPaddingRight = paddingRight;
        this.mPaddingBottom = paddingBottom;
        this.mAnimDuration = animDuration;
        this.mInterpolator = interpolator;
        this.mStrokeSize = strokeSize;
        this.mStrokeColor = strokeColor;
        this.mStrokeCap = strokeCap;
        this.mStrokeJoin = strokeJoin;
        this.mClockwise = clockwise;
        this.mIsRtl = isRtl;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(this.mStrokeCap);
        this.mPaint.setStrokeJoin(this.mStrokeJoin);
        this.mPaint.setColor(this.mStrokeColor);
        this.mPaint.setStrokeWidth((float)this.mStrokeSize);
        this.mDrawBound = new RectF();
        this.mPath = new Path();
        this.switchLineState(curState, false);
    }

    public void draw(Canvas canvas) {
        int restoreCount = canvas.save();
        float degrees = (float)(this.mClockwise ? 180 : -180) * ((this.mPrevState < this.mCurState ? 0.0f : 1.0f) + this.mAnimProgress);
        if (this.mIsRtl) {
            canvas.scale(-1.0f, 1.0f, this.mDrawBound.centerX(), this.mDrawBound.centerY());
        }
        canvas.rotate(degrees, this.mDrawBound.centerX(), this.mDrawBound.centerY());
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.restoreToCount(restoreCount);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.mWidth > 0 && this.mHeight > 0) {
            this.mDrawBound.left = (float)bounds.left + (float)(bounds.width() - this.mWidth) / 2.0f;
            this.mDrawBound.top = (float)bounds.top + (float)(bounds.height() - this.mHeight) / 2.0f;
            this.mDrawBound.right = this.mDrawBound.left + (float)this.mWidth;
            this.mDrawBound.bottom = this.mDrawBound.top + (float)this.mHeight;
        } else {
            this.mDrawBound.left = bounds.left + this.mPaddingLeft;
            this.mDrawBound.top = bounds.top + this.mPaddingTop;
            this.mDrawBound.right = bounds.right - this.mPaddingRight;
            this.mDrawBound.bottom = bounds.bottom - this.mPaddingBottom;
        }
        this.updatePath();
    }

    public void switchLineState(int state, boolean animation) {
        if (this.mCurState != state) {
            this.mPrevState = this.mCurState;
            this.mCurState = state;
            if (animation) {
                this.start();
            } else {
                this.mAnimProgress = 1.0f;
                this.updatePath();
            }
        } else if (!animation) {
            this.mAnimProgress = 1.0f;
            this.updatePath();
        }
    }

    public boolean setLineState(int state, float progress) {
        if (this.mCurState != state) {
            this.mPrevState = this.mCurState;
            this.mCurState = state;
            this.mAnimProgress = progress;
            this.updatePath();
            return true;
        }
        if (this.mAnimProgress != progress) {
            this.mAnimProgress = progress;
            this.updatePath();
            return true;
        }
        return false;
    }

    public int getLineState() {
        return this.mCurState;
    }

    public int getLineStateCount() {
        return this.mStates == null ? 0 : this.mStates.length;
    }

    public float getAnimProgress() {
        return this.mAnimProgress;
    }

    private void updatePath() {
        this.mPath.reset();
        if (this.mStates == null) {
            return;
        }
        if (this.mAnimProgress == 0.0f || this.mStates[this.mPrevState].links != null && this.mAnimProgress < 0.05f) {
            this.updatePathWithState(this.mPath, this.mStates[this.mPrevState]);
        } else if (this.mAnimProgress == 1.0f || this.mStates[this.mCurState].links != null && this.mAnimProgress > 0.95f) {
            this.updatePathWithState(this.mPath, this.mStates[this.mCurState]);
        } else {
            this.updatePathBetweenStates(this.mPath, this.mStates[this.mPrevState], this.mStates[this.mCurState], this.mInterpolator.getInterpolation(this.mAnimProgress));
        }
        this.invalidateSelf();
    }

    private void updatePathWithState(Path path, State state) {
        if (state.links != null) {
            int i;
            for (i = 0; i < state.links.length; i += 2) {
                int index1 = state.links[i] * 4;
                int index2 = state.links[i + 1] * 4;
                float x1 = this.getX(state.points[index1]);
                float y1 = this.getY(state.points[index1 + 1]);
                float x2 = this.getX(state.points[index1 + 2]);
                float y2 = this.getY(state.points[index1 + 3]);
                float x3 = this.getX(state.points[index2]);
                float y3 = this.getY(state.points[index2 + 1]);
                float x4 = this.getX(state.points[index2 + 2]);
                float y4 = this.getY(state.points[index2 + 3]);
                if (x1 == x3 && y1 == y3) {
                    path.moveTo(x2, y2);
                    path.lineTo(x1, y1);
                    path.lineTo(x4, y4);
                    continue;
                }
                if (x1 == x4 && y1 == y4) {
                    path.moveTo(x2, y2);
                    path.lineTo(x1, y1);
                    path.lineTo(x3, y3);
                    continue;
                }
                if (x2 == x3 && y2 == y3) {
                    path.moveTo(x1, y1);
                    path.lineTo(x2, y2);
                    path.lineTo(x4, y4);
                    continue;
                }
                path.moveTo(x1, y1);
                path.lineTo(x2, y2);
                path.lineTo(x3, y3);
            }
            int count = state.points.length / 4;
            for (i = 0; i < count; ++i) {
                boolean exist = false;
                for (int j = 0; j < state.links.length; ++j) {
                    if (state.links[j] != i) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                int index = i * 4;
                path.moveTo(this.getX(state.points[index]), this.getY(state.points[index + 1]));
                path.lineTo(this.getX(state.points[index + 2]), this.getY(state.points[index + 3]));
            }
        } else {
            int count = state.points.length / 4;
            for (int i = 0; i < count; ++i) {
                int index = i * 4;
                path.moveTo(this.getX(state.points[index]), this.getY(state.points[index + 1]));
                path.lineTo(this.getX(state.points[index + 2]), this.getY(state.points[index + 3]));
            }
        }
    }

    private void updatePathBetweenStates(Path path, State prev, State cur, float progress) {
        int count = Math.max(prev.points.length, cur.points.length) / 4;
        for (int i = 0; i < count; ++i) {
            float y4;
            float x4;
            float y3;
            float x3;
            float y2;
            float x2;
            float y1;
            float x1;
            int index = i * 4;
            if (index >= prev.points.length) {
                x1 = 0.5f;
                y1 = 0.5f;
                x2 = 0.5f;
                y2 = 0.5f;
            } else {
                x1 = prev.points[index];
                y1 = prev.points[index + 1];
                x2 = prev.points[index + 2];
                y2 = prev.points[index + 3];
            }
            if (index >= cur.points.length) {
                x3 = 0.5f;
                y3 = 0.5f;
                x4 = 0.5f;
                y4 = 0.5f;
            } else {
                x3 = cur.points[index];
                y3 = cur.points[index + 1];
                x4 = cur.points[index + 2];
                y4 = cur.points[index + 3];
            }
            this.mPath.moveTo(this.getX(x1 + (x3 - x1) * progress), this.getY(y1 + (y3 - y1) * progress));
            this.mPath.lineTo(this.getX(x2 + (x4 - x2) * progress), this.getY(y2 + (y4 - y2) * progress));
        }
    }

    private float getX(float value) {
        return this.mDrawBound.left + this.mDrawBound.width() * value;
    }

    private float getY(float value) {
        return this.mDrawBound.top + this.mDrawBound.height() * value;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void cancel() {
        this.stop();
        this.setLineState(this.mCurState, 1.0f);
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        float value = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (value == 1.0f) {
            this.setLineState(this.mCurState, 1.0f);
            this.mRunning = false;
        } else {
            this.setLineState(this.mCurState, this.mInterpolator.getInterpolation(value));
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
    }

    public static class Builder {
        private int mCurState;
        private int mWidth;
        private int mHeight;
        private int mPaddingLeft;
        private int mPaddingTop;
        private int mPaddingRight;
        private int mPaddingBottom;
        private int mAnimDuration;
        private Interpolator mInterpolator;
        private int mStrokeSize;
        private int mStrokeColor;
        private boolean mClockwise;
        private Paint.Cap mStrokeCap;
        private Paint.Join mStrokeJoin;
        private boolean mIsRtl;
        private State[] mStates;
        private static final String TAG_STATE_LIST = "state-list";
        private static final String TAG_STATE = "state";
        private static final String TAG_POINTS = "points";
        private static final String TAG_LINKS = "links";
        private static final String TAG_ITEM = "item";

        public Builder() {
        }

        public Builder(Context context, int defStyleRes) {
            this(context, null, 0, defStyleRes);
        }

        public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LineMorphingDrawable, defStyleAttr, defStyleRes);
            int resId = a.getResourceId(R.styleable.LineMorphingDrawable_lmd_state, 0);
            if (resId != 0) {
                this.states(this.readStates(context, resId));
            }
            this.curState(a.getInteger(R.styleable.LineMorphingDrawable_lmd_curState, 0));
            this.width(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_width, 0));
            this.height(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_height, 0));
            this.padding(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_padding, 0));
            this.paddingLeft(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_paddingLeft, this.mPaddingLeft));
            this.paddingTop(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_paddingTop, this.mPaddingTop));
            this.paddingRight(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_paddingRight, this.mPaddingRight));
            this.paddingBottom(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_paddingBottom, this.mPaddingBottom));
            this.animDuration(a.getInteger(R.styleable.LineMorphingDrawable_lmd_animDuration, context.getResources().getInteger(0x10E0001)));
            resId = a.getResourceId(R.styleable.LineMorphingDrawable_lmd_interpolator, 0);
            if (resId != 0) {
                this.interpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
            }
            this.strokeSize(a.getDimensionPixelSize(R.styleable.LineMorphingDrawable_lmd_strokeSize, ThemeUtil.dpToPx(context, 3)));
            this.strokeColor(a.getColor(R.styleable.LineMorphingDrawable_lmd_strokeColor, -1));
            int cap = a.getInteger(R.styleable.LineMorphingDrawable_lmd_strokeCap, 0);
            if (cap == 0) {
                this.strokeCap(Paint.Cap.BUTT);
            } else if (cap == 1) {
                this.strokeCap(Paint.Cap.ROUND);
            } else {
                this.strokeCap(Paint.Cap.SQUARE);
            }
            int join = a.getInteger(R.styleable.LineMorphingDrawable_lmd_strokeJoin, 0);
            if (join == 0) {
                this.strokeJoin(Paint.Join.MITER);
            } else if (join == 1) {
                this.strokeJoin(Paint.Join.ROUND);
            } else {
                this.strokeJoin(Paint.Join.BEVEL);
            }
            this.clockwise(a.getBoolean(R.styleable.LineMorphingDrawable_lmd_clockwise, true));
            int direction = a.getInteger(R.styleable.LineMorphingDrawable_lmd_layoutDirection, 0);
            if (direction == 3) {
                this.rtl(TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1);
            } else {
                this.rtl(direction == 1);
            }
            a.recycle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private State[] readStates(Context context, int id) {
            ArrayList<State> states = new ArrayList<State>();
            try (XmlResourceParser parser = null;){
                String tagName;
                parser = context.getResources().getXml(id);
                int eventType = parser.getEventType();
                boolean lookingForEndOfUnknownTag = false;
                String unknownTagName = null;
                do {
                    if (eventType != 2) continue;
                    tagName = parser.getName();
                    if (tagName.equals(TAG_STATE_LIST)) {
                        eventType = parser.next();
                        break;
                    }
                    throw new RuntimeException("Expecting menu, got " + tagName);
                } while ((eventType = parser.next()) != 1);
                boolean reachedEndOfStateList = false;
                State state = null;
                ArrayList<String> array = new ArrayList<String>();
                StringBuilder currentValue = new StringBuilder();
                while (!reachedEndOfStateList) {
                    block2 : switch (eventType) {
                        case 2: {
                            if (lookingForEndOfUnknownTag) break;
                            switch (tagName = parser.getName()) {
                                case "state": {
                                    state = new State();
                                    break block2;
                                }
                                case "points": 
                                case "links": {
                                    array.clear();
                                    break block2;
                                }
                                case "item": {
                                    currentValue.delete(0, currentValue.length());
                                    break block2;
                                }
                            }
                            lookingForEndOfUnknownTag = true;
                            unknownTagName = tagName;
                            break;
                        }
                        case 3: {
                            tagName = parser.getName();
                            if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                                lookingForEndOfUnknownTag = false;
                                unknownTagName = null;
                            }
                            switch (tagName) {
                                case "state-list": {
                                    reachedEndOfStateList = true;
                                    break;
                                }
                                case "state": {
                                    states.add(state);
                                    break;
                                }
                                case "points": {
                                    int i;
                                    state.points = new float[array.size()];
                                    for (i = 0; i < state.points.length; ++i) {
                                        state.points[i] = Float.parseFloat((String)array.get(i));
                                    }
                                    break block2;
                                }
                                case "links": {
                                    int i;
                                    state.links = new int[array.size()];
                                    for (i = 0; i < state.links.length; ++i) {
                                        state.links[i] = Integer.parseInt((String)array.get(i));
                                    }
                                    break block2;
                                }
                                case "item": {
                                    array.add(currentValue.toString());
                                }
                            }
                            break;
                        }
                        case 4: {
                            currentValue.append(parser.getText());
                            break;
                        }
                        case 1: {
                            reachedEndOfStateList = true;
                        }
                    }
                    eventType = parser.next();
                }
            }
            if (states.isEmpty()) {
                return null;
            }
            return states.toArray(new State[states.size()]);
        }

        public LineMorphingDrawable build() {
            if (this.mStrokeCap == null) {
                this.mStrokeCap = Paint.Cap.BUTT;
            }
            if (this.mStrokeJoin == null) {
                this.mStrokeJoin = Paint.Join.MITER;
            }
            if (this.mInterpolator == null) {
                this.mInterpolator = new AccelerateInterpolator();
            }
            return new LineMorphingDrawable(this.mStates, this.mCurState, this.mWidth, this.mHeight, this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom, this.mAnimDuration, this.mInterpolator, this.mStrokeSize, this.mStrokeColor, this.mStrokeCap, this.mStrokeJoin, this.mClockwise, this.mIsRtl);
        }

        public Builder states(State ... states) {
            this.mStates = states;
            return this;
        }

        public Builder curState(int state) {
            this.mCurState = state;
            return this;
        }

        public Builder width(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder height(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder padding(int padding) {
            this.mPaddingLeft = padding;
            this.mPaddingTop = padding;
            this.mPaddingRight = padding;
            this.mPaddingBottom = padding;
            return this;
        }

        public Builder paddingLeft(int padding) {
            this.mPaddingLeft = padding;
            return this;
        }

        public Builder paddingTop(int padding) {
            this.mPaddingTop = padding;
            return this;
        }

        public Builder paddingRight(int padding) {
            this.mPaddingRight = padding;
            return this;
        }

        public Builder paddingBottom(int padding) {
            this.mPaddingBottom = padding;
            return this;
        }

        public Builder animDuration(int duration) {
            this.mAnimDuration = duration;
            return this;
        }

        public Builder interpolator(Interpolator interpolator) {
            this.mInterpolator = interpolator;
            return this;
        }

        public Builder strokeSize(int size) {
            this.mStrokeSize = size;
            return this;
        }

        public Builder strokeColor(int strokeColor) {
            this.mStrokeColor = strokeColor;
            return this;
        }

        public Builder strokeCap(Paint.Cap cap) {
            this.mStrokeCap = cap;
            return this;
        }

        public Builder strokeJoin(Paint.Join join) {
            this.mStrokeJoin = join;
            return this;
        }

        public Builder clockwise(boolean clockwise) {
            this.mClockwise = clockwise;
            return this;
        }

        public Builder rtl(boolean rtl) {
            this.mIsRtl = rtl;
            return this;
        }
    }

    public static class State {
        float[] points;
        int[] links;

        public State() {
        }

        public State(float[] points, int[] links) {
            this.points = points;
            this.links = links;
        }
    }
}

