/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.FragmentManager;
import com.rey.material.app.ThemeManager;
import com.rey.material.drawable.NavigationDrawerDrawable;
import com.rey.material.drawable.ToolbarRippleDrawable;
import com.rey.material.util.ViewUtil;
import java.util.ArrayList;
import java.util.List;

public class ToolbarManager {
    private AppCompatDelegate mAppCompatDelegate;
    private Toolbar mToolbar;
    private int mRippleStyle;
    private Animator mAnimator;
    private ActionMenuView mMenuView;
    private ToolbarRippleDrawable.Builder mBuilder;
    private int mCurrentGroup = 0;
    private boolean mGroupChanged = false;
    private boolean mMenuDataChanged = true;
    private ArrayList<OnToolbarGroupChangedListener> mListeners = new ArrayList();
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            ToolbarManager.this.onGlobalLayout();
        }
    };
    private ArrayList<Animation> mAnimations = new ArrayList();
    private Animation.AnimationListener mOutAnimationEndListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (ToolbarManager.this.mAppCompatDelegate != null) {
                ToolbarManager.this.mAppCompatDelegate.invalidateOptionsMenu();
            } else {
                ToolbarManager.this.onPrepareMenu();
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private NavigationManager mNavigationManager;

    public ToolbarManager(AppCompatDelegate delegate, Toolbar toolbar, int defaultGroupId, int rippleStyle, int animIn, int animOut) {
        this(delegate, toolbar, defaultGroupId, rippleStyle, new SimpleAnimator(animIn, animOut));
    }

    public ToolbarManager(AppCompatDelegate delegate, Toolbar toolbar, int defaultGroupId, int rippleStyle, Animator animator) {
        this.mAppCompatDelegate = delegate;
        this.mToolbar = toolbar;
        this.mCurrentGroup = defaultGroupId;
        this.mRippleStyle = rippleStyle;
        this.mAnimator = animator;
        this.mAppCompatDelegate.setSupportActionBar(toolbar);
    }

    public void registerOnToolbarGroupChangedListener(OnToolbarGroupChangedListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void unregisterOnToolbarGroupChangedListener(OnToolbarGroupChangedListener listener) {
        this.mListeners.remove(listener);
    }

    private void dispatchOnToolbarGroupChanged(int oldGroupId, int groupId) {
        for (OnToolbarGroupChangedListener listener : this.mListeners) {
            listener.onToolbarGroupChanged(oldGroupId, groupId);
        }
    }

    public int getCurrentGroup() {
        return this.mCurrentGroup;
    }

    public void setCurrentGroup(int groupId) {
        if (this.mCurrentGroup != groupId) {
            int oldGroupId = this.mCurrentGroup;
            this.mCurrentGroup = groupId;
            this.mGroupChanged = true;
            this.dispatchOnToolbarGroupChanged(oldGroupId, this.mCurrentGroup);
            this.animateOut();
        }
    }

    public void createMenu(int menuId) {
        this.mToolbar.inflateMenu(menuId);
        this.mMenuDataChanged = true;
        if (this.mAppCompatDelegate == null) {
            this.onPrepareMenu();
        }
    }

    public void onPrepareMenu() {
        if (this.mGroupChanged || this.mMenuDataChanged) {
            this.mToolbar.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
            Menu menu = this.mToolbar.getMenu();
            int count = menu.size();
            for (int i = 0; i < count; ++i) {
                MenuItem item;
                item.setVisible((item = menu.getItem(i)).getGroupId() == this.mCurrentGroup || item.getGroupId() == 0);
            }
            this.mMenuDataChanged = false;
        }
    }

    public void setNavigationManager(NavigationManager navigationManager) {
        this.mNavigationManager = navigationManager;
        this.notifyNavigationStateInvalidated();
    }

    public void notifyNavigationStateInvalidated() {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.notifyStateInvalidated();
        }
    }

    public void notifyNavigationStateChanged() {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.notifyStateChanged();
        }
    }

    public void notifyNavigationStateProgressChanged(boolean isBackState, float progress) {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.notifyStateProgressChanged(isBackState, progress);
        }
    }

    public boolean isNavigationBackState() {
        return this.mNavigationManager != null && this.mNavigationManager.isBackState();
    }

    public boolean isNavigationVisisble() {
        return this.mNavigationManager != null && this.mNavigationManager.isNavigationVisible();
    }

    public void setNavigationVisisble(boolean visible, boolean animation) {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.setNavigationVisible(visible, animation);
        }
    }

    private ToolbarRippleDrawable getBackground() {
        if (this.mBuilder == null) {
            this.mBuilder = new ToolbarRippleDrawable.Builder(this.mToolbar.getContext(), this.mRippleStyle);
        }
        return this.mBuilder.build();
    }

    private ActionMenuView getMenuView() {
        if (this.mMenuView == null) {
            for (int i = 0; i < this.mToolbar.getChildCount(); ++i) {
                View child = this.mToolbar.getChildAt(i);
                if (!(child instanceof ActionMenuView)) continue;
                this.mMenuView = (ActionMenuView)child;
                break;
            }
        }
        return this.mMenuView;
    }

    private void onGlobalLayout() {
        int count;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mToolbar.getViewTreeObserver().removeOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        } else {
            this.mToolbar.getViewTreeObserver().removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
        }
        ActionMenuView menuView = this.getMenuView();
        int n = count = menuView == null ? 0 : menuView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            if (this.mRippleStyle == 0 || child.getBackground() != null && child.getBackground() instanceof ToolbarRippleDrawable) continue;
            ViewUtil.setBackground(child, this.getBackground());
        }
        if (this.mGroupChanged) {
            this.animateIn();
            this.mGroupChanged = false;
        }
    }

    private void animateOut() {
        int i;
        ActionMenuView menuView = this.getMenuView();
        int count = menuView == null ? 0 : menuView.getChildCount();
        Animation slowestAnimation = null;
        this.mAnimations.clear();
        this.mAnimations.ensureCapacity(count);
        for (i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            Animation anim = this.mAnimator.getOutAnimation(child, i);
            this.mAnimations.add(anim);
            if (anim == null || slowestAnimation != null && slowestAnimation.getStartOffset() + slowestAnimation.getDuration() >= anim.getStartOffset() + anim.getDuration()) continue;
            slowestAnimation = anim;
        }
        if (slowestAnimation == null) {
            this.mOutAnimationEndListener.onAnimationEnd(null);
        } else {
            slowestAnimation.setAnimationListener(this.mOutAnimationEndListener);
            for (i = 0; i < count; ++i) {
                Animation anim = this.mAnimations.get(i);
                if (anim == null) continue;
                menuView.getChildAt(i).startAnimation(anim);
            }
        }
        this.mAnimations.clear();
    }

    private void animateIn() {
        int count;
        ActionMenuView menuView = this.getMenuView();
        int n = count = menuView == null ? 0 : menuView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            Animation anim = this.mAnimator.getInAnimation(child, i);
            if (anim == null) continue;
            child.startAnimation(anim);
        }
    }

    public static class ThemableNavigationManager
    extends BaseNavigationManager
    implements ThemeManager.OnThemeChangedListener {
        private int mStyleId;
        private int mCurrentStyle;

        public ThemableNavigationManager(int styleId, FragmentManager fragmentManager, Toolbar toolbar, DrawerLayout drawerLayout) {
            super(ThemeManager.getInstance().getCurrentStyle(styleId), fragmentManager, toolbar, drawerLayout);
            this.mStyleId = styleId;
            this.mCurrentStyle = ThemeManager.getInstance().getCurrentStyle(styleId);
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
        }

        @Override
        public void onThemeChanged(@Nullable ThemeManager.OnThemeChangedEvent event) {
            int style2 = ThemeManager.getInstance().getCurrentStyle(this.mStyleId);
            if (this.mCurrentStyle != style2) {
                this.mCurrentStyle = style2;
                NavigationDrawerDrawable drawable = new NavigationDrawerDrawable.Builder(this.mToolbar.getContext(), this.mCurrentStyle).build();
                drawable.switchIconState(this.mNavigationIcon.getIconState(), false);
                this.mNavigationIcon = drawable;
                this.mToolbar.setNavigationIcon((Drawable)(this.mNavigationVisible ? this.mNavigationIcon : null));
            }
        }
    }

    public static class BaseNavigationManager
    extends NavigationManager {
        protected DrawerLayout mDrawerLayout;
        protected FragmentManager mFragmentManager;

        public BaseNavigationManager(int styleId, FragmentManager fragmentManager, Toolbar toolbar, DrawerLayout drawerLayout) {
            super(new NavigationDrawerDrawable.Builder(toolbar.getContext(), styleId).build(), toolbar);
            this.mDrawerLayout = drawerLayout;
            this.mFragmentManager = fragmentManager;
            if (this.mDrawerLayout != null) {
                this.mDrawerLayout.setDrawerListener(new DrawerLayout.DrawerListener(){

                    public void onDrawerSlide(View drawerView, float slideOffset) {
                        BaseNavigationManager.this.onDrawerSlide(drawerView, slideOffset);
                    }

                    public void onDrawerOpened(View drawerView) {
                        BaseNavigationManager.this.onDrawerOpened(drawerView);
                    }

                    public void onDrawerClosed(View drawerView) {
                        BaseNavigationManager.this.onDrawerClosed(drawerView);
                    }

                    public void onDrawerStateChanged(int newState) {
                        BaseNavigationManager.this.onDrawerStateChanged(newState);
                    }
                });
            }
            this.mFragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

                public void onBackStackChanged() {
                    BaseNavigationManager.this.onFragmentChanged();
                }
            });
        }

        @Override
        public boolean isBackState() {
            return this.mFragmentManager.getBackStackEntryCount() > 1 || this.mDrawerLayout != null && this.mDrawerLayout.isDrawerOpen(0x800003);
        }

        @Override
        public void onNavigationClick() {
        }

        protected boolean shouldSyncDrawerSlidingProgress() {
            return this.mFragmentManager.getBackStackEntryCount() <= 1;
        }

        protected void onFragmentChanged() {
            this.notifyStateChanged();
        }

        protected void onDrawerSlide(View drawerView, float slideOffset) {
            if (!this.shouldSyncDrawerSlidingProgress()) {
                this.notifyStateInvalidated();
            } else if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
                this.notifyStateProgressChanged(false, 1.0f - slideOffset);
            } else {
                this.notifyStateProgressChanged(true, slideOffset);
            }
        }

        protected void onDrawerOpened(View drawerView) {
        }

        protected void onDrawerClosed(View drawerView) {
        }

        protected void onDrawerStateChanged(int newState) {
        }
    }

    public static abstract class NavigationManager {
        protected NavigationDrawerDrawable mNavigationIcon;
        protected Toolbar mToolbar;
        protected boolean mNavigationVisible = true;
        protected long mAnimationDuration;
        private long mAnimTime;
        private List<Object> mAnimations = new ArrayList<Object>();

        public NavigationManager(NavigationDrawerDrawable navigationIcon, Toolbar toolbar) {
            this.mToolbar = toolbar;
            this.mNavigationIcon = navigationIcon;
            this.mToolbar.setNavigationIcon((Drawable)(this.mNavigationVisible ? this.mNavigationIcon : null));
            this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NavigationManager.this.onNavigationClick();
                }
            });
            this.mAnimationDuration = toolbar.getResources().getInteger(0x10E0000);
        }

        public abstract boolean isBackState();

        public abstract void onNavigationClick();

        public void notifyStateInvalidated() {
            this.mNavigationIcon.switchIconState(this.isBackState() ? 1 : 0, false);
        }

        public void notifyStateChanged() {
            this.mNavigationIcon.switchIconState(this.isBackState() ? 1 : 0, this.mNavigationVisible);
        }

        public void notifyStateProgressChanged(boolean isBackState, float progress) {
            this.mNavigationIcon.setIconState(isBackState ? 1 : 0, progress);
        }

        public boolean isNavigationVisible() {
            return this.mNavigationVisible;
        }

        public void setNavigationVisible(boolean visible, boolean animation) {
            if (this.mNavigationVisible != visible) {
                this.mNavigationVisible = visible;
                long time = SystemClock.uptimeMillis();
                if (!animation) {
                    this.mToolbar.setNavigationIcon((Drawable)(this.mNavigationVisible ? this.mNavigationIcon : null));
                    this.mAnimTime = time;
                    if (!this.mNavigationVisible) {
                        this.mNavigationIcon.cancel();
                    }
                } else if (this.mNavigationVisible) {
                    this.animateNavigationIn(time);
                } else {
                    this.animateNavigationOut(time);
                }
            }
        }

        protected Interpolator getInterpolator(boolean in) {
            return new DecelerateInterpolator();
        }

        private void cancelAllAnimations() {
            for (Object obj : this.mAnimations) {
                if (obj instanceof Animation) {
                    ((Animation)obj).cancel();
                    continue;
                }
                if (!(obj instanceof ValueAnimator)) continue;
                ((ValueAnimator)obj).cancel();
            }
            this.mAnimations.clear();
        }

        private void animateNavigationOut(long time) {
            this.mAnimTime = time;
            this.cancelAllAnimations();
            this.mToolbar.setNavigationIcon(null);
            this.doOnPreDraw((View)this.mToolbar, new AnimRunnable(time){

                @Override
                void doWork() {
                    final ViewData viewData = new ViewData(NavigationManager.this.mToolbar);
                    NavigationManager.this.mToolbar.setNavigationIcon((Drawable)NavigationManager.this.mNavigationIcon);
                    NavigationManager.this.doOnPreDraw((View)NavigationManager.this.mToolbar, new AnimRunnable(this.mTime){

                        @Override
                        void doWork() {
                            boolean first = true;
                            int count = NavigationManager.this.mToolbar.getChildCount();
                            for (int i = 0; i < count; ++i) {
                                View child = NavigationManager.this.mToolbar.getChildAt(i);
                                if (child instanceof ActionMenuView) continue;
                                int nextLeft = viewData.getLeft(child);
                                if (nextLeft < 0) {
                                    nextLeft = -child.getLeft() - child.getWidth();
                                }
                                if (first) {
                                    NavigationManager.this.animateViewOut(child, nextLeft, new Runnable(){

                                        @Override
                                        public void run() {
                                            NavigationManager.this.mToolbar.setNavigationIcon(null);
                                            NavigationManager.this.mNavigationIcon.cancel();
                                        }
                                    });
                                    first = false;
                                    continue;
                                }
                                NavigationManager.this.animateViewOut(child, nextLeft, null);
                            }
                            if (first) {
                                NavigationManager.this.mToolbar.setNavigationIcon(null);
                            }
                        }
                    });
                }
            });
        }

        private void animateViewOut(final View view, final int nextLeft, final Runnable doOnEndRunnable) {
            final Interpolator interpolator = this.getInterpolator(false);
            final int prevLeft = view.getLeft();
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            animator.setDuration(this.mAnimationDuration);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float factor = interpolator.getInterpolation(valueAnimator.getAnimatedFraction());
                    float left = (float)prevLeft + (float)(nextLeft - prevLeft) * factor;
                    view.offsetLeftAndRight((int)(left - (float)view.getLeft()));
                    if (valueAnimator.getAnimatedFraction() == 1.0f && doOnEndRunnable != null) {
                        doOnEndRunnable.run();
                    }
                }
            });
            animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(android.animation.Animator animator) {
                }

                public void onAnimationEnd(android.animation.Animator animator) {
                    NavigationManager.this.mAnimations.remove(animator);
                }

                public void onAnimationCancel(android.animation.Animator animator) {
                }

                public void onAnimationRepeat(android.animation.Animator animator) {
                }
            });
            animator.start();
            this.mAnimations.add(animator);
        }

        private void animateNavigationIn(long time) {
            this.mAnimTime = time;
            this.cancelAllAnimations();
            this.mToolbar.setNavigationIcon(null);
            this.doOnPreDraw((View)this.mToolbar, new AnimRunnable(time){

                @Override
                void doWork() {
                    final ViewData viewData = new ViewData(NavigationManager.this.mToolbar);
                    NavigationManager.this.mToolbar.setNavigationIcon((Drawable)NavigationManager.this.mNavigationIcon);
                    NavigationManager.this.doOnPreDraw((View)NavigationManager.this.mToolbar, new AnimRunnable(this.mTime){

                        @Override
                        void doWork() {
                            int count = NavigationManager.this.mToolbar.getChildCount();
                            for (int i = 0; i < count; ++i) {
                                View child = NavigationManager.this.mToolbar.getChildAt(i);
                                if (child instanceof ActionMenuView) continue;
                                int prevLeft = viewData.getLeft(child);
                                if (prevLeft < 0) {
                                    prevLeft = -child.getLeft() - child.getWidth();
                                }
                                NavigationManager.this.animateViewIn(child, prevLeft);
                            }
                        }
                    });
                }
            });
        }

        private void animateViewIn(View view, int prevLeft) {
            TranslateAnimation anim = new TranslateAnimation(0, (float)(prevLeft - view.getLeft()), 0, 0.0f, 0, 0.0f, 0, 0.0f);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    NavigationManager.this.mAnimations.remove(animation);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            anim.setInterpolator(this.getInterpolator(true));
            anim.setDuration(this.mAnimationDuration);
            view.startAnimation((Animation)anim);
            this.mAnimations.add(anim);
        }

        private void doOnPreDraw(final View v, final Runnable runnable) {
            v.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    runnable.run();
                    v.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return false;
                }
            });
        }

        abstract class AnimRunnable
        implements Runnable {
            long mTime;

            public AnimRunnable(long time) {
                this.mTime = time;
            }

            @Override
            public void run() {
                if (this.mTime == NavigationManager.this.mAnimTime) {
                    this.doWork();
                }
            }

            abstract void doWork();
        }

        static class ViewData {
            List<View> views;
            List<Integer> lefts;

            public ViewData(Toolbar toolbar) {
                int count = toolbar.getChildCount();
                this.views = new ArrayList<View>(count);
                this.lefts = new ArrayList<Integer>(count);
                for (int i = 0; i < count; ++i) {
                    View child = toolbar.getChildAt(i);
                    if (child instanceof ActionMenuView) continue;
                    this.views.add(child);
                    this.lefts.add(child.getLeft());
                }
            }

            public int getLeft(View view) {
                int size = this.views.size();
                for (int i = 0; i < size; ++i) {
                    if (this.views.get(i) != view) continue;
                    return this.lefts.get(i);
                }
                return -1;
            }
        }
    }

    private static class SimpleAnimator
    implements Animator {
        private int mAnimationIn;
        private int mAnimationOut;

        public SimpleAnimator(int animIn, int animOut) {
            this.mAnimationIn = animIn;
            this.mAnimationOut = animOut;
        }

        @Override
        public Animation getOutAnimation(View v, int position) {
            return this.mAnimationOut == 0 ? null : AnimationUtils.loadAnimation((Context)v.getContext(), (int)this.mAnimationOut);
        }

        @Override
        public Animation getInAnimation(View v, int position) {
            return this.mAnimationIn == 0 ? null : AnimationUtils.loadAnimation((Context)v.getContext(), (int)this.mAnimationIn);
        }
    }

    public static interface Animator {
        public Animation getOutAnimation(View var1, int var2);

        public Animation getInAnimation(View var1, int var2);
    }

    public static interface OnToolbarGroupChangedListener {
        public void onToolbarGroupChanged(int var1, int var2);
    }
}

