/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.rey.material.R;

public class ThemeUtil {
    private static TypedValue value;

    public static int dpToPx(Context context, int dp) {
        return (int)(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    public static int spToPx(Context context, int sp) {
        return (int)(TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    private static int getColor(Context context, int id, int defaultValue) {
        if (value == null) {
            value = new TypedValue();
        }
        try {
            Resources.Theme theme = context.getTheme();
            if (theme != null && theme.resolveAttribute(id, value, true)) {
                if (ThemeUtil.value.type >= 16 && ThemeUtil.value.type <= 31) {
                    return ThemeUtil.value.data;
                }
                if (ThemeUtil.value.type == 3) {
                    return context.getResources().getColor(ThemeUtil.value.resourceId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static int windowBackground(Context context, int defaultValue) {
        return ThemeUtil.getColor(context, 16842836, defaultValue);
    }

    public static int textColorPrimary(Context context, int defaultValue) {
        return ThemeUtil.getColor(context, 16842806, defaultValue);
    }

    public static int textColorSecondary(Context context, int defaultValue) {
        return ThemeUtil.getColor(context, 16842808, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorPrimary(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843827, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorPrimary, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorPrimaryDark(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843828, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorPrimaryDark, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorAccent(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843829, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorAccent, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorControlNormal(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843817, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorControlNormal, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorControlActivated(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843818, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorControlActivated, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorControlHighlight(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843820, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorControlHighlight, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorButtonNormal(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThemeUtil.getColor(context, 16843819, defaultValue);
        }
        return ThemeUtil.getColor(context, R.attr.colorButtonNormal, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorSwitchThumbNormal(Context context, int defaultValue) {
        return ThemeUtil.getColor(context, R.attr.colorSwitchThumbNormal, defaultValue);
    }

    public static int getType(TypedArray array, int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return array.getType(index);
        }
        TypedValue value = array.peekValue(index);
        return value == null ? 0 : value.type;
    }

    public static CharSequence getString(TypedArray array, int index, CharSequence defaultValue) {
        String result = array.getString(index);
        return result == null ? defaultValue : result;
    }
}

