/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.LevelListDrawable;
import com.rey.material.app.ThemeManager;

public class ThemeDrawable
extends LevelListDrawable
implements ThemeManager.OnThemeChangedListener {
    private int mStyleId;

    public ThemeDrawable(int styleId) {
        this.mStyleId = styleId;
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
            this.initDrawables();
        }
    }

    private void initDrawables() {
        ThemeManager themeManager = ThemeManager.getInstance();
        int count = themeManager.getThemeCount();
        for (int i = 0; i < count; ++i) {
            Drawable drawable = themeManager.getContext().getResources().getDrawable(themeManager.getStyle(this.mStyleId, i));
            this.addLevel(i, i, drawable);
        }
        this.setLevel(themeManager.getCurrentTheme());
    }

    @Override
    public void onThemeChanged(ThemeManager.OnThemeChangedEvent event) {
        if (this.getLevel() != event.theme) {
            this.setLevel(event.theme);
        }
    }
}

