/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.util.ColorUtil;

public class RevealDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private long mStartTime;
    private float mAnimProgress;
    private Paint mShaderPaint;
    private Paint mFillPaint;
    private int mCurColor;
    private RadialGradient mShader;
    private Matrix mMatrix;
    private RectF mRect;
    private float mMaxRadius;
    private ColorChangeTask[] mTasks;
    private int mCurTask;
    private boolean mCurColorTransparent;
    private boolean mNextColorTransparent;
    private static final float[] GRADIENT_STOPS = new float[]{0.0f, 0.99f, 1.0f};
    private static final float GRADIENT_RADIUS = 16.0f;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            RevealDrawable.this.update();
        }
    };

    public RevealDrawable(int color) {
        this.mShaderPaint = new Paint(1);
        this.mShaderPaint.setStyle(Paint.Style.FILL);
        this.mFillPaint = new Paint(1);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mCurColor = color;
        this.mRect = new RectF();
        this.mMatrix = new Matrix();
    }

    public int getCurColor() {
        return this.mCurColor;
    }

    public void setCurColor(int color) {
        if (this.mCurColor != color) {
            this.mCurColor = color;
            this.mCurColorTransparent = Color.alpha((int)this.mCurColor) == 0;
            this.invalidateSelf();
        }
    }

    private float getMaxRadius(float x, float y, Rect bounds) {
        float x1 = x < (float)bounds.centerX() ? (float)bounds.right : (float)bounds.left;
        float y1 = y < (float)bounds.centerY() ? (float)bounds.bottom : (float)bounds.top;
        return (float)Math.sqrt(Math.pow(x1 - x, 2.0) + Math.pow(y1 - y, 2.0));
    }

    private RadialGradient getShader(ColorChangeTask task) {
        if (this.mShader == null) {
            if (task.isOut) {
                int color_middle = ColorUtil.getColor(this.mCurColor, 0.0f);
                this.mShader = new RadialGradient(task.x, task.y, 16.0f, new int[]{0, color_middle, this.mCurColor}, GRADIENT_STOPS, Shader.TileMode.CLAMP);
            } else {
                int color_middle = ColorUtil.getColor(task.color, 0.0f);
                this.mShader = new RadialGradient(task.x, task.y, 16.0f, new int[]{0, color_middle, task.color}, GRADIENT_STOPS, Shader.TileMode.CLAMP);
            }
        }
        return this.mShader;
    }

    private void fillCanvas(Canvas canvas, int color, boolean transparent) {
        if (transparent) {
            return;
        }
        this.mFillPaint.setColor(color);
        canvas.drawRect(this.getBounds(), this.mFillPaint);
    }

    private void fillCanvasWithHole(Canvas canvas, ColorChangeTask task, float radius, boolean transparent) {
        if (transparent) {
            return;
        }
        float scale = radius / 16.0f;
        this.mMatrix.reset();
        this.mMatrix.postScale(scale, scale, task.x, task.y);
        RadialGradient shader = this.getShader(task);
        shader.setLocalMatrix(this.mMatrix);
        this.mShaderPaint.setShader((Shader)shader);
        canvas.drawRect(this.getBounds(), this.mShaderPaint);
    }

    private void fillCircle(Canvas canvas, float x, float y, float radius, int color, boolean transparent) {
        if (transparent) {
            return;
        }
        this.mFillPaint.setColor(color);
        this.mRect.set(x - radius, y - radius, x + radius, y + radius);
        canvas.drawOval(this.mRect, this.mFillPaint);
    }

    public void draw(Canvas canvas) {
        if (!this.isRunning()) {
            this.fillCanvas(canvas, this.mCurColor, this.mCurColorTransparent);
        } else {
            ColorChangeTask task = this.mTasks[this.mCurTask];
            if (this.mAnimProgress == 0.0f) {
                this.fillCanvas(canvas, this.mCurColor, this.mCurColorTransparent);
            } else if (this.mAnimProgress == 1.0f) {
                this.fillCanvas(canvas, task.color, this.mNextColorTransparent);
            } else if (task.isOut) {
                float radius = this.mMaxRadius * task.interpolator.getInterpolation(this.mAnimProgress);
                if (Color.alpha((int)task.color) == 255) {
                    this.fillCanvas(canvas, this.mCurColor, this.mCurColorTransparent);
                } else {
                    this.fillCanvasWithHole(canvas, task, radius, this.mCurColorTransparent);
                }
                this.fillCircle(canvas, task.x, task.y, radius, task.color, this.mNextColorTransparent);
            } else {
                float radius = this.mMaxRadius * task.interpolator.getInterpolation(this.mAnimProgress);
                if (Color.alpha((int)this.mCurColor) == 255) {
                    this.fillCanvas(canvas, task.color, this.mNextColorTransparent);
                } else {
                    this.fillCanvasWithHole(canvas, task, radius, this.mNextColorTransparent);
                }
                this.fillCircle(canvas, task.x, task.y, radius, this.mCurColor, this.mCurColorTransparent);
            }
        }
    }

    public void changeColor(int color, int duration, Interpolator interpolator, float x, float y, boolean out) {
        this.changeColor(new ColorChangeTask(color, duration, interpolator, x, y, out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeColor(ColorChangeTask ... tasks) {
        Class<RevealDrawable> clazz = RevealDrawable.class;
        synchronized (RevealDrawable.class) {
            if (!this.isRunning()) {
                for (int i = 0; i < tasks.length; ++i) {
                    if (tasks[i].color == this.mCurColor) continue;
                    this.mCurTask = i;
                    this.mTasks = tasks;
                    this.start();
                    break;
                }
            } else {
                int curLength = this.mTasks.length - this.mCurTask;
                ColorChangeTask[] newTasks = new ColorChangeTask[curLength + tasks.length];
                System.arraycopy(this.mTasks, this.mCurTask, newTasks, 0, curLength);
                System.arraycopy(tasks, 0, newTasks, curLength, tasks.length);
                this.mTasks = newTasks;
                this.mCurTask = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setAlpha(int alpha) {
        this.mShaderPaint.setAlpha(alpha);
        this.mFillPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mShaderPaint.setColorFilter(cf);
        this.mFillPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
        this.mCurColorTransparent = Color.alpha((int)this.mCurColor) == 0;
        this.mNextColorTransparent = Color.alpha((int)this.mTasks[this.mCurTask].color) == 0;
        this.mMaxRadius = this.getMaxRadius(this.mTasks[this.mCurTask].x, this.mTasks[this.mCurTask].y, this.getBounds());
        this.mShader = null;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mTasks = null;
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        long curTime = SystemClock.uptimeMillis();
        Class<RevealDrawable> clazz = RevealDrawable.class;
        synchronized (RevealDrawable.class) {
            this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mTasks[this.mCurTask].duration);
            if (this.mAnimProgress == 1.0f) {
                this.setCurColor(this.mTasks[this.mCurTask].color);
                ++this.mCurTask;
                while (this.mCurTask < this.mTasks.length) {
                    if (this.mTasks[this.mCurTask].color != this.mCurColor) {
                        this.resetAnimation();
                        break;
                    }
                    ++this.mCurTask;
                }
                if (this.mCurTask == this.mTasks.length) {
                    this.stop();
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.invalidateSelf();
            if (this.isRunning()) {
                this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            }
            return;
        }
    }

    public static class ColorChangeTask {
        public final int color;
        public final int duration;
        public final Interpolator interpolator;
        public final float x;
        public final float y;
        public final boolean isOut;

        public ColorChangeTask(int color, int duration, Interpolator interpolator, float x, float y, boolean out) {
            this.color = color;
            this.duration = duration;
            this.interpolator = interpolator == null ? new DecelerateInterpolator() : interpolator;
            this.x = x;
            this.y = y;
            this.isOut = out;
        }
    }
}

