/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ViewUtil;

public class OvalShadowDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration;
    private boolean mEnable = true;
    private boolean mInEditMode = false;
    private boolean mAnimEnable = true;
    private Paint mShadowPaint;
    private Paint mGlowPaint;
    private Paint mPaint;
    private int mRadius;
    private float mShadowSize;
    private float mShadowOffset;
    private Path mShadowPath;
    private Path mGlowPath;
    private RectF mTempRect = new RectF();
    private ColorStateList mColorStateList;
    private int mPrevColor;
    private int mCurColor;
    private boolean mNeedBuildShadow = true;
    private static final int COLOR_SHADOW_START = 0x4C000000;
    private static final int COLOR_SHADOW_END = 0;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            OvalShadowDrawable.this.update();
        }
    };

    public OvalShadowDrawable(int radius, ColorStateList colorStateList, float shadowSize, float shadowOffset, int animDuration) {
        this.mAnimDuration = animDuration;
        this.mPaint = new Paint(5);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.setColor(colorStateList);
        this.setRadius(radius);
        this.setShadow(shadowSize, shadowOffset);
    }

    public boolean setRadius(int radius) {
        if (this.mRadius != radius) {
            this.mRadius = radius;
            this.mNeedBuildShadow = true;
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    public boolean setShadow(float size, float offset) {
        if (this.mShadowSize != size || this.mShadowOffset != offset) {
            this.mShadowSize = size;
            this.mShadowOffset = offset;
            this.mNeedBuildShadow = true;
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    public boolean setAnimationDuration(int duration) {
        if (this.mAnimDuration != duration) {
            this.mAnimDuration = duration;
            return true;
        }
        return false;
    }

    public void setColor(ColorStateList colorStateList) {
        this.mColorStateList = colorStateList;
        this.onStateChange(this.getState());
    }

    public void setColor(int color) {
        this.mColorStateList = ColorStateList.valueOf((int)color);
        this.onStateChange(this.getState());
    }

    public ColorStateList getColor() {
        return this.mColorStateList;
    }

    public void setInEditMode(boolean b) {
        this.mInEditMode = b;
    }

    public void setAnimEnable(boolean b) {
        this.mAnimEnable = b;
    }

    public int getRadius() {
        return this.mRadius;
    }

    public float getShadowSize() {
        return this.mShadowSize;
    }

    public float getShadowOffset() {
        return this.mShadowOffset;
    }

    public float getPaddingLeft() {
        return this.mShadowSize;
    }

    public float getPaddingTop() {
        return this.mShadowSize;
    }

    public float getPaddingRight() {
        return this.mShadowSize;
    }

    public float getPaddingBottom() {
        return this.mShadowSize + this.mShadowOffset;
    }

    public float getCenterX() {
        return (float)this.mRadius + this.mShadowSize;
    }

    public float getCenterY() {
        return (float)this.mRadius + this.mShadowSize;
    }

    public boolean isPointerOver(float x, float y) {
        float distance = (float)Math.sqrt(Math.pow(x - this.getCenterX(), 2.0) + Math.pow(y - this.getCenterY(), 2.0));
        return distance < (float)this.mRadius;
    }

    public int getIntrinsicWidth() {
        return (int)(((float)this.mRadius + this.mShadowSize) * 2.0f + 0.5f);
    }

    public int getIntrinsicHeight() {
        return (int)(((float)this.mRadius + this.mShadowSize) * 2.0f + this.mShadowOffset + 0.5f);
    }

    private void buildShadow() {
        if (this.mShadowSize <= 0.0f) {
            return;
        }
        if (this.mShadowPaint == null) {
            this.mShadowPaint = new Paint(5);
            this.mShadowPaint.setStyle(Paint.Style.FILL);
            this.mShadowPaint.setDither(true);
        }
        float startRatio = (float)this.mRadius / ((float)this.mRadius + this.mShadowSize + this.mShadowOffset);
        this.mShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)this.mRadius + this.mShadowSize, new int[]{0x4C000000, 0x4C000000, 0}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
        if (this.mShadowPath == null) {
            this.mShadowPath = new Path();
            this.mShadowPath.setFillType(Path.FillType.EVEN_ODD);
        } else {
            this.mShadowPath.reset();
        }
        float radius = (float)this.mRadius + this.mShadowSize;
        this.mTempRect.set(-radius, -radius, radius, radius);
        this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
        radius = this.mRadius - 1;
        this.mTempRect.set(-radius, -radius - this.mShadowOffset, radius, radius - this.mShadowOffset);
        this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
        if (this.mGlowPaint == null) {
            this.mGlowPaint = new Paint(5);
            this.mGlowPaint.setStyle(Paint.Style.FILL);
            this.mGlowPaint.setDither(true);
        }
        startRatio = ((float)this.mRadius - this.mShadowSize / 2.0f) / ((float)this.mRadius + this.mShadowSize / 2.0f);
        this.mGlowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)this.mRadius + this.mShadowSize / 2.0f, new int[]{0x4C000000, 0x4C000000, 0}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
        if (this.mGlowPath == null) {
            this.mGlowPath = new Path();
            this.mGlowPath.setFillType(Path.FillType.EVEN_ODD);
        } else {
            this.mGlowPath.reset();
        }
        radius = (float)this.mRadius + this.mShadowSize / 2.0f;
        this.mTempRect.set(-radius, -radius, radius, radius);
        this.mGlowPath.addOval(this.mTempRect, Path.Direction.CW);
        radius = this.mRadius - 1;
        this.mTempRect.set(-radius, -radius, radius, radius);
        this.mGlowPath.addOval(this.mTempRect, Path.Direction.CW);
    }

    public void draw(Canvas canvas) {
        int saveCount;
        if (this.mNeedBuildShadow) {
            this.buildShadow();
            this.mNeedBuildShadow = false;
        }
        if (this.mShadowSize > 0.0f) {
            saveCount = canvas.save();
            canvas.translate(this.mShadowSize + (float)this.mRadius, this.mShadowSize + (float)this.mRadius + this.mShadowOffset);
            canvas.drawPath(this.mShadowPath, this.mShadowPaint);
            canvas.restoreToCount(saveCount);
        }
        saveCount = canvas.save();
        canvas.translate(this.mShadowSize + (float)this.mRadius, this.mShadowSize + (float)this.mRadius);
        if (this.mShadowSize > 0.0f) {
            canvas.drawPath(this.mGlowPath, this.mGlowPaint);
        }
        this.mTempRect.set((float)(-this.mRadius), (float)(-this.mRadius), (float)this.mRadius, (float)this.mRadius);
        if (!this.isRunning()) {
            this.mPaint.setColor(this.mCurColor);
        } else {
            this.mPaint.setColor(ColorUtil.getMiddleColor(this.mPrevColor, this.mCurColor, this.mAnimProgress));
        }
        canvas.drawOval(this.mTempRect, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    public void setAlpha(int alpha) {
        this.mShadowPaint.setAlpha(alpha);
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mShadowPaint.setColorFilter(cf);
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isStateful() {
        return true;
    }

    protected boolean onStateChange(int[] state) {
        this.mEnable = ViewUtil.hasState(state, 16842910);
        int color = this.mColorStateList.getColorForState(state, this.mCurColor);
        if (this.mCurColor != color) {
            if (!this.mInEditMode && this.mAnimEnable && this.mEnable && this.mAnimDuration > 0) {
                this.mPrevColor = this.isRunning() ? this.mPrevColor : this.mCurColor;
                this.mCurColor = color;
                this.start();
            } else {
                this.mPrevColor = color;
                this.mCurColor = color;
                this.invalidateSelf();
            }
            return true;
        }
        if (!this.isRunning()) {
            this.mPrevColor = color;
        }
        return false;
    }

    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        this.stop();
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.mRunning = false;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }
}

