/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import com.rey.material.R;
import com.rey.material.drawable.BlankDrawable;

public class BottomSheetDialog
extends Dialog {
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    private int mLayoutHeight = -2;
    private Interpolator mInInterpolator;
    private int mInDuration;
    private Interpolator mOutInterpolator;
    private int mOutDuration;
    private ContainerFrameLayout mContainer;
    private View mContentView;
    private GestureDetector mGestureDetector;
    private int mMinFlingVelocity;
    private final Handler mHandler = new Handler();
    private final Runnable mDismissAction = new Runnable(){

        @Override
        public void run() {
            try {
                BottomSheetDialog.super.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private boolean mRunShowAnimation = false;
    private Animation mAnimation;

    public BottomSheetDialog(Context context) {
        this(context, R.style.Material_App_BottomSheetDialog);
    }

    public BottomSheetDialog(Context context, int style2) {
        super(context, style2);
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawable((Drawable)BlankDrawable.getInstance());
        WindowManager.LayoutParams layout = this.getWindow().getAttributes();
        layout.width = -1;
        layout.height = -1;
        layout.windowAnimations = R.style.DialogNoAnimation;
        this.getWindow().setAttributes(layout);
        this.init(context, style2);
    }

    private void init(Context context, int style2) {
        this.mContainer = new ContainerFrameLayout(context);
        this.cancelable(true);
        this.canceledOnTouchOutside(true);
        this.onCreate();
        this.applyStyle(style2);
        this.mMinFlingVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity() * 2;
        this.mGestureDetector = new GestureDetector(context, new GestureDetector.OnGestureListener(){

            public boolean onDown(MotionEvent e) {
                return false;
            }

            public void onShowPress(MotionEvent e) {
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                return false;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (velocityY > (float)BottomSheetDialog.this.mMinFlingVelocity) {
                    BottomSheetDialog.this.dismiss();
                    return true;
                }
                return false;
            }
        });
        super.setContentView((View)this.mContainer);
    }

    protected void onCreate() {
    }

    public BottomSheetDialog applyStyle(int styleId) {
        Context context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(styleId, R.styleable.BottomSheetDialog);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int resId;
            int attr = a.getIndex(i);
            if (attr == R.styleable.BottomSheetDialog_android_layout_height) {
                this.heightParam(a.getLayoutDimension(attr, -2));
                continue;
            }
            if (attr == R.styleable.BottomSheetDialog_bsd_cancelable) {
                this.cancelable(a.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.BottomSheetDialog_bsd_canceledOnTouchOutside) {
                this.canceledOnTouchOutside(a.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.BottomSheetDialog_bsd_dimAmount) {
                this.dimAmount(a.getFloat(attr, 0.0f));
                continue;
            }
            if (attr == R.styleable.BottomSheetDialog_bsd_inDuration) {
                this.inDuration(a.getInteger(attr, 0));
                continue;
            }
            if (attr == R.styleable.BottomSheetDialog_bsd_inInterpolator) {
                resId = a.getResourceId(attr, 0);
                if (resId == 0) continue;
                this.inInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
                continue;
            }
            if (attr == R.styleable.BottomSheetDialog_bsd_outDuration) {
                this.outDuration(a.getInteger(attr, 0));
                continue;
            }
            if (attr != R.styleable.BottomSheetDialog_bsd_outInterpolator || (resId = a.getResourceId(attr, 0)) == 0) continue;
            this.outInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
        }
        a.recycle();
        if (this.mInInterpolator == null) {
            this.mInInterpolator = new DecelerateInterpolator();
        }
        if (this.mOutInterpolator == null) {
            this.mOutInterpolator = new AccelerateInterpolator();
        }
        return this;
    }

    public BottomSheetDialog cancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        this.mCancelable = cancelable;
        return this;
    }

    public BottomSheetDialog canceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        this.mCanceledOnTouchOutside = cancel;
        return this;
    }

    public BottomSheetDialog dimAmount(float amount) {
        Window window = this.getWindow();
        if (amount > 0.0f) {
            window.addFlags(2);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.dimAmount = amount;
            window.setAttributes(lp);
        } else {
            window.clearFlags(2);
        }
        return this;
    }

    public BottomSheetDialog contentView(View v) {
        this.mContentView = v;
        this.mContainer.removeAllViews();
        this.mContainer.addView(v);
        return this;
    }

    public BottomSheetDialog contentView(int layoutId) {
        if (layoutId == 0) {
            return this;
        }
        View v = LayoutInflater.from((Context)this.getContext()).inflate(layoutId, null);
        return this.contentView(v);
    }

    public BottomSheetDialog heightParam(int height) {
        if (this.mLayoutHeight != height) {
            this.mLayoutHeight = height;
            if (this.isShowing() && this.mContentView != null) {
                this.mRunShowAnimation = true;
                this.mContainer.forceLayout();
                this.mContainer.requestLayout();
            }
        }
        return this;
    }

    public BottomSheetDialog inDuration(int duration) {
        this.mInDuration = duration;
        return this;
    }

    public BottomSheetDialog inInterpolator(Interpolator interpolator) {
        this.mInInterpolator = interpolator;
        return this;
    }

    public BottomSheetDialog outDuration(int duration) {
        this.mOutDuration = duration;
        return this;
    }

    public BottomSheetDialog outInterpolator(Interpolator interpolator) {
        this.mOutInterpolator = interpolator;
        return this;
    }

    protected void onStart() {
        super.onStart();
        if (this.mContentView != null) {
            this.mRunShowAnimation = true;
            this.mContainer.forceLayout();
        }
    }

    protected void onStop() {
        super.onStop();
        this.mContainer = null;
        this.mContentView = null;
        this.mGestureDetector = null;
    }

    public void setCancelable(boolean flag) {
        this.cancelable(flag);
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        this.canceledOnTouchOutside(cancel);
    }

    public void setContentView(View v) {
        this.contentView(v);
    }

    public void setContentView(int layoutId) {
        this.contentView(layoutId);
    }

    public void setContentView(View v, ViewGroup.LayoutParams params) {
        this.contentView(v);
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.contentView(view);
    }

    public void dismissImmediately() {
        super.dismiss();
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mDismissAction);
        }
    }

    public void dismiss() {
        if (!this.isShowing()) {
            return;
        }
        if (this.mContentView != null) {
            this.mAnimation = new SlideAnimation(this.mContentView.getTop(), this.mContainer.getMeasuredHeight());
            this.mAnimation.setDuration((long)this.mOutDuration);
            this.mAnimation.setInterpolator(this.mOutInterpolator);
            this.mAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    BottomSheetDialog.this.mAnimation = null;
                    BottomSheetDialog.this.mHandler.post(BottomSheetDialog.this.mDismissAction);
                }
            });
            this.mContentView.startAnimation(this.mAnimation);
        } else {
            this.mHandler.post(this.mDismissAction);
        }
    }

    protected int getContainerHeight() {
        return this.mContainer == null ? 0 : this.mContainer.getHeight();
    }

    private class SlideAnimation
    extends Animation {
        int mStart;
        int mEnd;

        public SlideAnimation(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int top = Math.round((float)(this.mEnd - this.mStart) * interpolatedTime + (float)this.mStart);
            if (BottomSheetDialog.this.mContainer != null) {
                BottomSheetDialog.this.mContainer.setChildTop(top);
            } else {
                this.cancel();
            }
        }
    }

    private class ContainerFrameLayout
    extends FrameLayout {
        private boolean mClickOutside;
        private int mChildTop;

        public ContainerFrameLayout(Context context) {
            super(context);
            this.mClickOutside = false;
            this.mChildTop = -1;
        }

        public void setChildTop(int top) {
            this.mChildTop = top;
            View child = this.getChildAt(0);
            if (child != null) {
                child.offsetTopAndBottom(this.mChildTop - child.getTop());
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            View child = this.getChildAt(0);
            if (child != null) {
                switch (BottomSheetDialog.this.mLayoutHeight) {
                    case -2: {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)Integer.MIN_VALUE));
                        break;
                    }
                    case -1: {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000));
                        break;
                    }
                    default: {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)Math.min(BottomSheetDialog.this.mLayoutHeight, heightSize), (int)0x40000000));
                    }
                }
            }
            this.setMeasuredDimension(widthSize, heightSize);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            View child = this.getChildAt(0);
            if (child != null) {
                if (this.mChildTop < 0) {
                    this.mChildTop = bottom - top;
                }
                child.layout(0, this.mChildTop, child.getMeasuredWidth(), Math.max(bottom - top, this.mChildTop + child.getMeasuredHeight()));
                if (BottomSheetDialog.this.mRunShowAnimation) {
                    int end;
                    int start;
                    BottomSheetDialog.this.mRunShowAnimation = false;
                    if (BottomSheetDialog.this.mAnimation != null) {
                        BottomSheetDialog.this.mAnimation.cancel();
                        BottomSheetDialog.this.mAnimation = null;
                    }
                    if (BottomSheetDialog.this.mContentView != null && (start = this.mChildTop < 0 ? this.getHeight() : child.getTop()) != (end = this.getMeasuredHeight() - BottomSheetDialog.this.mContentView.getMeasuredHeight())) {
                        BottomSheetDialog.this.mAnimation = new SlideAnimation(start, end);
                        BottomSheetDialog.this.mAnimation.setDuration((long)BottomSheetDialog.this.mInDuration);
                        BottomSheetDialog.this.mAnimation.setInterpolator(BottomSheetDialog.this.mInInterpolator);
                        BottomSheetDialog.this.mAnimation.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }

                            public void onAnimationEnd(Animation animation) {
                                BottomSheetDialog.this.mAnimation = null;
                            }
                        });
                        BottomSheetDialog.this.mContentView.startAnimation(BottomSheetDialog.this.mAnimation);
                    }
                }
            }
        }

        private boolean isOutsideDialog(float x, float y) {
            if (y < (float)this.mChildTop) {
                return true;
            }
            View child = this.getChildAt(0);
            return child != null && y > (float)(this.mChildTop + child.getMeasuredHeight());
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            if (!super.dispatchTouchEvent(ev) && BottomSheetDialog.this.mGestureDetector != null) {
                BottomSheetDialog.this.mGestureDetector.onTouchEvent(ev);
            }
            return true;
        }

        public boolean onTouchEvent(MotionEvent event) {
            boolean handled = super.onTouchEvent(event);
            if (handled) {
                return true;
            }
            switch (event.getAction()) {
                case 0: {
                    if (this.isOutsideDialog(event.getX(), event.getY())) {
                        this.mClickOutside = true;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return this.mClickOutside;
                }
                case 3: {
                    this.mClickOutside = false;
                    return false;
                }
                case 1: {
                    if (this.mClickOutside && this.isOutsideDialog(event.getX(), event.getY())) {
                        this.mClickOutside = false;
                        if (BottomSheetDialog.this.mCancelable && BottomSheetDialog.this.mCanceledOnTouchOutside) {
                            BottomSheetDialog.this.dismiss();
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

