/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.util.SparseArray;
import com.rey.material.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class ThemeManager {
    private static volatile ThemeManager mInstance;
    private Context mContext;
    private SparseArray<int[]> mStyles = new SparseArray();
    private int mCurrentTheme;
    private int mThemeCount;
    private EventDispatcher mDispatcher;
    private static final String PREF = "theme.pref";
    private static final String KEY_THEME = "theme";
    public static final int THEME_UNDEFINED = Integer.MIN_VALUE;

    public static int getStyleId(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ThemableView, defStyleAttr, defStyleRes);
        int styleId = a.getResourceId(R.styleable.ThemableView_v_styleId, 0);
        a.recycle();
        return styleId;
    }

    public static void init(Context context, int totalTheme, int defaultTheme, @Nullable EventDispatcher dispatcher) {
        ThemeManager.getInstance().setup(context, totalTheme, defaultTheme, dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThemeManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ThemeManager> clazz = ThemeManager.class;
        synchronized (ThemeManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ThemeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    protected void setup(Context context, int totalTheme, int defaultTheme, @Nullable EventDispatcher dispatcher) {
        this.mContext = context;
        this.mDispatcher = dispatcher != null ? dispatcher : new SimpleDispatcher();
        this.mThemeCount = totalTheme;
        this.mCurrentTheme = this.getSharedPreferences().getInt(KEY_THEME, defaultTheme);
        if (this.mCurrentTheme >= this.mThemeCount) {
            this.setCurrentTheme(defaultTheme);
        }
    }

    private int[] loadStyleList(Context context, int resId) {
        TypedArray array = context.getResources().obtainTypedArray(resId);
        int[] result = new int[array.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.getResourceId(i, 0);
        }
        array.recycle();
        return result;
    }

    private int[] getStyleList(int styleId) {
        int[] list = (int[])this.mStyles.get(styleId);
        if (list == null) {
            list = this.loadStyleList(this.mContext, styleId);
            this.mStyles.put(styleId, (Object)list);
        }
        return list;
    }

    private SharedPreferences getSharedPreferences() {
        return this.mContext.getSharedPreferences(PREF, 0);
    }

    private void dispatchThemeChanged(int theme) {
        this.mDispatcher.dispatchThemeChanged(theme);
    }

    public Context getContext() {
        return this.mContext;
    }

    @UiThread
    public int getCurrentTheme() {
        return this.mCurrentTheme;
    }

    public boolean setCurrentTheme(int theme) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            return false;
        }
        if (this.mCurrentTheme != theme) {
            this.mCurrentTheme = theme;
            this.getSharedPreferences().edit().putInt(KEY_THEME, this.mCurrentTheme).commit();
            this.dispatchThemeChanged(this.mCurrentTheme);
            return true;
        }
        return false;
    }

    public int getThemeCount() {
        return this.mThemeCount;
    }

    public int getCurrentStyle(int styleId) {
        return this.getStyle(styleId, this.mCurrentTheme);
    }

    public int getStyle(int styleId, int theme) {
        int[] styles = this.getStyleList(styleId);
        return styles[theme];
    }

    public void registerOnThemeChangedListener(@NonNull OnThemeChangedListener listener) {
        this.mDispatcher.registerListener(listener);
    }

    public void unregisterOnThemeChangedListener(@NonNull OnThemeChangedListener listener) {
        this.mDispatcher.unregisterListener(listener);
    }

    public static class OnThemeChangedEvent {
        public final int theme;

        public OnThemeChangedEvent(int theme) {
            this.theme = theme;
        }
    }

    public static interface OnThemeChangedListener {
        public void onThemeChanged(@Nullable OnThemeChangedEvent var1);
    }

    public static class SimpleDispatcher
    implements EventDispatcher {
        ArrayList<WeakReference<OnThemeChangedListener>> mListeners = new ArrayList();

        @Override
        public void registerListener(OnThemeChangedListener listener) {
            boolean exist = false;
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                WeakReference<OnThemeChangedListener> ref = this.mListeners.get(i);
                if (ref.get() == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                if (ref.get() != listener) continue;
                exist = true;
            }
            if (!exist) {
                this.mListeners.add(new WeakReference<OnThemeChangedListener>(listener));
            }
        }

        @Override
        public void unregisterListener(OnThemeChangedListener listener) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                WeakReference<OnThemeChangedListener> ref = this.mListeners.get(i);
                if (ref.get() != null && ref.get() != listener) continue;
                this.mListeners.remove(i);
            }
        }

        @Override
        public void dispatchThemeChanged(int theme) {
            OnThemeChangedEvent event = new OnThemeChangedEvent(theme);
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                WeakReference<OnThemeChangedListener> ref = this.mListeners.get(i);
                if (ref.get() == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                ((OnThemeChangedListener)ref.get()).onThemeChanged(event);
            }
        }
    }

    public static interface EventDispatcher {
        public void registerListener(OnThemeChangedListener var1);

        public void unregisterListener(OnThemeChangedListener var1);

        public void dispatchThemeChanged(int var1);
    }
}

