/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CompoundButton;
import android.widget.ListAdapter;
import android.widget.ScrollView;
import com.rey.material.R;
import com.rey.material.app.Dialog;
import com.rey.material.drawable.BlankDrawable;
import com.rey.material.widget.CheckBox;
import com.rey.material.widget.ListView;
import com.rey.material.widget.RadioButton;
import com.rey.material.widget.TextView;

public class SimpleDialog
extends Dialog {
    private TextView mMessage;
    private InternalScrollView mScrollView;
    private InternalListView mListView;
    private InternalAdapter mAdapter;
    private int mMessageTextAppearanceId;
    private int mMessageTextColor;
    private int mRadioButtonStyle;
    private int mCheckBoxStyle;
    private int mItemHeight;
    private int mItemTextAppearance;
    private int mMode;
    protected static final int MODE_NONE = 0;
    protected static final int MODE_MESSAGE = 1;
    protected static final int MODE_ITEMS = 2;
    protected static final int MODE_MULTI_ITEMS = 3;
    protected static final int MODE_CUSTOM = 4;
    private OnSelectionChangedListener mOnSelectionChangedListener;

    public SimpleDialog(Context context) {
        super(context, R.style.Material_App_Dialog_Simple_Light);
    }

    public SimpleDialog(Context context, int style2) {
        super(context, style2);
    }

    @Override
    protected void onCreate() {
        this.messageTextAppearance(R.style.TextAppearance_AppCompat_Body1);
        this.itemHeight(-2);
        this.itemTextAppearance(R.style.TextAppearance_AppCompat_Body1);
    }

    @Override
    public Dialog applyStyle(int resId) {
        super.applyStyle(resId);
        if (resId == 0) {
            return this;
        }
        TypedArray a = this.getContext().obtainStyledAttributes(resId, R.styleable.SimpleDialog);
        int textAppearance = 0;
        int textColor = 0;
        boolean textColorDefined = false;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.SimpleDialog_di_messageTextAppearance) {
                textAppearance = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SimpleDialog_di_messageTextColor) {
                textColor = a.getColor(attr2, 0);
                textColorDefined = true;
                continue;
            }
            if (attr2 == R.styleable.SimpleDialog_di_radioButtonStyle) {
                this.radioButtonStyle(a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SimpleDialog_di_checkBoxStyle) {
                this.checkBoxStyle(a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SimpleDialog_di_itemHeight) {
                this.itemHeight(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.SimpleDialog_di_itemTextAppearance) continue;
            this.itemTextAppearance(a.getResourceId(attr2, 0));
        }
        a.recycle();
        if (textAppearance != 0) {
            this.messageTextAppearance(textAppearance);
        }
        if (textColorDefined) {
            this.messageTextColor(textColor);
        }
        return this;
    }

    @Override
    public Dialog clearContent() {
        super.clearContent();
        this.mMode = 0;
        return this;
    }

    @Override
    public Dialog title(CharSequence title) {
        boolean titleVisible = !TextUtils.isEmpty((CharSequence)title);
        this.contentMargin(this.mContentPadding, titleVisible ? 0 : this.mContentPadding, this.mContentPadding, 0);
        return super.title(title);
    }

    @Override
    public Dialog contentView(View v) {
        if (this.mScrollView == null) {
            this.initScrollView();
        }
        if (this.mScrollView.getChildAt(0) != v && v != null) {
            this.mScrollView.removeAllViews();
            this.mScrollView.addView(v);
            this.mMode = 4;
            super.contentView((View)this.mScrollView);
        }
        return this;
    }

    private void initScrollView() {
        this.mScrollView = new InternalScrollView(this.getContext());
        this.mScrollView.setPadding(0, 0, 0, this.mContentPadding - this.mActionPadding);
        this.mScrollView.setClipToPadding(false);
        this.mScrollView.setFillViewport(true);
        this.mScrollView.setScrollBarStyle(0x2000000);
        ViewCompat.setLayoutDirection((View)this.mScrollView, (int)2);
    }

    private void initMessageView() {
        this.mMessage = new TextView(this.getContext());
        this.mMessage.setTextAppearance(this.getContext(), this.mMessageTextAppearanceId);
        this.mMessage.setTextColor(this.mMessageTextColor);
        this.mMessage.setGravity(8388627);
    }

    public SimpleDialog message(CharSequence message) {
        if (this.mScrollView == null) {
            this.initScrollView();
        }
        if (this.mMessage == null) {
            this.initMessageView();
        }
        if (this.mScrollView.getChildAt(0) != this.mMessage) {
            this.mScrollView.removeAllViews();
            this.mScrollView.addView((View)this.mMessage);
        }
        this.mMessage.setText(message);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mMode = 1;
            super.contentView((View)this.mScrollView);
        }
        return this;
    }

    public SimpleDialog message(int id) {
        return this.message(id == 0 ? null : this.getContext().getResources().getString(id));
    }

    public SimpleDialog messageTextAppearance(int resId) {
        if (this.mMessageTextAppearanceId != resId) {
            this.mMessageTextAppearanceId = resId;
            if (this.mMessage != null) {
                this.mMessage.setTextAppearance(this.getContext(), this.mMessageTextAppearanceId);
            }
        }
        return this;
    }

    public SimpleDialog messageTextColor(int color) {
        if (this.mMessageTextColor != color) {
            this.mMessageTextColor = color;
            if (this.mMessage != null) {
                this.mMessage.setTextColor(color);
            }
        }
        return this;
    }

    public SimpleDialog radioButtonStyle(int resId) {
        if (this.mRadioButtonStyle != resId) {
            this.mRadioButtonStyle = resId;
            if (this.mAdapter != null && this.mMode == 2) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
        return this;
    }

    public SimpleDialog checkBoxStyle(int resId) {
        if (this.mCheckBoxStyle != resId) {
            this.mCheckBoxStyle = resId;
            if (this.mAdapter != null && this.mMode == 3) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
        return this;
    }

    public SimpleDialog itemHeight(int height) {
        if (this.mItemHeight != height) {
            this.mItemHeight = height;
            if (this.mAdapter != null) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
        return this;
    }

    public SimpleDialog itemTextAppearance(int resId) {
        if (this.mItemTextAppearance != resId) {
            this.mItemTextAppearance = resId;
            if (this.mAdapter != null) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
        return this;
    }

    private void initListView() {
        this.mListView = new InternalListView(this.getContext());
        this.mListView.setDividerHeight(0);
        this.mListView.setCacheColorHint(0);
        this.mListView.setScrollBarStyle(0x2000000);
        this.mListView.setClipToPadding(false);
        this.mListView.setSelector(BlankDrawable.getInstance());
        this.mListView.setPadding(0, 0, 0, this.mContentPadding - this.mActionPadding);
        this.mListView.setVerticalFadingEdgeEnabled(false);
        this.mListView.setOverScrollMode(2);
        ViewCompat.setLayoutDirection((View)this.mListView, (int)2);
        this.mAdapter = new InternalAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
    }

    public SimpleDialog items(CharSequence[] items, int selectedIndex) {
        if (this.mListView == null) {
            this.initListView();
        }
        this.mMode = 2;
        this.mAdapter.setItems(items, selectedIndex);
        super.contentView((View)this.mListView);
        return this;
    }

    public SimpleDialog multiChoiceItems(CharSequence[] items, int ... selectedIndexes) {
        if (this.mListView == null) {
            this.initListView();
        }
        this.mMode = 3;
        this.mAdapter.setItems(items, selectedIndexes);
        super.contentView((View)this.mListView);
        return this;
    }

    public SimpleDialog onSelectionChangedListener(OnSelectionChangedListener listener) {
        this.mOnSelectionChangedListener = listener;
        return this;
    }

    public int[] getSelectedIndexes() {
        return this.mAdapter == null ? null : this.mAdapter.getSelectedIndexes();
    }

    public CharSequence[] getSelectedValues() {
        return this.mAdapter.getSelectedValues();
    }

    public int getSelectedIndex() {
        return this.mAdapter == null ? -1 : this.mAdapter.getLastSelectedIndex();
    }

    public CharSequence getSelectedValue() {
        return this.mAdapter.getLastSelectedValue();
    }

    public static class Builder
    extends Dialog.Builder
    implements OnSelectionChangedListener {
        protected int mMode;
        protected CharSequence mMessage;
        protected CharSequence[] mItems;
        protected int[] mSelectedIndexes;
        public static final Parcelable.Creator<Builder> CREATOR = new Parcelable.Creator<Builder>(){

            public Builder createFromParcel(Parcel in) {
                return new Builder(in);
            }

            public Builder[] newArray(int size) {
                return new Builder[size];
            }
        };

        public Builder() {
            super(R.style.Material_App_Dialog_Simple_Light);
        }

        public Builder(int styleId) {
            super(styleId);
        }

        public Builder message(CharSequence message) {
            this.mMode = 1;
            this.mMessage = message;
            return this;
        }

        public Builder items(CharSequence[] items, int selectedIndex) {
            this.mMode = 2;
            this.mItems = items;
            this.mSelectedIndexes = new int[]{selectedIndex};
            return this;
        }

        public Builder multiChoiceItems(CharSequence[] items, int ... selectedIndexes) {
            this.mMode = 3;
            this.mItems = items;
            this.mSelectedIndexes = selectedIndexes;
            return this;
        }

        public int getSelectedIndex() {
            if (this.mMode == 2 || this.mMode == 3) {
                return this.mSelectedIndexes[0];
            }
            return -1;
        }

        public CharSequence getSelectedValue() {
            int index = this.getSelectedIndex();
            return index >= 0 ? this.mItems[index] : null;
        }

        public int[] getSelectedIndexes() {
            if (this.mMode == 2 || this.mMode == 3) {
                return this.mSelectedIndexes;
            }
            return null;
        }

        public CharSequence[] getSelectedValues() {
            int[] indexes = this.getSelectedIndexes();
            if (indexes == null || indexes.length == 0) {
                return null;
            }
            CharSequence[] result = new CharSequence[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                result[i] = this.mItems[indexes[i]];
            }
            return result;
        }

        @Override
        protected Dialog onBuild(Context context, int styleId) {
            SimpleDialog dialog = new SimpleDialog(context, styleId);
            switch (this.mMode) {
                case 1: {
                    dialog.message(this.mMessage);
                    break;
                }
                case 2: {
                    dialog.items(this.mItems, this.mSelectedIndexes == null ? 0 : this.mSelectedIndexes[0]);
                    dialog.onSelectionChangedListener(this);
                    break;
                }
                case 3: {
                    dialog.multiChoiceItems(this.mItems, this.mSelectedIndexes);
                    dialog.onSelectionChangedListener(this);
                }
            }
            return dialog;
        }

        @Override
        public void onSelectionChanged(int index, boolean selected) {
            switch (this.mMode) {
                case 2: {
                    if (!selected) break;
                    if (this.mSelectedIndexes == null) {
                        this.mSelectedIndexes = new int[]{index};
                        break;
                    }
                    this.mSelectedIndexes[0] = index;
                    break;
                }
                case 3: {
                    this.mSelectedIndexes = ((SimpleDialog)this.mDialog).getSelectedIndexes();
                }
            }
        }

        protected Builder(Parcel in) {
            super(in);
        }

        @Override
        protected void onReadFromParcel(Parcel in) {
            this.mMode = in.readInt();
            switch (this.mMode) {
                case 1: {
                    this.mMessage = (CharSequence)in.readParcelable(null);
                    break;
                }
                case 2: {
                    Parcelable[] values = in.readParcelableArray(null);
                    if (values != null && values.length > 0) {
                        this.mItems = new CharSequence[values.length];
                        for (int i = 0; i < this.mItems.length; ++i) {
                            this.mItems[i] = (CharSequence)values[i];
                        }
                    } else {
                        this.mItems = null;
                    }
                    this.mSelectedIndexes = new int[]{in.readInt()};
                    break;
                }
                case 3: {
                    int length;
                    Parcelable[] values = in.readParcelableArray(null);
                    if (values != null && values.length > 0) {
                        this.mItems = new CharSequence[values.length];
                        for (int i = 0; i < this.mItems.length; ++i) {
                            this.mItems[i] = (CharSequence)values[i];
                        }
                    } else {
                        this.mItems = null;
                    }
                    if ((length = in.readInt()) <= 0) break;
                    this.mSelectedIndexes = new int[length];
                    in.readIntArray(this.mSelectedIndexes);
                    break;
                }
            }
        }

        @Override
        protected void onWriteToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mMode);
            switch (this.mMode) {
                case 1: {
                    dest.writeValue((Object)this.mMessage);
                    break;
                }
                case 2: {
                    dest.writeArray((Object[])this.mItems);
                    dest.writeInt(this.mSelectedIndexes == null ? 0 : this.mSelectedIndexes[0]);
                    break;
                }
                case 3: {
                    dest.writeArray((Object[])this.mItems);
                    int length = this.mSelectedIndexes == null ? 0 : this.mSelectedIndexes.length;
                    dest.writeInt(length);
                    if (length <= 0) break;
                    dest.writeIntArray(this.mSelectedIndexes);
                }
            }
        }
    }

    private class InternalAdapter
    extends BaseAdapter
    implements CompoundButton.OnCheckedChangeListener {
        private CharSequence[] mItems;
        private boolean[] mSelected;
        private int mLastSelectedIndex;

        private InternalAdapter() {
        }

        public void setItems(CharSequence[] items, int ... selectedIndexes) {
            this.mItems = items;
            if (this.mSelected == null || this.mSelected.length != items.length) {
                this.mSelected = new boolean[items.length];
            }
            for (int i = 0; i < this.mSelected.length; ++i) {
                this.mSelected[i] = false;
            }
            if (selectedIndexes != null) {
                for (int index : selectedIndexes) {
                    if (index < 0 || index >= this.mSelected.length) continue;
                    this.mSelected[index] = true;
                    this.mLastSelectedIndex = index;
                }
            }
            this.notifyDataSetChanged();
        }

        public int getLastSelectedIndex() {
            return this.mLastSelectedIndex;
        }

        public CharSequence getLastSelectedValue() {
            return this.mItems[this.mLastSelectedIndex];
        }

        public int[] getSelectedIndexes() {
            int count = 0;
            for (int i = 0; i < this.mSelected.length; ++i) {
                if (!this.mSelected[i]) continue;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            int[] result = new int[count];
            count = 0;
            for (int i = 0; i < this.mSelected.length; ++i) {
                if (!this.mSelected[i]) continue;
                result[count] = i;
                ++count;
            }
            return result;
        }

        public CharSequence[] getSelectedValues() {
            int count = 0;
            for (int i = 0; i < this.mSelected.length; ++i) {
                if (!this.mSelected[i]) continue;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            CharSequence[] result = new CharSequence[count];
            count = 0;
            for (int i = 0; i < this.mSelected.length; ++i) {
                if (!this.mSelected[i]) continue;
                result[count] = this.mItems[i];
                ++count;
            }
            return result;
        }

        public int getCount() {
            return this.mItems == null ? 0 : this.mItems.length;
        }

        public Object getItem(int position) {
            return this.mItems == null ? Integer.valueOf(0) : this.mItems[position];
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            com.rey.material.widget.CompoundButton v = (com.rey.material.widget.CompoundButton)convertView;
            if (v == null) {
                com.rey.material.widget.CompoundButton compoundButton = v = SimpleDialog.this.mMode == 3 ? new CheckBox(parent.getContext(), null, 0, SimpleDialog.this.mCheckBoxStyle) : new RadioButton(parent.getContext(), null, 0, SimpleDialog.this.mRadioButtonStyle);
                if (SimpleDialog.this.mItemHeight != -2) {
                    v.setMinHeight(SimpleDialog.this.mItemHeight);
                }
                v.setGravity(8388627);
                if (Build.VERSION.SDK_INT >= 17) {
                    v.setTextDirection(((InternalListView)parent).isLayoutRtl() ? 4 : 3);
                }
                v.setTextAppearance(v.getContext(), SimpleDialog.this.mItemTextAppearance);
                ViewCompat.setPaddingRelative((View)v, (int)SimpleDialog.this.mContentPadding, (int)0, (int)0, (int)0);
            }
            v.setTag(position);
            v.setText(this.mItems[position]);
            if (v instanceof CheckBox) {
                ((CheckBox)v).setCheckedImmediately(this.mSelected[position]);
            } else {
                ((RadioButton)v).setCheckedImmediately(this.mSelected[position]);
            }
            v.setOnCheckedChangeListener(this);
            return v;
        }

        public void onCheckedChanged(CompoundButton v, boolean isChecked) {
            int position = (Integer)v.getTag();
            if (this.mSelected[position] != isChecked) {
                this.mSelected[position] = isChecked;
                if (SimpleDialog.this.mOnSelectionChangedListener != null) {
                    SimpleDialog.this.mOnSelectionChangedListener.onSelectionChanged(position, this.mSelected[position]);
                }
            }
            if (SimpleDialog.this.mMode == 2 && isChecked && this.mLastSelectedIndex != position) {
                com.rey.material.widget.CompoundButton child;
                this.mSelected[this.mLastSelectedIndex] = false;
                if (SimpleDialog.this.mOnSelectionChangedListener != null) {
                    SimpleDialog.this.mOnSelectionChangedListener.onSelectionChanged(this.mLastSelectedIndex, false);
                }
                if ((child = (com.rey.material.widget.CompoundButton)SimpleDialog.this.mListView.getChildAt(this.mLastSelectedIndex - SimpleDialog.this.mListView.getFirstVisiblePosition())) != null) {
                    child.setChecked(false);
                }
                this.mLastSelectedIndex = position;
            }
        }
    }

    private class InternalListView
    extends ListView {
        private boolean mIsRtl;

        public InternalListView(Context context) {
            super(context);
            this.mIsRtl = false;
        }

        public void onRtlPropertiesChanged(int layoutDirection) {
            boolean rtl;
            boolean bl = rtl = layoutDirection == 1;
            if (this.mIsRtl != rtl) {
                this.mIsRtl = rtl;
                this.requestLayout();
            }
        }

        public boolean isLayoutRtl() {
            return this.mIsRtl;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (heightMode == 0 && SimpleDialog.this.mItemHeight != -2) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(SimpleDialog.this.mItemHeight * this.getAdapter().getCount() + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            int totalHeight = 0;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                totalHeight += this.getChildAt(i).getMeasuredHeight();
            }
            SimpleDialog.this.showDivider(totalHeight > this.getMeasuredHeight() || totalHeight == this.getMeasuredHeight() && this.getAdapter().getCount() > childCount);
        }
    }

    private class InternalScrollView
    extends ScrollView {
        private boolean mIsRtl;

        public InternalScrollView(Context context) {
            super(context);
            this.mIsRtl = false;
        }

        public void onRtlPropertiesChanged(int layoutDirection) {
            boolean rtl;
            boolean bl = rtl = layoutDirection == 1;
            if (this.mIsRtl != rtl) {
                View v;
                this.mIsRtl = rtl;
                if (Build.VERSION.SDK_INT >= 17 && (v = this.getChildAt(0)) != null && v == SimpleDialog.this.mMessage) {
                    SimpleDialog.this.mMessage.setTextDirection(this.mIsRtl ? 4 : 3);
                }
                this.requestLayout();
            }
        }

        public boolean isLayoutRtl() {
            return this.mIsRtl;
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            View child = this.getChildAt(0);
            SimpleDialog.this.showDivider(child != null && child.getMeasuredHeight() > this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        }
    }

    public static interface OnSelectionChangedListener {
        public void onSelectionChanged(int var1, boolean var2);
    }
}

