/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.rey.material.R;
import com.rey.material.drawable.LineMorphingDrawable;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.RippleManager;

public class FloatingActionButton
extends View {
    private OvalShadowDrawable mBackground;
    private Drawable mIcon;
    private Drawable mPrevIcon;
    private int mAnimDuration;
    private Interpolator mInterpolator;
    private SwitchIconAnimator mSwitchIconAnimator;
    private int mIconSize;
    private RippleManager mRippleManager;

    public static FloatingActionButton make(Context context, int resId) {
        return new FloatingActionButton(context, null, resId);
    }

    public FloatingActionButton(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setClickable(true);
        this.mSwitchIconAnimator = new SwitchIconAnimator();
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionButton, defStyleAttr, defStyleRes);
        int radius = a.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_radius, ThemeUtil.dpToPx(context, 28));
        int elevation = a.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_elevation, ThemeUtil.dpToPx(context, 4));
        int bgColor = a.getColor(R.styleable.FloatingActionButton_fab_backgroundColor, ThemeUtil.colorAccent(context, -328966));
        int iconSrc = a.getResourceId(R.styleable.FloatingActionButton_fab_iconSrc, 0);
        int iconLineMorphing = a.getResourceId(R.styleable.FloatingActionButton_fab_iconLineMorphing, 0);
        this.mIconSize = a.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_iconSize, ThemeUtil.dpToPx(context, 24));
        this.mAnimDuration = a.getInteger(R.styleable.FloatingActionButton_fab_animDuration, context.getResources().getInteger(0x10E0001));
        int resId = a.getResourceId(R.styleable.FloatingActionButton_fab_interpolator, 0);
        if (resId != 0) {
            this.mInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)resId);
        } else if (this.mInterpolator == null) {
            this.mInterpolator = new DecelerateInterpolator();
        }
        a.recycle();
        this.mBackground = new OvalShadowDrawable(radius, bgColor, elevation, elevation);
        this.mBackground.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (iconLineMorphing != 0) {
            this.setIcon(new LineMorphingDrawable.Builder(context, iconLineMorphing).build(), false);
        } else if (iconSrc != 0) {
            this.setIcon(context.getResources().getDrawable(iconSrc), false);
        }
        this.getRippleManager().onCreate(this, context, attrs, defStyleAttr, defStyleRes);
        Drawable background = this.getBackground();
        if (background != null && background instanceof RippleDrawable) {
            RippleDrawable drawable = (RippleDrawable)background;
            drawable.setBackgroundDrawable(null);
            drawable.setMask(1, 0, 0, 0, 0, (int)this.mBackground.getPaddingLeft(), (int)this.mBackground.getPaddingTop(), (int)this.mBackground.getPaddingRight(), (int)this.mBackground.getPaddingBottom());
        }
        this.setClickable(true);
    }

    public int getRadius() {
        return this.mBackground.getRadius();
    }

    public void setRadius(int radius) {
        if (this.mBackground.setRadius(radius)) {
            this.requestLayout();
        }
    }

    @TargetApi(value=21)
    public float getElevation() {
        if (Build.VERSION.SDK_INT >= 21) {
            return super.getElevation();
        }
        return this.mBackground.getShadowSize();
    }

    @TargetApi(value=21)
    public void setElevation(float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            super.setElevation(elevation);
        } else if (this.mBackground.setShadow(elevation, elevation)) {
            this.requestLayout();
        }
    }

    public int getLineMorphingState() {
        if (this.mIcon != null && this.mIcon instanceof LineMorphingDrawable) {
            return ((LineMorphingDrawable)this.mIcon).getLineState();
        }
        return -1;
    }

    public void setLineMorphingState(int state, boolean animation) {
        if (this.mIcon != null && this.mIcon instanceof LineMorphingDrawable) {
            ((LineMorphingDrawable)this.mIcon).switchLineState(state, animation);
        }
    }

    public int getBackgroundColor() {
        return this.mBackground.getColor();
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public void setIcon(Drawable icon, boolean animation) {
        if (icon == null) {
            return;
        }
        if (animation) {
            this.mSwitchIconAnimator.startAnimation(icon);
            this.invalidate();
        } else {
            if (this.mIcon != null) {
                this.mIcon.setCallback(null);
                this.unscheduleDrawable(this.mIcon);
            }
            this.mIcon = icon;
            float half = (float)this.mIconSize / 2.0f;
            this.mIcon.setBounds((int)(this.mBackground.getCenterX() - half), (int)(this.mBackground.getCenterY() - half), (int)(this.mBackground.getCenterX() + half), (int)(this.mBackground.getCenterY() + half));
            this.mIcon.setCallback((Drawable.Callback)this);
            this.invalidate();
        }
    }

    public void setBackgroundColor(int color) {
        this.mBackground.setColor(color);
        this.invalidate();
    }

    public void show(Activity activity, int x, int y, int gravity) {
        if (this.getParent() == null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.mBackground.getIntrinsicWidth(), this.mBackground.getIntrinsicHeight());
            this.updateParams(x, y, gravity, (ViewGroup.LayoutParams)params);
            activity.getWindow().addContentView((View)this, (ViewGroup.LayoutParams)params);
        } else {
            this.updateLocation(x, y, gravity);
        }
    }

    public void show(ViewGroup parent, int x, int y, int gravity) {
        if (this.getParent() == null) {
            ViewGroup.LayoutParams params = parent.generateLayoutParams(null);
            params.width = this.mBackground.getIntrinsicWidth();
            params.height = this.mBackground.getIntrinsicHeight();
            this.updateParams(x, y, gravity, params);
            parent.addView((View)this, params);
        } else {
            this.updateLocation(x, y, gravity);
        }
    }

    public void updateLocation(int x, int y, int gravity) {
        if (this.getParent() != null) {
            this.updateParams(x, y, gravity, this.getLayoutParams());
        } else {
            Log.v((String)FloatingActionButton.class.getSimpleName(), (String)"updateLocation() is called without parent");
        }
    }

    private void updateParams(int x, int y, int gravity, ViewGroup.LayoutParams params) {
        int horizontalGravity = gravity & 7;
        switch (horizontalGravity) {
            case 3: {
                this.setLeftMargin(params, (int)((float)x - this.mBackground.getPaddingLeft()));
                break;
            }
            case 1: {
                this.setLeftMargin(params, (int)((float)x - this.mBackground.getCenterX()));
                break;
            }
            case 5: {
                this.setLeftMargin(params, (int)((float)x - this.mBackground.getPaddingLeft() - (float)(this.mBackground.getRadius() * 2)));
                break;
            }
            default: {
                this.setLeftMargin(params, (int)((float)x - this.mBackground.getPaddingLeft()));
            }
        }
        int verticalGravity = gravity & 0x70;
        switch (verticalGravity) {
            case 48: {
                this.setTopMargin(params, (int)((float)y - this.mBackground.getPaddingTop()));
                break;
            }
            case 16: {
                this.setTopMargin(params, (int)((float)y - this.mBackground.getCenterY()));
                break;
            }
            case 80: {
                this.setTopMargin(params, (int)((float)y - this.mBackground.getPaddingTop() - (float)(this.mBackground.getRadius() * 2)));
                break;
            }
            default: {
                this.setTopMargin(params, (int)((float)y - this.mBackground.getPaddingTop()));
            }
        }
        this.setLayoutParams(params);
    }

    private void setLeftMargin(ViewGroup.LayoutParams params, int value) {
        if (params instanceof FrameLayout.LayoutParams) {
            ((FrameLayout.LayoutParams)params).leftMargin = value;
        } else if (params instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)params).leftMargin = value;
        } else {
            Log.v((String)FloatingActionButton.class.getSimpleName(), (String)("cannot recognize LayoutParams: " + params));
        }
    }

    private void setTopMargin(ViewGroup.LayoutParams params, int value) {
        if (params instanceof FrameLayout.LayoutParams) {
            ((FrameLayout.LayoutParams)params).topMargin = value;
        } else if (params instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)params).topMargin = value;
        } else {
            Log.v((String)FloatingActionButton.class.getSimpleName(), (String)("cannot recognize LayoutParams: " + params));
        }
    }

    public void dismiss() {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || this.mBackground == who || this.mIcon == who || this.mPrevIcon == who;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mBackground.getIntrinsicWidth(), this.mBackground.getIntrinsicHeight());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float half;
        this.mBackground.setBounds(0, 0, w, h);
        if (this.mIcon != null) {
            half = (float)this.mIconSize / 2.0f;
            this.mIcon.setBounds((int)(this.mBackground.getCenterX() - half), (int)(this.mBackground.getCenterY() - half), (int)(this.mBackground.getCenterX() + half), (int)(this.mBackground.getCenterY() + half));
        }
        if (this.mPrevIcon != null) {
            half = (float)this.mIconSize / 2.0f;
            this.mPrevIcon.setBounds((int)(this.mBackground.getCenterX() - half), (int)(this.mBackground.getCenterY() - half), (int)(this.mBackground.getCenterX() + half), (int)(this.mBackground.getCenterY() + half));
        }
    }

    public void draw(@NonNull Canvas canvas) {
        this.mBackground.draw(canvas);
        super.draw(canvas);
        if (this.mPrevIcon != null) {
            this.mPrevIcon.draw(canvas);
        }
        if (this.mIcon != null) {
            this.mIcon.draw(canvas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RippleManager getRippleManager() {
        if (this.mRippleManager != null) return this.mRippleManager;
        Class<RippleManager> clazz = RippleManager.class;
        synchronized (RippleManager.class) {
            if (this.mRippleManager != null) return this.mRippleManager;
            this.mRippleManager = new RippleManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mRippleManager;
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        RippleManager rippleManager = this.getRippleManager();
        if (l == rippleManager) {
            super.setOnClickListener(l);
        } else {
            rippleManager.setOnClickListener(l);
            this.setOnClickListener(rippleManager);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 0 && !this.mBackground.isPointerOver(event.getX(), event.getY())) {
            return false;
        }
        boolean result = super.onTouchEvent(event);
        return this.getRippleManager().onTouchEvent(event) || result;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.state = this.getLineMorphingState();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.state >= 0) {
            this.setLineMorphingState(ss.state, false);
        }
        this.requestLayout();
    }

    class SwitchIconAnimator
    implements Runnable {
        boolean mRunning = false;
        long mStartTime;

        SwitchIconAnimator() {
        }

        public void resetAnimation() {
            this.mStartTime = SystemClock.uptimeMillis();
            FloatingActionButton.this.mIcon.setAlpha(0);
            FloatingActionButton.this.mPrevIcon.setAlpha(255);
        }

        public boolean startAnimation(Drawable icon) {
            if (FloatingActionButton.this.mIcon == icon) {
                return false;
            }
            FloatingActionButton.this.mPrevIcon = FloatingActionButton.this.mIcon;
            FloatingActionButton.this.mIcon = icon;
            float half = (float)FloatingActionButton.this.mIconSize / 2.0f;
            FloatingActionButton.this.mIcon.setBounds((int)(FloatingActionButton.this.mBackground.getCenterX() - half), (int)(FloatingActionButton.this.mBackground.getCenterY() - half), (int)(FloatingActionButton.this.mBackground.getCenterX() + half), (int)(FloatingActionButton.this.mBackground.getCenterY() + half));
            FloatingActionButton.this.mIcon.setCallback((Drawable.Callback)FloatingActionButton.this);
            if (FloatingActionButton.this.getHandler() != null) {
                this.resetAnimation();
                this.mRunning = true;
                FloatingActionButton.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
            } else {
                FloatingActionButton.this.mPrevIcon.setCallback(null);
                FloatingActionButton.this.unscheduleDrawable(FloatingActionButton.this.mPrevIcon);
                FloatingActionButton.this.mPrevIcon = null;
            }
            FloatingActionButton.this.invalidate();
            return true;
        }

        public void stopAnimation() {
            this.mRunning = false;
            FloatingActionButton.this.mPrevIcon.setCallback(null);
            FloatingActionButton.this.unscheduleDrawable(FloatingActionButton.this.mPrevIcon);
            FloatingActionButton.this.mPrevIcon = null;
            FloatingActionButton.this.mIcon.setAlpha(255);
            if (FloatingActionButton.this.getHandler() != null) {
                FloatingActionButton.this.getHandler().removeCallbacks((Runnable)this);
            }
            FloatingActionButton.this.invalidate();
        }

        @Override
        public void run() {
            long curTime = SystemClock.uptimeMillis();
            float progress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)FloatingActionButton.this.mAnimDuration);
            float value = FloatingActionButton.this.mInterpolator.getInterpolation(progress);
            FloatingActionButton.this.mIcon.setAlpha(Math.round(255.0f * value));
            FloatingActionButton.this.mPrevIcon.setAlpha(Math.round(255.0f * (1.0f - value)));
            if (progress == 1.0f) {
                this.stopAnimation();
            }
            if (this.mRunning) {
                if (FloatingActionButton.this.getHandler() != null) {
                    FloatingActionButton.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                } else {
                    this.stopAnimation();
                }
            }
            FloatingActionButton.this.invalidate();
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int state;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.state = in.readInt();
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
        }

        public String toString() {
            return "FloatingActionButton.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " state=" + this.state + "}";
        }
    }

    private class OvalShadowDrawable
    extends Drawable {
        private Paint mShadowPaint;
        private Paint mGlowPaint;
        private Paint mPaint;
        private int mRadius;
        private float mShadowSize;
        private float mShadowOffset;
        private Path mShadowPath;
        private Path mGlowPath;
        private RectF mTempRect = new RectF();
        private int mColor;
        private boolean mNeedBuildShadow = true;
        private static final int COLOR_SHADOW_START = 0x4C000000;
        private static final int COLOR_SHADOW_END = 0;

        public OvalShadowDrawable(int radius, int color, float shadowSize, float shadowOffset) {
            this.mPaint = new Paint(5);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.setColor(color);
            this.setRadius(radius);
            this.setShadow(shadowSize, shadowOffset);
        }

        public boolean setRadius(int radius) {
            if (this.mRadius != radius) {
                this.mRadius = radius;
                this.mNeedBuildShadow = true;
                this.invalidateSelf();
                return true;
            }
            return false;
        }

        public boolean setShadow(float size, float offset) {
            if (this.mShadowSize != size || this.mShadowOffset != offset) {
                this.mShadowSize = size;
                this.mShadowOffset = offset;
                this.mNeedBuildShadow = true;
                this.invalidateSelf();
                return true;
            }
            return false;
        }

        public void setColor(int color) {
            if (this.mColor != color) {
                this.mColor = color;
                this.mPaint.setColor(this.mColor);
                this.invalidateSelf();
            }
        }

        public int getColor() {
            return this.mColor;
        }

        public int getRadius() {
            return this.mRadius;
        }

        public float getShadowSize() {
            return this.mShadowSize;
        }

        public float getShadowOffset() {
            return this.mShadowOffset;
        }

        public float getPaddingLeft() {
            return this.mShadowSize;
        }

        public float getPaddingTop() {
            return this.mShadowSize;
        }

        public float getPaddingRight() {
            return this.mShadowSize;
        }

        public float getPaddingBottom() {
            return this.mShadowSize + this.mShadowOffset;
        }

        public float getCenterX() {
            return (float)this.mRadius + this.mShadowSize;
        }

        public float getCenterY() {
            return (float)this.mRadius + this.mShadowSize;
        }

        public boolean isPointerOver(float x, float y) {
            float distance = (float)Math.sqrt(Math.pow(x - this.getCenterX(), 2.0) + Math.pow(y - this.getCenterY(), 2.0));
            return distance < (float)this.mRadius;
        }

        public int getIntrinsicWidth() {
            return (int)(((float)this.mRadius + this.mShadowSize) * 2.0f + 0.5f);
        }

        public int getIntrinsicHeight() {
            return (int)(((float)this.mRadius + this.mShadowSize) * 2.0f + this.mShadowOffset + 0.5f);
        }

        private void buildShadow() {
            if (this.mShadowSize <= 0.0f) {
                return;
            }
            if (this.mShadowPaint == null) {
                this.mShadowPaint = new Paint(5);
                this.mShadowPaint.setStyle(Paint.Style.FILL);
                this.mShadowPaint.setDither(true);
            }
            float startRatio = (float)this.mRadius / ((float)this.mRadius + this.mShadowSize + this.mShadowOffset);
            this.mShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)this.mRadius + this.mShadowSize, new int[]{0x4C000000, 0x4C000000, 0}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
            if (this.mShadowPath == null) {
                this.mShadowPath = new Path();
                this.mShadowPath.setFillType(Path.FillType.EVEN_ODD);
            } else {
                this.mShadowPath.reset();
            }
            float radius = (float)this.mRadius + this.mShadowSize;
            this.mTempRect.set(-radius, -radius, radius, radius);
            this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
            radius = this.mRadius - 1;
            this.mTempRect.set(-radius, -radius - this.mShadowOffset, radius, radius - this.mShadowOffset);
            this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
            if (this.mGlowPaint == null) {
                this.mGlowPaint = new Paint(5);
                this.mGlowPaint.setStyle(Paint.Style.FILL);
                this.mGlowPaint.setDither(true);
            }
            startRatio = ((float)this.mRadius - this.mShadowSize / 2.0f) / ((float)this.mRadius + this.mShadowSize / 2.0f);
            this.mGlowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)this.mRadius + this.mShadowSize / 2.0f, new int[]{0x4C000000, 0x4C000000, 0}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
            if (this.mGlowPath == null) {
                this.mGlowPath = new Path();
                this.mGlowPath.setFillType(Path.FillType.EVEN_ODD);
            } else {
                this.mGlowPath.reset();
            }
            radius = (float)this.mRadius + this.mShadowSize / 2.0f;
            this.mTempRect.set(-radius, -radius, radius, radius);
            this.mGlowPath.addOval(this.mTempRect, Path.Direction.CW);
            radius = this.mRadius - 1;
            this.mTempRect.set(-radius, -radius, radius, radius);
            this.mGlowPath.addOval(this.mTempRect, Path.Direction.CW);
        }

        public void draw(Canvas canvas) {
            int saveCount;
            if (this.mNeedBuildShadow) {
                this.buildShadow();
                this.mNeedBuildShadow = false;
            }
            if (this.mShadowSize > 0.0f) {
                saveCount = canvas.save();
                canvas.translate(this.mShadowSize + (float)this.mRadius, this.mShadowSize + (float)this.mRadius + this.mShadowOffset);
                canvas.drawPath(this.mShadowPath, this.mShadowPaint);
                canvas.restoreToCount(saveCount);
            }
            saveCount = canvas.save();
            canvas.translate(this.mShadowSize + (float)this.mRadius, this.mShadowSize + (float)this.mRadius);
            if (this.mShadowSize > 0.0f) {
                canvas.drawPath(this.mGlowPath, this.mGlowPaint);
            }
            this.mTempRect.set((float)(-this.mRadius), (float)(-this.mRadius), (float)this.mRadius, (float)this.mRadius);
            canvas.drawOval(this.mTempRect, this.mPaint);
            canvas.restoreToCount(saveCount);
        }

        public void setAlpha(int alpha) {
            this.mShadowPaint.setAlpha(alpha);
            this.mPaint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.mShadowPaint.setColorFilter(cf);
            this.mPaint.setColorFilter(cf);
        }

        public int getOpacity() {
            return -3;
        }
    }
}

