/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import com.rey.material.R;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;

public class CheckBoxDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private Paint mPaint;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration;
    private int mStrokeSize;
    private int mWidth;
    private int mHeight;
    private int mCornerRadius;
    private int mBoxSize;
    private int mTickColor;
    private int mPrevColor;
    private int mCurColor;
    private ColorStateList mStrokeColor;
    private RectF mBoxRect;
    private Path mTickPath;
    private float mTickPathProgress = -1.0f;
    private boolean mChecked = false;
    private boolean mInEditMode = false;
    private boolean mAnimEnable = true;
    private static final float[] TICK_DATA = new float[]{0.0f, 0.473f, 0.367f, 0.839f, 1.0f, 0.207f};
    private static final float FILL_TIME = 0.4f;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            CheckBoxDrawable.this.update();
        }
    };

    private CheckBoxDrawable(int width, int height, int boxSize, int cornerRadius, int strokeSize, ColorStateList strokeColor, int tickColor, int animDuration) {
        this.mWidth = width;
        this.mHeight = height;
        this.mBoxSize = boxSize;
        this.mCornerRadius = cornerRadius;
        this.mStrokeSize = strokeSize;
        this.mStrokeColor = strokeColor;
        this.mTickColor = tickColor;
        this.mAnimDuration = animDuration;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mBoxRect = new RectF();
        this.mTickPath = new Path();
    }

    public void setInEditMode(boolean b) {
        this.mInEditMode = b;
    }

    public void setAnimEnable(boolean b) {
        this.mAnimEnable = b;
    }

    public boolean isAnimEnable() {
        return this.mAnimEnable;
    }

    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mHeight;
    }

    public int getMinimumWidth() {
        return this.mWidth;
    }

    public int getMinimumHeight() {
        return this.mHeight;
    }

    public boolean isStateful() {
        return true;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mBoxRect.set(bounds.exactCenterX() - (float)(this.mBoxSize / 2), bounds.exactCenterY() - (float)(this.mBoxSize / 2), bounds.exactCenterX() + (float)(this.mBoxSize / 2), bounds.exactCenterY() + (float)(this.mBoxSize / 2));
    }

    public void draw(Canvas canvas) {
        if (this.mChecked) {
            this.drawChecked(canvas);
        } else {
            this.drawUnchecked(canvas);
        }
    }

    private Path getTickPath(Path path, float x, float y, float size, float progress, boolean in) {
        if (this.mTickPathProgress == progress) {
            return path;
        }
        this.mTickPathProgress = progress;
        float x1 = x + size * TICK_DATA[0];
        float y1 = y + size * TICK_DATA[1];
        float x2 = x + size * TICK_DATA[2];
        float y2 = y + size * TICK_DATA[3];
        float x3 = x + size * TICK_DATA[4];
        float y3 = y + size * TICK_DATA[5];
        float d1 = (float)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        float d2 = (float)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        float midProgress = d1 / (d1 + d2);
        path.reset();
        if (in) {
            path.moveTo(x1, y1);
            if (progress < midProgress) {
                path.lineTo(x1 * (1.0f - (progress /= midProgress)) + x2 * progress, y1 * (1.0f - progress) + y2 * progress);
            } else {
                progress = (progress - midProgress) / (1.0f - midProgress);
                path.lineTo(x2, y2);
                path.lineTo(x2 * (1.0f - progress) + x3 * progress, y2 * (1.0f - progress) + y3 * progress);
            }
        } else {
            path.moveTo(x3, y3);
            if (progress < midProgress) {
                path.lineTo(x2, y2);
                path.lineTo(x1 * (1.0f - (progress /= midProgress)) + x2 * progress, y1 * (1.0f - progress) + y2 * progress);
            } else {
                progress = (progress - midProgress) / (1.0f - midProgress);
                path.lineTo(x2 * (1.0f - progress) + x3 * progress, y2 * (1.0f - progress) + y3 * progress);
            }
        }
        return path;
    }

    private void drawChecked(Canvas canvas) {
        float size = this.mBoxSize - this.mStrokeSize * 2;
        float x = this.mBoxRect.left + (float)this.mStrokeSize;
        float y = this.mBoxRect.top + (float)this.mStrokeSize;
        if (this.isRunning()) {
            if (this.mAnimProgress < 0.4f) {
                float progress = this.mAnimProgress / 0.4f;
                float fillWidth = (float)(this.mBoxSize - this.mStrokeSize) / 2.0f * progress;
                float padding = (float)this.mStrokeSize / 2.0f + fillWidth / 2.0f - 0.5f;
                this.mPaint.setColor(ColorUtil.getMiddleColor(this.mPrevColor, this.mCurColor, progress));
                this.mPaint.setStrokeWidth(fillWidth);
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawRect(this.mBoxRect.left + padding, this.mBoxRect.top + padding, this.mBoxRect.right - padding, this.mBoxRect.bottom - padding, this.mPaint);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                canvas.drawRoundRect(this.mBoxRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
            } else {
                float progress = (this.mAnimProgress - 0.4f) / 0.6f;
                this.mPaint.setColor(this.mCurColor);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                canvas.drawRoundRect(this.mBoxRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeJoin(Paint.Join.MITER);
                this.mPaint.setStrokeCap(Paint.Cap.BUTT);
                this.mPaint.setColor(this.mTickColor);
                canvas.drawPath(this.getTickPath(this.mTickPath, x, y, size, progress, true), this.mPaint);
            }
        } else {
            this.mPaint.setColor(this.mCurColor);
            this.mPaint.setStrokeWidth((float)this.mStrokeSize);
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            canvas.drawRoundRect(this.mBoxRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeJoin(Paint.Join.MITER);
            this.mPaint.setStrokeCap(Paint.Cap.BUTT);
            this.mPaint.setColor(this.mTickColor);
            canvas.drawPath(this.getTickPath(this.mTickPath, x, y, size, 1.0f, true), this.mPaint);
        }
    }

    private void drawUnchecked(Canvas canvas) {
        if (this.isRunning()) {
            if (this.mAnimProgress < 0.6f) {
                float size = this.mBoxSize - this.mStrokeSize * 2;
                float x = this.mBoxRect.left + (float)this.mStrokeSize;
                float y = this.mBoxRect.top + (float)this.mStrokeSize;
                float progress = this.mAnimProgress / 0.6f;
                this.mPaint.setColor(this.mPrevColor);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                canvas.drawRoundRect(this.mBoxRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeJoin(Paint.Join.MITER);
                this.mPaint.setStrokeCap(Paint.Cap.BUTT);
                this.mPaint.setColor(this.mTickColor);
                canvas.drawPath(this.getTickPath(this.mTickPath, x, y, size, progress, false), this.mPaint);
            } else {
                float progress = (this.mAnimProgress + 0.4f - 1.0f) / 0.4f;
                float fillWidth = (float)(this.mBoxSize - this.mStrokeSize) / 2.0f * (1.0f - progress);
                float padding = (float)this.mStrokeSize / 2.0f + fillWidth / 2.0f - 0.5f;
                this.mPaint.setColor(ColorUtil.getMiddleColor(this.mPrevColor, this.mCurColor, progress));
                this.mPaint.setStrokeWidth(fillWidth);
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawRect(this.mBoxRect.left + padding, this.mBoxRect.top + padding, this.mBoxRect.right - padding, this.mBoxRect.bottom - padding, this.mPaint);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                canvas.drawRoundRect(this.mBoxRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
            }
        } else {
            this.mPaint.setColor(this.mCurColor);
            this.mPaint.setStrokeWidth((float)this.mStrokeSize);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawRoundRect(this.mBoxRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
        }
    }

    protected boolean onStateChange(int[] state) {
        boolean checked = ViewUtil.hasState(state, 0x10100A0);
        int color = this.mStrokeColor.getColorForState(state, this.mCurColor);
        boolean needRedraw = false;
        if (this.mChecked != checked) {
            this.mChecked = checked;
            needRedraw = true;
            if (!this.mInEditMode && this.mAnimEnable) {
                this.start();
            }
        }
        if (this.mCurColor != color) {
            this.mPrevColor = this.isRunning() ? this.mCurColor : color;
            this.mCurColor = color;
            needRedraw = true;
        } else if (!this.isRunning()) {
            this.mPrevColor = color;
        }
        return needRedraw;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.mRunning = false;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    public static class Builder {
        private int mAnimDuration = 400;
        private int mStrokeSize = 4;
        private int mWidth = 64;
        private int mHeight = 64;
        private ColorStateList mStrokeColor;
        private int mCornerRadius = 8;
        private int mBoxSize = 32;
        private int mTickColor = -1;

        public Builder() {
        }

        public Builder(Context context, int defStyleRes) {
            this(context, null, 0, defStyleRes);
        }

        public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckBoxDrawable, defStyleAttr, defStyleRes);
            this.width(a.getDimensionPixelSize(R.styleable.CheckBoxDrawable_cbd_width, ThemeUtil.dpToPx(context, 32)));
            this.height(a.getDimensionPixelSize(R.styleable.CheckBoxDrawable_cbd_height, ThemeUtil.dpToPx(context, 32)));
            this.boxSize(a.getDimensionPixelSize(R.styleable.CheckBoxDrawable_cbd_boxSize, ThemeUtil.dpToPx(context, 18)));
            this.cornerRadius(a.getDimensionPixelSize(R.styleable.CheckBoxDrawable_cbd_cornerRadius, ThemeUtil.dpToPx(context, 2)));
            this.strokeSize(a.getDimensionPixelSize(R.styleable.CheckBoxDrawable_cbd_strokeSize, ThemeUtil.dpToPx(context, 2)));
            this.strokeColor(a.getColorStateList(R.styleable.CheckBoxDrawable_cbd_strokeColor));
            this.tickColor(a.getColor(R.styleable.CheckBoxDrawable_cbd_tickColor, -1));
            this.animDuration(a.getInt(R.styleable.CheckBoxDrawable_cbd_animDuration, context.getResources().getInteger(0x10E0001)));
            a.recycle();
            if (this.mStrokeColor == null) {
                int[][] states = new int[][]{{-16842912}, {0x10100A0}};
                int[] colors = new int[]{ThemeUtil.colorControlNormal(context, -16777216), ThemeUtil.colorControlActivated(context, -16777216)};
                this.strokeColor(new ColorStateList((int[][])states, colors));
            }
        }

        public CheckBoxDrawable build() {
            if (this.mStrokeColor == null) {
                this.mStrokeColor = ColorStateList.valueOf((int)-16777216);
            }
            return new CheckBoxDrawable(this.mWidth, this.mHeight, this.mBoxSize, this.mCornerRadius, this.mStrokeSize, this.mStrokeColor, this.mTickColor, this.mAnimDuration);
        }

        public Builder width(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder height(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder strokeSize(int size) {
            this.mStrokeSize = size;
            return this;
        }

        public Builder strokeColor(int color) {
            this.mStrokeColor = ColorStateList.valueOf((int)color);
            return this;
        }

        public Builder strokeColor(ColorStateList color) {
            this.mStrokeColor = color;
            return this;
        }

        public Builder tickColor(int color) {
            this.mTickColor = color;
            return this;
        }

        public Builder cornerRadius(int radius) {
            this.mCornerRadius = radius;
            return this;
        }

        public Builder boxSize(int size) {
            this.mBoxSize = size;
            return this;
        }

        public Builder animDuration(int duration) {
            this.mAnimDuration = duration;
            return this;
        }
    }
}

